/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.util;

import baubles.api.BaublesApi;
import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.nbt.helper.NBTList;
import chbachman.api.upgrade.IUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class BaublesUtil {
    public static boolean doesPlayerHaveUpgrade(EntityPlayer player, IUpgrade upgrade) {
        ItemStack[] armourArray;
        for (ItemStack armour : armourArray = player.field_71071_by.field_70460_b) {
            if (!BaublesUtil.doesItemStackContainUpgrade(armour, upgrade)) continue;
            return true;
        }
        IInventory inventory = BaublesApi.getBaubles((EntityPlayer)player);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack bauble = inventory.func_70301_a(i);
            if (!BaublesUtil.doesItemStackContainUpgrade(bauble, upgrade)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getPlayerUpgrades(EntityPlayer player, IUpgrade upgrade) {
        ItemStack[] armourArray;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(6);
        for (ItemStack armour : armourArray = player.field_71071_by.field_70460_b) {
            if (!BaublesUtil.doesItemStackContainUpgrade(armour, upgrade)) continue;
            list.add(armour);
        }
        IInventory inventory = BaublesApi.getBaubles((EntityPlayer)player);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack bauble = inventory.func_70301_a(i);
            if (!BaublesUtil.doesItemStackContainUpgrade(bauble, upgrade)) continue;
            list.add(bauble);
        }
        return list;
    }

    public static void removeUpgrade(ItemStack container, IUpgrade upgrade) {
        ItemStack stack = container.func_77946_l();
        if (stack.field_77990_d == null) {
            NBTHelper.createDefaultStackTag(stack);
            return;
        }
        if (stack.func_77973_b() instanceof IModularItem) {
            NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(stack.field_77990_d);
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).equals(upgrade)) continue;
                list.remove(i);
                break;
            }
            container.field_77990_d = stack.field_77990_d;
        }
    }

    public static List<IUpgrade> getDependencyList(IUpgrade upgrade) {
        ArrayList<IUpgrade> list = new ArrayList<IUpgrade>();
        list.add(upgrade);
        return list;
    }

    public static boolean doesItemStackContainUpgrade(ItemStack stack, IUpgrade upgrade) {
        if (stack == null || upgrade == null) {
            return false;
        }
        NBTHelper.createDefaultStackTag(stack);
        NBTList<IUpgrade> list = NBTHelper.getNBTUpgradeList(stack.field_77990_d);
        return list.contains(upgrade);
    }
}

