/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.upgrade.upgradeList;

import chbachman.api.configurability.Configurable;
import chbachman.api.configurability.ConfigurableField;
import chbachman.api.configurability.Percentage;
import chbachman.api.item.IModularItem;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Upgrade;
import chbachman.api.util.ArmourSlot;
import chbachman.armour.util.ConfigHelper;
import chbachman.armour.util.EnergyUtil;
import chbachman.armour.util.UpgradeUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class UpgradeJumpBoost
extends Upgrade {
    private int cost;
    @Configurable
    public ConfigurableField f = new ConfigurableField(this, "jumpHeight");

    public UpgradeJumpBoost() {
        super("jumpBoost");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void registerConfigOptions() {
        this.cost = ConfigHelper.get("speed values", (IUpgrade)this, "cost to jump high", 1000);
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            List<ItemStack> list = UpgradeUtil.getPlayerUpgrades(player, this);
            int energyCost = this.cost;
            for (ItemStack stack : list) {
                if (stack == null || EnergyUtil.getEnergyStored(stack) <= energyCost || player.func_70093_af()) continue;
                IModularItem modularItem = (IModularItem)stack.func_77973_b();
                modularItem.damageArmour(stack, energyCost + 1);
                player.field_70181_x += (double)(1.0f * ((Percentage)this.f.get(stack)).getPercentage());
            }
        }
    }

    @Override
    public boolean isCompatible(IModularItem item, ItemStack stack, int armorType) {
        return armorType == ArmourSlot.LEGS.id;
    }
}

