/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.upgrade.upgradeList;

import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Upgrade;
import chbachman.api.util.ArmourSlot;
import chbachman.armour.items.armour.renderer.JetpackModel;
import chbachman.armour.register.Vanilla;
import chbachman.armour.util.ConfigHelper;
import chbachman.armour.util.EnergyUtil;
import chbachman.armour.util.UpgradeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class UpgradeHoverJetpack
extends Upgrade {
    private int cost;

    public UpgradeHoverJetpack() {
        super("jetpack");
    }

    @Override
    public void registerConfigOptions() {
        this.cost = ConfigHelper.get("speed values", (IUpgrade)this, "cost to fly each tick", 500);
    }

    @Override
    public boolean isCompatible(IModularItem item, ItemStack stack, int armourType) {
        return armourType == ArmourSlot.CHESTPLATE.id;
    }

    @Override
    public int onTick(World world, EntityPlayer player, ItemStack stack, ArmourSlot slot) {
        if (EnergyUtil.getEnergyStored(stack) != 0) {
            this.setFlying(player, true, world);
        } else if (EnergyUtil.getEnergyStored(stack) == 0) {
            this.setFlying(player, false, world);
        }
        if (!UpgradeUtil.doesPlayerHaveUpgrade(player, Vanilla.calfShields) && player.field_71075_bZ.field_75100_b) {
            player.func_70097_a(DamageSource.field_76370_b, 4.0f);
        }
        if (player.field_71075_bZ.field_75100_b) {
            return this.cost;
        }
        return 0;
    }

    @Override
    public void onDequip(World world, EntityPlayer player, ItemStack stack, ArmourSlot slot) {
        this.setFlying(player, false, world);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmourModel(EntityLivingBase entityLiving, ItemStack stack, int armourSlot) {
        if (NBTHelper.getNBTUpgradeList(stack).contains(Vanilla.model)) {
            return new JetpackModel();
        }
        return null;
    }

    private void setFlying(EntityPlayer player, boolean bool, World world) {
        if (bool) {
            if (player.field_71075_bZ.field_75101_c) {
                return;
            }
            player.field_71075_bZ.field_75101_c = true;
            player.func_71016_p();
        } else {
            if (!player.field_71075_bZ.field_75101_c) {
                return;
            }
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            player.func_71016_p();
        }
    }
}

