/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.items.armour.logic;

import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.nbt.helper.NBTInteger;
import chbachman.armour.items.armour.logic.UpgradeLogicAdv;
import chbachman.armour.register.Botania;
import chbachman.armour.util.ConfigHelper;
import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.Optional;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RFUpgradeLogic
extends UpgradeLogicAdv
implements IEnergyContainerItem {
    private NBTInteger capacity = new NBTInteger("capacity", 100);
    private NBTInteger maxTransfer = new NBTInteger("maxTransfer", 100);

    public RFUpgradeLogic(IModularItem item) {
        super(item);
    }

    public int getCapacity(ItemStack stack) {
        return this.capacity.get(stack);
    }

    public void setCapacity(ItemStack stack, int amount) {
        this.capacity.set(stack, amount);
    }

    public int getMaxTransfer(ItemStack stack) {
        return this.maxTransfer.get(stack);
    }

    public void setMaxTransfer(ItemStack stack, int amount) {
        this.maxTransfer.set(stack, amount);
    }

    @Override
    public void damageArmour(ItemStack stack, int damage) {
        this.extractEnergy(stack, damage, false);
    }

    @Override
    public void healArmour(ItemStack stack, int toHeal) {
        this.receiveEnergy(stack, toHeal, false);
    }

    @Override
    public void addInformation(List<String> list, ItemStack stack) {
        if (!StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        } else {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + this.getEnergyStored(stack) + " / " + this.capacity.get(stack) + " RF");
        }
        super.addInformation(list, stack);
    }

    @Override
    public int getDisplayDamage(ItemStack stack) {
        NBTHelper.createDefaultStackTag(stack);
        return 1 + this.capacity.get(stack) - this.getEnergyStored(stack);
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return 1 + this.capacity.get(stack);
    }

    @Override
    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != Short.MAX_VALUE;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        NBTHelper.createDefaultStackTag(container);
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity.get(container) - energy, Math.min(this.maxTransfer.get(container), maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        NBTHelper.createDefaultStackTag(container);
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxTransfer.get(container), maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        NBTHelper.createDefaultStackTag(container);
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity.get(container);
    }

    @Override
    @Optional.Method(modid="Botania")
    public float getPixieChance(ItemStack stack) {
        return ConfigHelper.get("speed values", Botania.pixie, "Pixie Chance", 0.05f);
    }
}

