/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerArmour
implements IExtendedEntityProperties {
    public static final String IDENTIFIER = "ModularArmour:ArmourSaving";
    ItemStack[] stacks;
    boolean hasCraftedArmour;

    public void update(ItemStack[] armourList) {
        this.stacks = (ItemStack[])armourList.clone();
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.stacks) {
            if (stack == null) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("Empty", true);
                list.func_74742_a((NBTBase)nbt);
                return;
            }
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("armourList", (NBTBase)list);
        compound.func_74757_a("hasCrafted", this.hasCraftedArmour);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("armourList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            if (nbt.func_74764_b("Empty")) {
                this.stacks[i] = null;
                return;
            }
            this.stacks[i] = ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        this.hasCraftedArmour = compound.func_74767_n("hasCrafted");
    }

    public void init(Entity entity, World world) {
        this.stacks = new ItemStack[4];
    }

    public static PlayerArmour getFor(EntityPlayer player) {
        return (PlayerArmour)player.getExtendedProperties(IDENTIFIER);
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(IDENTIFIER, (IExtendedEntityProperties)new PlayerArmour());
    }
}

