/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.gui.element;

import chbachman.api.configurability.ConfigurableField;
import chbachman.api.configurability.FieldList;
import chbachman.api.configurability.Percentage;
import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.armour.gui.crafting.ArmourGui;
import chbachman.armour.gui.element.ElementText;
import chbachman.armour.network.ArmourPacket;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.gui.element.listbox.SliderHorizontal;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TabConfig
extends TabBase {
    public static ResourceLocation GRID_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/Slot_Grid_Augment.png");
    ArmourGui armourGui;
    ConfigurableField[] storages;

    public TabConfig(ArmourGui gui) {
        super((GuiBase)gui, 0);
        this.backgroundColor = 255;
        this.armourGui = gui;
        this.maxHeight = 110;
        this.maxWidth = 100;
        this.storages = new ConfigurableField[0];
    }

    public void drawForeground() {
        if (!this.isVisible()) {
            return;
        }
        this.drawTabIcon("IconUpgrade");
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_78261_a("Upgrades", this.posXOffset() + 18, this.posY + 8, this.headerColor);
    }

    public void addTooltip(List<String> list) {
        super.addTooltip(list);
        if (!this.isFullyOpened()) {
            list.add("Config");
        }
    }

    public void setFullyOpen() {
        super.setFullyOpen();
        this.onUpgradeSelected(this.armourGui.selectedUpgrade);
    }

    public void onUpgradeSelected(IUpgrade upgrade) {
        if (!this.fullyOpen) {
            return;
        }
        if (upgrade == null) {
            return;
        }
        this.storages = UpgradeRegistry.getListenerForUpgrade(upgrade, FieldList.class).getFieldList(upgrade);
        if (this.storages == null) {
            this.storages = new ConfigurableField[0];
        }
        this.elements.clear();
        for (int i = 0; i < this.storages.length; ++i) {
            ConfigurableField s = this.storages[i];
            this.addElement((ElementBase)new SliderUpgrade(this.gui, s, this.armourGui.stack, 10, 30 + 20 * i, 60, 10, 100).setValue(((Percentage)s.get(this.armourGui.stack)).getAmount()));
            this.addElement(new ElementText(this.gui, 10, 20 + 20 * i, 100, 10).setText(s.displayName));
        }
    }

    private static class SliderUpgrade
    extends SliderHorizontal {
        final ConfigurableField field;

        public SliderUpgrade(GuiBase containerScreen, ConfigurableField field, ItemStack armour, int x, int y, int width, int height, int maxValue) {
            super(containerScreen, x, y, width, height, maxValue);
            this.field = field;
        }

        public SliderUpgrade(GuiBase containerScreen, ConfigurableField field, ItemStack armour, int x, int y, int width, int height, int maxValue, int minValue) {
            super(containerScreen, x, y, width, height, maxValue, minValue);
            this.field = field;
        }

        public void onValueChanged(int value) {
            this.field.set(((ArmourGui)this.gui).container.getContainerStack(), value);
            PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString("ValueChanged").addString(this.field.getKey()).addInt(value));
        }

        public void drawForeground(int mouseX, int mouseY) {
            super.drawForeground(mouseX, mouseY);
            this.getFontRenderer().func_78276_b(this._value + "%", this.posX + this.getWidth() + 5, this.posY, -1);
        }
    }
}

