/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.gui.crafting;

import chbachman.api.upgrade.IUpgrade;
import chbachman.armour.gui.crafting.ArmourContainer;
import chbachman.armour.gui.element.ElementUpgradeListBox;
import chbachman.armour.gui.element.TabConfig;
import chbachman.armour.gui.element.TabCrafting;
import chbachman.armour.gui.element.TabError;
import chbachman.armour.gui.element.TabUpgradeRemoval;
import chbachman.armour.network.ArmourPacket;
import chbachman.armour.upgrade.UpgradeException;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ArmourGui
extends GuiBaseAdv {
    private static final ResourceLocation TEXTURE = new ResourceLocation("modulararmour:textures/gui/armourGui.png");
    public ArmourContainer container;
    public ElementUpgradeListBox list;
    public TabCrafting tabCrafting;
    public TabError scrolledText;
    public TabUpgradeRemoval removal;
    public TabConfig config;
    public IUpgrade selectedUpgrade;
    public ItemStack stack;
    public float gameTick;

    public ArmourGui(ArmourContainer container, InventoryPlayer inventory) {
        super((Container)container, TEXTURE);
        this.container = container;
        this.stack = inventory.func_70448_g();
        this.texture = TEXTURE;
        this.drawInventory = false;
        this.drawTitle = true;
        this.field_146999_f = 176;
        this.field_147000_g = 234;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.list = new ElementUpgradeListBox((GuiBase)this, 8, 5, 160, 142){

            @Override
            public void onUpgradeSelected(IUpgrade upgrade, int index) {
                ArmourGui.this.selectedUpgrade = upgrade;
                ArmourGui.this.config.onUpgradeSelected(upgrade);
            }
        };
        this.addElement((ElementBase)this.list);
        this.tabCrafting = new TabCrafting(this);
        this.addTab(this.tabCrafting);
        this.scrolledText = new TabError((GuiBase)this, StringHelper.localize((String)"info.chbachman.tutorial"));
        this.addTab((TabBase)this.scrolledText);
        this.removal = new TabUpgradeRemoval(this);
        this.addTab(this.removal);
        this.config = new TabConfig(this);
        this.addTab(this.config);
        this.list.setEnabled(true);
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        super.func_146976_a(partialTick, x, y);
        this.list.loadStack(this.container.getContainerStack());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onButtonClick(String name) {
        try {
            if (name.equals("UpgradeAddition")) {
                PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString(name));
                return;
            }
            if (name.equals("RemoveItems")) {
                PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString(name));
                return;
            }
            if (name.equals("RemoveUpgrade")) {
                PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString(name).addString(this.selectedUpgrade.getBaseName()));
                return;
            }
            if (name.equals("Recipe")) {
                PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString(name));
                return;
            }
            if (name.equals("ScrollDown")) {
                this.list.scrollDown();
                return;
            }
            if (name.equals("ScrollUp")) {
                this.list.scrollUp();
                return;
            }
            if (!name.equals("ValueChanged")) return;
        }
        catch (UpgradeException e) {
            this.scrolledText.setString(e.getMessage());
            if (this.scrolledText.isFullyOpened()) return;
            this.scrolledText.setFullyOpen();
        }
    }
}

