/*
 * Decompiled with CFR 0.152.
 */
package chbachman.api.item;

import chbachman.api.item.ArmourLogic;
import chbachman.api.item.IModularItem;
import chbachman.api.nbt.helper.NBTBoolean;
import chbachman.api.nbt.helper.NBTHelper;
import chbachman.api.upgrade.IArmourUpgrade;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.util.ArmourSlot;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.input.Keyboard;

public abstract class UpgradeLogic
implements ArmourLogic {
    protected final IModularItem item;
    protected final NBTBoolean hasOpened;

    public UpgradeLogic(IModularItem item) {
        this.item = item;
        this.hasOpened = new NBTBoolean("hasOpened", false);
    }

    @Override
    public void addInformation(List<String> list, ItemStack stack) {
        NBTHelper.createDefaultStackTag(stack);
        if (!this.hasOpened.get(stack)) {
            list.add(StatCollector.func_74838_a((String)"info.chbachman.openme"));
        }
        if (!Keyboard.isKeyDown((int)29) && !Keyboard.isKeyDown((int)157) && NBTHelper.getNBTUpgradeList(stack.field_77990_d).size() != 0) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"info.cofh.hold") + " " + EnumChatFormatting.YELLOW + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"info.chbachman.control") + " " + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"info.chbachman.upgradeList") + EnumChatFormatting.RESET);
        } else if (NBTHelper.getNBTUpgradeList(stack.field_77990_d).size() != 0) {
            for (IUpgrade upgrade : NBTHelper.getNBTUpgradeList(stack.field_77990_d)) {
                list.add(StatCollector.func_74838_a((String)upgrade.getName()));
            }
        }
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        this.hasOpened.set(stack, true);
        return stack;
    }

    @Override
    public int getDisplayDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    @Override
    public boolean getIsRepairable(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    @Override
    public String getArmourTexture(ItemStack stack, Entity entity, int slot, String type) {
        String texture = "Modular";
        String color = "";
        for (IUpgrade upgrade : NBTHelper.getNBTUpgradeList(stack.field_77990_d)) {
            String newColor;
            if (!(upgrade instanceof IArmourUpgrade)) continue;
            String textureLocation = ((IArmourUpgrade)upgrade).getArmourTexture(stack, ArmourSlot.getArmourSlot(slot));
            if (textureLocation != null) {
                texture = textureLocation;
                if (textureLocation.startsWith("modulararmour:textures")) {
                    return textureLocation;
                }
            }
            if ((newColor = ((IArmourUpgrade)upgrade).getArmourColor(stack, ArmourSlot.getArmourSlot(slot))) == null) continue;
            color = newColor;
        }
        return "modulararmour:textures/armour/" + texture + (slot == 2 ? "_2" : "_1") + color + ".png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmourModel(EntityLivingBase entityLiving, ItemStack stack, int armourSlot) {
        ModelBiped finalModel = null;
        for (IUpgrade upgrade : NBTHelper.getNBTUpgradeList(stack)) {
            ModelBiped model;
            if (!(upgrade instanceof IArmourUpgrade) || (model = ((IArmourUpgrade)upgrade).getArmourModel(entityLiving, stack, armourSlot)) == null) continue;
            if (finalModel == null) {
                finalModel = new ModelBiped(){

                    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                        this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
                        this.field_78112_f.func_78785_a(f5);
                        this.field_78116_c.func_78785_a(f5);
                        this.field_78115_e.func_78785_a(f5);
                        this.field_78113_g.func_78785_a(f5);
                        this.field_78123_h.func_78785_a(f5);
                        this.field_78124_i.func_78785_a(f5);
                    }
                };
            }
            this.mergeModels(finalModel.field_78115_e, model.field_78115_e);
            this.mergeModels(finalModel.field_78116_c, model.field_78116_c);
            this.mergeModels(finalModel.field_78112_f, model.field_78112_f);
            this.mergeModels(finalModel.field_78113_g, model.field_78113_g);
            this.mergeModels(finalModel.field_78123_h, model.field_78123_h);
            this.mergeModels(finalModel.field_78124_i, model.field_78124_i);
            this.mergeModels(finalModel.field_78122_k, model.field_78122_k);
            this.mergeModels(finalModel.field_78121_j, model.field_78121_j);
            this.mergeModels(finalModel.field_78114_d, model.field_78114_d);
        }
        return finalModel;
    }

    private void mergeModels(ModelRenderer parent, ModelRenderer holder) {
        if (holder.field_78805_m == null) {
            return;
        }
        for (ModelRenderer child : (ArrayList)holder.field_78805_m) {
            parent.func_78792_a(child);
        }
    }

    @Override
    public void onArmourTick(World world, EntityPlayer player, ItemStack stack) {
        int energy = 0;
        Iterator iterator = NBTHelper.getNBTUpgradeList(stack).iterator();
        while (iterator.hasNext()) {
            IUpgrade upgrade = (IUpgrade)iterator.next();
            if (upgrade == null) {
                iterator.remove();
                continue;
            }
            energy += upgrade.onTick(world, player, stack, ArmourSlot.getArmourSlot(this.item.getSlot()));
        }
        if (energy > 0) {
            this.damageArmour(stack, energy);
        } else {
            this.healArmour(stack, -energy);
        }
    }

    @Override
    public void onArmourEquip(World world, EntityPlayer player, ItemStack stack) {
        Iterator iterator = NBTHelper.getNBTUpgradeList(stack).iterator();
        while (iterator.hasNext()) {
            IUpgrade upgrade = (IUpgrade)iterator.next();
            if (upgrade == null) {
                iterator.remove();
                continue;
            }
            upgrade.onEquip(world, player, stack, ArmourSlot.getArmourSlot(this.item.getSlot()));
        }
    }

    @Override
    public void onArmourDequip(World world, EntityPlayer player, ItemStack stack) {
        Iterator iterator = NBTHelper.getNBTUpgradeList(stack).iterator();
        while (iterator.hasNext()) {
            IUpgrade upgrade = (IUpgrade)iterator.next();
            if (upgrade == null) {
                iterator.remove();
                continue;
            }
            upgrade.onDequip(world, player, stack, ArmourSlot.getArmourSlot(this.item.getSlot()));
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack stack, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties output = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        for (IUpgrade upgrade : NBTHelper.getNBTUpgradeList(stack.field_77990_d)) {
            ISpecialArmor.ArmorProperties prop = null;
            if (upgrade instanceof IArmourUpgrade) {
                prop = ((IArmourUpgrade)upgrade).getProperties(player, stack, source, damage, ArmourSlot.getArmourSlot(slot));
            }
            if (prop == null) continue;
            if (prop.Priority > output.Priority) {
                output = prop;
                continue;
            }
            if (prop.Priority != output.Priority || !(prop.AbsorbRatio > output.AbsorbRatio)) continue;
            output = prop;
        }
        return new ISpecialArmor.ArmorProperties(output.Priority, output.AbsorbRatio, Integer.MAX_VALUE);
    }

    @Override
    public int getArmourDisplay(EntityPlayer player, ItemStack stack, int slot) {
        int sum = 0;
        for (IUpgrade upgrade : NBTHelper.getNBTUpgradeList(stack.field_77990_d)) {
            sum += upgrade instanceof IArmourUpgrade ? ((IArmourUpgrade)upgrade).getArmourDisplay(player, stack, ArmourSlot.getArmourSlot(slot)) : 0;
        }
        return sum;
    }
}

