/*
 * Decompiled with CFR 0.152.
 */
package chbachman.api.configurability;

import chbachman.api.configurability.Configurable;
import chbachman.api.configurability.ConfigurableField;
import chbachman.api.registry.IUpgradeListener;
import chbachman.api.upgrade.IUpgrade;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class FieldList
implements IUpgradeListener {
    Field[] fields;

    public void refreshFields(IUpgrade upgrade, ConfigurableField[] f) {
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                this.fields[i].set(upgrade, f.length);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ConfigurableField[] getFieldList(IUpgrade upgrade) {
        ConfigurableField[] config = new ConfigurableField[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                config[i] = (ConfigurableField)this.fields[i].get(upgrade);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    @Override
    public IUpgradeListener onUpgradeAdded(IUpgrade upgrade) {
        FieldList list = new FieldList();
        Class<?> upgradeClass = upgrade.getClass();
        ArrayList<Field> storageList = new ArrayList<Field>();
        for (Field field : upgradeClass.getFields()) {
            if (!field.isAnnotationPresent(Configurable.class) || field.getType() != ConfigurableField.class) continue;
            storageList.add(field);
        }
        list.fields = storageList.toArray(new Field[0]);
        return list;
    }
}

