/*
 * Decompiled with CFR 0.152.
 */
package difficultLife.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import difficultLife.DLCore;
import difficultLife.init.DLConfigSetup;
import difficultLife.network.DataSyncManager;
import difficultLife.utils.DLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;

public class DLSaveStorage {
    public static NBTTagCompound commonGenericTag;
    public static Hashtable<String, NBTTagCompound> playerData;
    public static NBTTagCompound clientPlayerData;

    public static void manageDifficultyIncrease(float increasedBy) {
        float difficulty;
        if (commonGenericTag == null || commonGenericTag.func_82582_d()) {
            commonGenericTag = new NBTTagCompound();
            commonGenericTag.func_74776_a("difficulty", DLConfigSetup.DIFFICULTY_DEFAULT);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                for (int i = 0; i < MinecraftServer.func_71276_C().func_71233_x(); ++i) {
                    EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(MinecraftServer.func_71276_C().func_71203_ab().func_72369_d()[i]);
                    if (player == null) continue;
                    DataSyncManager.requestServerToClientMessage("worldData", player, commonGenericTag, true);
                }
            }
        }
        if ((difficulty = commonGenericTag.func_74760_g("difficulty")) < DLConfigSetup.DIFFICULTY_MAX) {
            difficulty += increasedBy;
        }
        commonGenericTag.func_74776_a("difficulty", difficulty);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (int i = 0; i < MinecraftServer.func_71276_C().func_71233_x(); ++i) {
                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(MinecraftServer.func_71276_C().func_71203_ab().func_72369_d()[i]);
                if (player == null) continue;
                DataSyncManager.requestServerToClientMessage("worldData", player, commonGenericTag, false);
            }
        }
    }

    public static void increasePlayerHeartsBy1(EntityPlayer p) {
        if (p instanceof EntityPlayerMP) {
            int hp;
            NBTTagCompound tag = playerData.get(p.func_70005_c_());
            if (tag == null || tag.func_82582_d()) {
                tag = new NBTTagCompound();
                tag.func_74768_a("health", DLConfigSetup.PLAYER_HEARTS_GENERIC * 2);
                playerData.put(p.func_70005_c_(), tag);
                DataSyncManager.requestServerToClientMessage("playerData", (EntityPlayerMP)p, playerData.get(p.func_70005_c_()), true);
            }
            if ((hp = tag.func_74762_e("health")) + 2 < DLConfigSetup.MAX_ADDITIONAL_HEARTS && DLConfigSetup.MAX_ADDITIONAL_HEARTS != -1) {
                return;
            }
            tag.func_74768_a("health", tag.func_74762_e("health") + 2);
            AttributeModifier mod = p.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(DLUtils.modifierID);
            if (mod != null) {
                AttributeModifier mCopy = new AttributeModifier(mod.func_111167_a(), mod.func_111166_b(), mod.func_111164_d() + 2.0, mod.func_111169_c());
                p.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(mod);
                p.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(mCopy);
            }
            DataSyncManager.requestServerToClientMessage("playerData", (EntityPlayerMP)p, playerData.get(p.func_70005_c_()), true);
        } else {
            FMLLog.warning((String)"[DifficultLife]Attempts to call playerhealth on CLIENT side is not cool. Canceled.", (Object[])DLCore.nObj(new Object[0]));
        }
    }

    public static int getSuggestedAmmoundOfHealthForPlayer(EntityPlayer p) {
        if (p instanceof EntityPlayerMP) {
            NBTTagCompound tag = playerData.get(p.func_70005_c_());
            if (tag == null || tag.func_82582_d()) {
                tag = new NBTTagCompound();
                tag.func_74768_a("health", DLConfigSetup.PLAYER_HEARTS_GENERIC * 2);
                playerData.put(p.func_70005_c_(), tag);
                DataSyncManager.requestServerToClientMessage("playerData", (EntityPlayerMP)p, playerData.get(p.func_70005_c_()), true);
            }
            return tag.func_74762_e("health");
        }
        FMLLog.warning((String)"[DifficultLife]Attempts to call playerhealth on CLIENT side is not cool. Canceled.", (Object[])DLCore.nObj(new Object[0]));
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean generatePlayerSaveFile(PlayerEvent.LoadFromFile event) {
        try {
            EntityPlayer p = event.entityPlayer;
            if (p != null && !p.field_70170_p.field_72995_K) {
                FMLLog.info((String)"[DifficultLife]Beginning loading of the file for player %s on side %s", (Object[])DLCore.nObj(p, FMLCommonHandler.instance().getEffectiveSide()));
                File f = event.playerDirectory;
                if (f != null) {
                    String fPath = f.getAbsolutePath();
                    File worldSaveFile = new File(fPath + "//DifficultLifeData_" + p.func_70005_c_() + ".dat");
                    if (worldSaveFile.isDirectory()) {
                        throw new IOException("File is a directory! Please, delete the DifficultLifeData folder in your save and launch the game again!");
                    }
                    if (!worldSaveFile.exists()) {
                        FMLLog.log((Level)Level.WARN, (String)"[DifficultLife]\t*Server save file not found. This is completely normal if this is your first launch of the game. Otherwise please, report this to the author!", (Object[])DLCore.nObj(new Object[0]));
                        worldSaveFile.createNewFile();
                    }
                    FileInputStream iStream = new FileInputStream(worldSaveFile);
                    try {
                        playerData.put(p.func_70005_c_(), CompressedStreamTools.func_74796_a((InputStream)iStream));
                    }
                    catch (IOException e) {
                        FMLLog.log((Level)Level.WARN, (String)"[DifficultLife]\t*Unable to read NBT from server save file. This is completely normal if this is your first launch of the game. Otherwise please, report this to the author!", (Object[])DLCore.nObj(new Object[0]));
                        playerData.put(p.func_70005_c_(), new NBTTagCompound());
                    }
                    finally {
                        iStream.close();
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"[DifficultLife]\t*Catched an exception during load of server file!", (Object[])DLCore.nObj(new Object[0]));
            return false;
        }
    }

    public static boolean saveServerPlayerFile(PlayerEvent.SaveToFile event) {
        try {
            EntityPlayer p = event.entityPlayer;
            if (p != null && !p.field_70170_p.field_72995_K) {
                FMLLog.info((String)"[DifficultLife]Beginning saving of the file for player %s on side %s", (Object[])DLCore.nObj(p, FMLCommonHandler.instance().getEffectiveSide()));
                File f = event.playerDirectory;
                if (f != null) {
                    String fPath = f.getAbsolutePath();
                    File worldSaveFile = new File(fPath + "//DifficultLifeData_" + p.func_70005_c_() + ".dat");
                    if (worldSaveFile.isDirectory()) {
                        throw new IOException("File is a directory! Please, delete the DifficultLifeData folder in your save and launch the game again!");
                    }
                    if (!worldSaveFile.exists()) {
                        worldSaveFile.createNewFile();
                    }
                    FileOutputStream oStream = new FileOutputStream(worldSaveFile);
                    try {
                        CompressedStreamTools.func_74799_a((NBTTagCompound)playerData.get(p.func_70005_c_()), (OutputStream)oStream);
                    }
                    catch (IOException e) {
                        throw new IOException("Unable to write NBT to server save file! Please, delete the DifficultLifeData.dat in your save folder and restart the server!");
                    }
                    catch (NullPointerException e) {
                        throw new IOException("Server NBT does not exists! This is impossible, please, report this to the author!" + e.getMessage());
                    }
                    finally {
                        oStream.close();
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"[DifficultLife]\t*Catched an exception during save of server file!", (Object[])DLCore.nObj(new Object[0]));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean generateServerWorldFile(WorldEvent.Load event) {
        try {
            World w = event.world;
            if (w != null && !w.field_72995_K && w.field_73011_w != null && w.field_73011_w.field_76574_g == 0) {
                FMLLog.info((String)"[DifficultLife]Beginning loading of the file for world %s on side %s", (Object[])DLCore.nObj(w, FMLCommonHandler.instance().getEffectiveSide()));
                File f = event.world.func_72860_G().func_75765_b();
                if (f != null) {
                    String fPath = f.getAbsolutePath();
                    File worldSaveFile = new File(fPath + "//DifficultLifeData.dat");
                    if (worldSaveFile.isDirectory()) {
                        throw new IOException("File is a directory! Please, delete the DifficultLifeData folder in your save and launch the game again!");
                    }
                    if (!worldSaveFile.exists()) {
                        FMLLog.log((Level)Level.WARN, (String)"[DifficultLife]\t*Server save file not found. This is completely normal if this is your first launch of the game. Otherwise please, report this to the author!", (Object[])DLCore.nObj(new Object[0]));
                        worldSaveFile.createNewFile();
                    }
                    FileInputStream iStream = new FileInputStream(worldSaveFile);
                    try {
                        commonGenericTag = CompressedStreamTools.func_74796_a((InputStream)iStream);
                    }
                    catch (IOException e) {
                        FMLLog.log((Level)Level.WARN, (String)"[DifficultLife]\t*Unable to read NBT from server save file. This is completely normal if this is your first launch of the game. Otherwise please, report this to the author!", (Object[])DLCore.nObj(new Object[0]));
                        commonGenericTag = new NBTTagCompound();
                    }
                    finally {
                        iStream.close();
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"[DifficultLife]\t*Catched an exception during load of server file!", (Object[])DLCore.nObj(new Object[0]));
            return false;
        }
    }

    public static boolean saveServerWorldFile(WorldEvent.Save event) {
        try {
            World w = event.world;
            if (w != null && !w.field_72995_K && w.field_73011_w != null && w.field_73011_w.field_76574_g == 0) {
                FMLLog.info((String)"[DifficultLife]Beginning saving of the file for world %s on side %s", (Object[])DLCore.nObj(w, FMLCommonHandler.instance().getEffectiveSide()));
                File f = event.world.func_72860_G().func_75765_b();
                if (f != null) {
                    String fPath = f.getAbsolutePath();
                    File worldSaveFile = new File(fPath + "//DifficultLifeData.dat");
                    if (worldSaveFile.isDirectory()) {
                        throw new IOException("File is a directory! Please, delete the DifficultLifeData folder in your save and launch the game again!");
                    }
                    if (!worldSaveFile.exists()) {
                        throw new IOException("File does not exists! This means, that it got deleted after being created! Make sure, that your antivirus does not recognizes the file as a virus!");
                    }
                    FileOutputStream oStream = new FileOutputStream(worldSaveFile);
                    try {
                        CompressedStreamTools.func_74799_a((NBTTagCompound)commonGenericTag, (OutputStream)oStream);
                    }
                    catch (IOException e) {
                        throw new IOException("Unable to write NBT to server save file! Please, delete the DifficultLifeData.dat in your save folder and restart the server!");
                    }
                    catch (NullPointerException e) {
                        throw new IOException("Server NBT does not exists! This is impossible, please, report this to the author!" + e.getMessage());
                    }
                    finally {
                        oStream.close();
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.FATAL, (Throwable)e, (String)"[DifficultLife]\t*Catched an exception during save of server file!", (Object[])DLCore.nObj(new Object[0]));
            return false;
        }
    }

    static {
        playerData = new Hashtable();
    }
}

