/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.common.util;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import net.minecraft.entity.player.EntityPlayer;

public class BloodUtils {
    public static boolean drainSoulNetwork(String player, int amount) {
        return SoulNetworkHandler.syphonFromNetwork((String)player, (int)amount) >= amount;
    }

    public static boolean drainSoulNetworkWithNausea(String player, int amount) {
        boolean b;
        boolean bl = b = SoulNetworkHandler.syphonFromNetwork((String)player, (int)amount) >= amount;
        if (!b) {
            SoulNetworkHandler.causeNauseaToPlayer((String)player);
        }
        return b;
    }

    public static boolean drainSoulNetworkWithDamage(String ownerName, EntityPlayer player, int damageToBeDone) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        int amount = SoulNetworkHandler.syphonFromNetwork((String)ownerName, (int)damageToBeDone);
        SoulNetworkHandler.hurtPlayer((EntityPlayer)player, (int)(damageToBeDone - amount));
        return true;
    }

    public static int getHighestTierOrb() {
        int i = -1;
        for (AltarRecipe recipe : AltarRecipeRegistry.altarRecipes) {
            if (!recipe.canBeFilled) continue;
            IBloodOrb orb = (IBloodOrb)recipe.requiredItem.func_77973_b();
            i = Math.max(i, orb.getOrbLevel());
        }
        return i;
    }

    public static RitualEffect getEffectFromString(String name) {
        Rituals ritual = (Rituals)Rituals.ritualMap.get(name);
        if (ritual == null) {
            return null;
        }
        return ritual.effect;
    }
}

