/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.common.sigil_utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import io.github.alex_hawks.SanguineExtras.common.util.BloodUtils;
import io.github.alex_hawks.SanguineExtras.common.util.PlayerUtils;
import io.github.alex_hawks.util.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class UtilsDestruction {
    public static List<Vector3> find(int x, int y, int z, World world, int side, int length) {
        return UtilsDestruction.find(x, y, z, world, ForgeDirection.getOrientation((int)side), length);
    }

    public static List<Vector3> find(int x, int y, int z, World world, ForgeDirection side, int length) {
        System.out.println(side);
        ArrayList<Vector3> toReturn = new ArrayList<Vector3>();
        switch (side) {
            case UP: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = 0; k < length; ++k) {
                            toReturn.add(new Vector3(x + i, y - k, z + j));
                        }
                    }
                }
                break;
            }
            case DOWN: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = 0; k < length; ++k) {
                            toReturn.add(new Vector3(x + i, y + k, z + j));
                        }
                    }
                }
                break;
            }
            case EAST: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = 0; k < length; ++k) {
                            toReturn.add(new Vector3(x - k, y + i, z + j));
                        }
                    }
                }
                break;
            }
            case NORTH: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = 0; k < length; ++k) {
                            toReturn.add(new Vector3(x + i, y + j, z + k));
                        }
                    }
                }
                break;
            }
            case SOUTH: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = 0; k < length; ++k) {
                            toReturn.add(new Vector3(x + i, y + j, z - k));
                        }
                    }
                }
                break;
            }
            case WEST: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        for (int k = 0; k < length; ++k) {
                            toReturn.add(new Vector3(x + k, y + i, z + j));
                        }
                    }
                }
                break;
            }
        }
        return toReturn;
    }

    public static void doDrops(EntityPlayer p, String sigilOwner, List<Vector3> list, World w) {
        UtilsDestruction.doDrops(p, sigilOwner, list.toArray(new Vector3[0]), w);
    }

    public static void doDrops(EntityPlayer p, String sigilOwner, Vector3[] list, World w) {
        int blocks = 0;
        for (Vector3 v : list) {
            if (v.y() > 255 || v.y() < 0) continue;
            Block b = w.func_147439_a(v.x(), v.y(), v.z());
            int meta = w.func_72805_g(v.x(), v.y(), v.z());
            if (b.func_149712_f(w, v.x(), v.y(), v.z()) < 0.0f || b.isAir((IBlockAccess)w, v.x(), v.y(), v.z())) continue;
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(v.x(), v.y(), v.z(), w, b, meta, p);
            if (FMLCommonHandler.instance().bus().post((Event)e) || !BloodUtils.drainSoulNetwork(sigilOwner, ++blocks)) continue;
            ArrayList drops = b.getDrops(w, v.x(), v.y(), v.z(), meta, 0);
            w.func_147449_b(v.x(), v.y(), v.z(), Blocks.field_150350_a);
            for (ItemStack drop : drops) {
                PlayerUtils.putItem(p, drop);
                if (e.getExpToDrop() <= 0) continue;
                w.func_72838_d((Entity)new EntityXPOrb(w, p.field_70165_t, p.field_70163_u, p.field_70161_v, e.getExpToDrop()));
            }
        }
    }
}

