/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.common.sigil_utils;

import io.github.alex_hawks.util.Vector3;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class UtilsBuilding {
    static final int QUARTER_CIRCLE = 90;
    static final ForgeDirection[] YAW_ROTATION = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};

    public static Set<Vector3> getBlocksForBuild(World w, Vector3 v, ForgeDirection d, EntityPlayer player, int limit) {
        HashSet<Vector3> ls = new HashSet<Vector3>();
        Block b = w.func_147439_a(v.x(), v.y(), v.z());
        int meta = w.func_72805_g(v.x(), v.y(), v.z());
        EnumSet<ForgeDirection> dirs = EnumSet.allOf(ForgeDirection.class);
        dirs.removeAll(EnumSet.of(d, d.getOpposite(), ForgeDirection.UNKNOWN));
        if (player.func_70093_af() && dirs.containsAll(EnumSet.of(ForgeDirection.UP, ForgeDirection.DOWN))) {
            dirs.removeAll(EnumSet.of(ForgeDirection.UP, ForgeDirection.DOWN));
        }
        if (player.func_70093_af()) {
            for (float yaw = player.field_70177_z; yaw < 0.0f; yaw += 360.0f) {
            }
            int val = (int)((double)((yaw %= 360.0f) / 90.0f) + 0.5);
            dirs.removeAll(EnumSet.of(UtilsBuilding.getDir(val), UtilsBuilding.getDir(val).getOpposite()));
        }
        ls.add(new Vector3(v.x() + d.offsetX, v.y() + d.offsetY, v.z() + d.offsetZ));
        for (int i = 0; i < limit; ++i) {
            HashSet<Vector3> buffer = new HashSet<Vector3>(ls);
            for (Vector3 v3 : buffer) {
                for (ForgeDirection dir : dirs) {
                    Block b2 = w.func_147439_a(v3.x() + dir.offsetX - d.offsetX, v3.y() + dir.offsetY - d.offsetY, v3.z() + dir.offsetZ - d.offsetZ);
                    int m = w.func_72805_g(v3.x() + dir.offsetX - d.offsetX, v3.y() + dir.offsetY - d.offsetY, v3.z() + dir.offsetZ - d.offsetZ);
                    Block b3 = w.func_147439_a(v3.x() + dir.offsetX, v3.y() + dir.offsetY, v3.z() + dir.offsetZ);
                    if (!b2.equals(b) || m != meta || !b3.isReplaceable((IBlockAccess)w, v3.x() + dir.offsetX, v3.y() + dir.offsetY, v3.z() + dir.offsetZ)) continue;
                    ls.add(new Vector3(v3.x() + dir.offsetX, v3.y() + dir.offsetY, v3.z() + dir.offsetZ));
                    if (ls.size() >= limit) {
                        return ls;
                    }
                    if (Math.abs(v.x() - v3.x()) > limit / 2 + 1) {
                        return ls;
                    }
                    if (Math.abs(v.y() - v3.y()) > limit / 2 + 1) {
                        return ls;
                    }
                    if (Math.abs(v.z() - v3.z()) <= limit / 2 + 1) continue;
                    return ls;
                }
            }
        }
        return ls;
    }

    public static ForgeDirection getDir(int i) {
        return YAW_ROTATION[i % YAW_ROTATION.length];
    }
}

