/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.common.rituals.basic;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import io.github.alex_hawks.SanguineExtras.api.sigil.MobNet;
import io.github.alex_hawks.SanguineExtras.common.SanguineExtras;
import io.github.alex_hawks.SanguineExtras.common.sigil_utils.UtilsMobNet;
import io.github.alex_hawks.SanguineExtras.common.sigils.ItemMobNet;
import io.github.alex_hawks.SanguineExtras.common.util.BloodUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class Spawn
extends RitualEffect {
    public int getCostPerRefresh() {
        return 0;
    }

    public List<RitualComponent> getRitualComponentList() {
        LinkedList<RitualComponent> ls = new LinkedList<RitualComponent>();
        ls.add(new RitualComponent(1, -1, 1, 4));
        ls.add(new RitualComponent(2, -2, 2, 5));
        ls.add(new RitualComponent(2, -3, 2, 2));
        ls.add(new RitualComponent(2, -4, 2, 1));
        ls.add(new RitualComponent(2, -5, 2, 5));
        ls.add(new RitualComponent(2, -6, 2, 3));
        ls.add(new RitualComponent(1, -6, 1, 2));
        ls.add(new RitualComponent(1, -1, -1, 4));
        ls.add(new RitualComponent(2, -2, -2, 5));
        ls.add(new RitualComponent(2, -3, -2, 2));
        ls.add(new RitualComponent(2, -4, -2, 1));
        ls.add(new RitualComponent(2, -5, -2, 5));
        ls.add(new RitualComponent(2, -6, -2, 3));
        ls.add(new RitualComponent(1, -6, -1, 2));
        ls.add(new RitualComponent(-1, -1, -1, 4));
        ls.add(new RitualComponent(-2, -2, -2, 5));
        ls.add(new RitualComponent(-2, -3, -2, 2));
        ls.add(new RitualComponent(-2, -4, -2, 1));
        ls.add(new RitualComponent(-2, -5, -2, 5));
        ls.add(new RitualComponent(-2, -6, -2, 3));
        ls.add(new RitualComponent(-1, -6, -1, 2));
        ls.add(new RitualComponent(-1, -1, 1, 4));
        ls.add(new RitualComponent(-2, -2, 2, 5));
        ls.add(new RitualComponent(-2, -3, 2, 2));
        ls.add(new RitualComponent(-2, -4, 2, 1));
        ls.add(new RitualComponent(-2, -5, 2, 5));
        ls.add(new RitualComponent(-2, -6, 2, 3));
        ls.add(new RitualComponent(-1, -6, 1, 2));
        ls.add(new RitualComponent(1, -6, 0, 3));
        ls.add(new RitualComponent(0, -6, 1, 3));
        ls.add(new RitualComponent(-1, -6, 0, 3));
        ls.add(new RitualComponent(0, -6, -1, 3));
        return ls;
    }

    public void performEffect(IMasterRitualStone stone) {
        ItemStack sigilStack;
        if (stone.getCooldown() > 0) {
            stone.setCooldown(stone.getCooldown() - 1);
            return;
        }
        stone.setCooldown(200);
        World w = stone.getWorld();
        int x = stone.getXCoord();
        int y = stone.getYCoord();
        int z = stone.getZCoord();
        if (w.func_72864_z(x, y, z)) {
            return;
        }
        TileEntity te = w.func_147438_o(x, y + 1, z);
        if (te instanceof IBloodAltar && (sigilStack = ((IInventory)te).func_70301_a(0)) != null && sigilStack.func_77973_b() instanceof ItemMobNet) {
            EntityLivingBase ent;
            int baseCost;
            int cost = baseCost = SanguineExtras.spawnLpPerHealth;
            boolean hasTerrae = this.canDrainReagent(stone, ReagentRegistry.terraeReagent, 100, false);
            boolean hasOrbisTerrae = this.canDrainReagent(stone, ReagentRegistry.orbisTerraeReagent, 100, false);
            boolean hasSanctus = this.canDrainReagent(stone, ReagentRegistry.sanctusReagent, 100, false);
            cost += hasTerrae ? (hasOrbisTerrae ? 0 : baseCost / 2) : (hasOrbisTerrae ? baseCost / 2 : baseCost);
            cost *= hasSanctus ? 2 : 1;
            EntityLivingBase entityLivingBase = ent = hasSanctus ? UtilsMobNet.createCopiedEntity(sigilStack, w) : UtilsMobNet.createNewEntity(sigilStack, w);
            if (ent == null) {
                return;
            }
            if (MobNet.isSpawnBlacklisted(ent.getClass())) {
                return;
            }
            if (w.func_72872_a(ent.getClass(), AxisAlignedBB.func_72330_a((double)(x - 2), (double)(y - 4), (double)(z - 2), (double)(x + 2), (double)y, (double)(z + 2))).size() > (ent instanceof IBossDisplayData ? SanguineExtras.spawnMaxEntities / 10 : SanguineExtras.spawnMaxEntities)) {
                return;
            }
            if (ent instanceof IBossDisplayData && !SanguineExtras.spawnableBossMobs) {
                return;
            }
            if (BloodUtils.drainSoulNetworkWithNausea(stone.getOwner(), (int)(ent.func_110138_aP() + ent.func_110138_aP() - ent.func_110143_aJ()) * cost * (ent instanceof IBossDisplayData ? 10 : 1))) {
                this.canDrainReagent(stone, ReagentRegistry.terraeReagent, 100, true);
                this.canDrainReagent(stone, ReagentRegistry.orbisTerraeReagent, 100, true);
                this.canDrainReagent(stone, ReagentRegistry.sanctusReagent, 100, true);
                ent.func_70107_b((double)x + 0.5, (double)(y - 3), (double)z + 0.5);
                w.func_72838_d((Entity)ent);
                if (this.canDrainReagent(stone, ReagentRegistry.potentiaReagent, 20, true)) {
                    stone.setCooldown(20);
                }
            }
            return;
        }
    }

    public static final class Drain {
        public static final int potentia = 20;
        public static final int terrae = 100;
        public static final int orbisTerrae = 100;
        public static final int sanctus = 100;
    }
}

