/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.tower;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.MapGenScatteredFeatureCustom;
import chylex.hee.world.structure.island.util.IslandSpawnChecker;
import chylex.hee.world.structure.tower.ComponentTower;
import chylex.hee.world.structure.tower.StructureTower;
import chylex.hee.world.util.WorldGenChance;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenTower
extends MapGenScatteredFeatureCustom {
    public static final HeeDebugCommand.HeeTest $debugTest = new HeeDebugCommand.HeeTest(){

        @Override
        public void run(String ... args) {
            ComponentTower tower = new ComponentTower(this.world.field_73012_v, (int)this.player.field_70165_t, (int)this.player.field_70161_v);
            tower.func_74875_a(this.world, this.world.field_73012_v, new StructureBoundingBox(-9999999, 0, -9999999, 9999999, 128, 9999999));
            HardcoreEnderExpansion.notifications.report("Generated tower.");
        }
    };

    public MapGenTower() {
        super(9, 15, 350, 32);
    }

    @Override
    protected boolean canStructureSpawn(int x, int z, double dist, Random rand) {
        int zz;
        int xx;
        if (rand.nextInt(100) > 28 || dist > 900.0 && !WorldGenChance.checkChance(0.25 + 0.75 * WorldGenChance.cubic2Decr.calculate(dist, 900.0, 3800.0), rand)) {
            return false;
        }
        long seed1 = this.field_75039_c.func_72912_H().func_76063_b();
        int seed2 = 1 + ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).getDragonDeathAmount();
        ArrayList<BlockPosM> locs = new ArrayList<BlockPosM>();
        for (xx = x - 12; xx <= x + 12; ++xx) {
            for (zz = z - 12; zz <= z + 12; ++zz) {
                if (IslandSpawnChecker.getIslandBiomeAt(xx, zz, seed1, seed2) == -1) continue;
                locs.add(new BlockPosM(xx * 16 + 104, 0, zz * 16 + 104));
            }
        }
        xx = x * 16 + 16;
        zz = z * 16 + 16;
        int check = MathUtil.ceil(124.8f);
        for (BlockPosM loc : locs) {
            if (!(MathUtil.distance(xx - loc.x, zz - loc.z) < (double)check)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getStructureName() {
        return "hardcoreenderdragon_EndTower";
    }

    protected StructureStart func_75049_b(int x, int z) {
        return new StructureTower(this.field_75039_c, this.field_75038_b, x, z);
    }
}

