/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.tower;

import chylex.hee.entity.boss.EntityMiniBossEnderEye;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.item.ItemKnowledgeNote;
import chylex.hee.item.ItemMusicDisk;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.types.EnderPearlEnhancements;
import chylex.hee.mechanics.enhancements.types.TNTEnhancements;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.WorldGenSavefile;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.ItemUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityCustomSpawner;
import chylex.hee.tileentity.TileEntityEndermanHead;
import chylex.hee.tileentity.spawner.CustomSpawnerLogic;
import chylex.hee.tileentity.spawner.TowerEndermanSpawnerLogic;
import chylex.hee.world.loot.IItemPostProcessor;
import chylex.hee.world.loot.LootItemStack;
import chylex.hee.world.loot.WeightedLootList;
import chylex.hee.world.structure.ComponentLargeStructureWorld;
import chylex.hee.world.structure.util.Facing;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import gnu.trove.list.array.TByteArrayList;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.StringUtils;

public class ComponentTower
extends ComponentLargeStructureWorld
implements ITileEntityGenerator {
    private static final byte roomHeight = 6;
    public static final WeightedLootList lootTower = new WeightedLootList(new LootItemStack(Blocks.field_150321_G).setWeight(220), new LootItemStack(ItemList.end_powder).setAmount(1, 10).setWeight(212), new LootItemStack(Items.field_151074_bl).setAmount(1, 12).setWeight(190), new LootItemStack(ItemList.enhanced_ender_pearl).setAmount(1, 5).setWeight(182), new LootItemStack(Items.field_151062_by).setAmount(1, 8).setWeight(175), new LootItemStack(Items.field_151079_bi).setAmount(1, 6).setWeight(160), new LootItemStack(Items.field_151166_bC).setAmount(1, 6).setWeight(152), new LootItemStack(ItemList.igneous_rock).setAmount(1, 7).setWeight(140), new LootItemStack(Items.field_151042_j).setAmount(1, 13).setWeight(136), new LootItemStack(ItemList.stardust).setAmount(3, 11).setWeight(131), new LootItemStack(Items.field_151043_k).setAmount(1, 11).setWeight(125), new LootItemStack(ItemList.knowledge_note).setWeight(122), new LootItemStack(BlockList.obsidian_special).setAmount(1, 9).setDamage(0, 2).setWeight(121), new LootItemStack(ItemList.adventurers_diary).setWeight(117), new LootItemStack((Block)Blocks.field_150327_N).setAmount(1, 7).setWeight(116), new LootItemStack((Block)Blocks.field_150328_O).setAmount(1, 5).setWeight(111), new LootItemStack(ItemList.biome_compass).setWeight(110), new LootItemStack(Items.field_151153_ao).setAmount(1, 2).setWeight(109), new LootItemStack(BlockList.obsidian_special_glow).setAmount(1, 8).setDamage(0, 2).setWeight(104), new LootItemStack(Items.field_151063_bx).setDamage(58).setAmount(1, 4).setWeight(101), new LootItemStack((Block)Blocks.field_150338_P).setAmount(1, 6).setWeight(92), new LootItemStack((Block)Blocks.field_150337_Q).setAmount(1, 6).setWeight(90), new LootItemStack(Items.field_151045_i).setAmount(1, 5).setWeight(85), new LootItemStack(Items.field_151111_aL).setWeight(75), new LootItemStack(Items.field_151113_aN).setWeight(75), new LootItemStack(ItemList.music_disk).setDamage(0, ItemMusicDisk.getRecordCount() - 1).setWeight(71), new LootItemStack(Items.field_151131_as).setWeight(68), new LootItemStack((Block)Blocks.field_150486_ae).setWeight(60), new LootItemStack(Blocks.field_150335_W).setAmount(1, 8).setWeight(58), new LootItemStack(BlockList.enhanced_tnt).setAmount(1, 4).setWeight(49), new LootItemStack((Block)Blocks.field_150349_c).setAmount(1, 6).setWeight(46), new LootItemStack((Block)Blocks.field_150391_bh).setAmount(1, 6).setWeight(45), new LootItemStack(Items.field_151105_aU).setWeight(37), new LootItemStack(Items.field_151061_bv).setAmount(1, 2).setWeight(36), new LootItemStack(ItemList.enhanced_brewing_stand).setWeight(17), new LootItemStack(ItemList.temple_caller).setWeight(14), new LootItemStack(BlockList.essence_altar).setWeight(13), new LootItemStack(Items.field_151153_ao).setDamage(1).setWeight(4)).addItemPostProcessor(new IItemPostProcessor(){

        @Override
        public ItemStack processItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == ItemList.enhanced_ender_pearl) {
                ArrayList<EnderPearlEnhancements> availableTypes = CollectionUtil.newList(EnderPearlEnhancements.values());
                int a = 0;
                while ((long)a < 1L + Math.abs(Math.round(rand.nextDouble() * rand.nextGaussian() * 2.75))) {
                    is = EnhancementHandler.addEnhancement(is, (Enum)availableTypes.remove(rand.nextInt(availableTypes.size())));
                    if (!availableTypes.isEmpty()) {
                        ++a;
                        continue;
                    }
                    break;
                }
            } else if (is.func_77973_b() == Item.func_150898_a((Block)BlockList.enhanced_tnt)) {
                ArrayList<TNTEnhancements> availableTypes = CollectionUtil.newList(TNTEnhancements.values());
                int a = 0;
                while ((long)a < (long)(1 + rand.nextInt(2)) + Math.round(rand.nextDouble() * 2.0)) {
                    is = EnhancementHandler.addEnhancement(is, (Enum)availableTypes.remove(rand.nextInt(availableTypes.size())));
                    if (!availableTypes.isEmpty()) {
                        ++a;
                        continue;
                    }
                    break;
                }
            } else if (is.func_77973_b() == ItemList.knowledge_note) {
                ItemKnowledgeNote.setRandomNote(is, rand, 5);
            } else if (is.func_77973_b() == Items.field_151105_aU) {
                ItemUtil.addLore(is, EnumChatFormatting.DARK_PURPLE.toString() + EnumChatFormatting.ITALIC + "Why are there just pieces of cake");
                ItemUtil.addLore(is, EnumChatFormatting.DARK_PURPLE.toString() + EnumChatFormatting.ITALIC + "lying all over the place?...");
            }
            return is;
        }
    });
    public static WeightedLootList lootFuel = new WeightedLootList(new LootItemStack(Items.field_151044_h).setAmount(1, 16).setWeight(32), new LootItemStack(Items.field_151044_h).setDamage(1).setAmount(1, 16).setWeight(30), new LootItemStack(ItemList.igneous_rock).setAmount(1, 6).setWeight(20), new LootItemStack(Blocks.field_150402_ci).setAmount(1, 6).setWeight(10), new LootItemStack(Items.field_151072_bj).setAmount(1, 8).setWeight(18), new LootItemStack(Items.field_151129_at).setWeight(15), new LootItemStack(Blocks.field_150345_g).setAmount(1, 20).setDamage(0, 3).setWeight(10), new LootItemStack(Items.field_151055_y).setAmount(1, 32).setWeight(8));
    private byte lastRoomUsed = (byte)-1;
    private final int[] potionData = new int[]{0, 16, 8193, 8257, 8225, 8194, 8258, 8226, 8195, 8259, 8227, 8197, 8261, 8229, 8198, 8262, 8201, 8265, 8233, 8206, 8270, 8196, 8260, 8228, 8200, 8264, 8232, 8202, 8266, 8234, 8204, 8268, 8236};

    public ComponentTower() {
    }

    protected ComponentTower(Random rand, int x, int z) {
        super(rand, x, 32, z, 32, 140, 32);
        ((WorldGenSavefile)WorldDataHandler.get(WorldGenSavefile.class)).addElementAt(this.getStartX() >> 4, this.getStartZ() >> 4, WorldGenSavefile.WorldGenElement.DUNGEON_TOWER);
    }

    @Override
    protected int setupStructure(long seed) {
        int xx;
        int yy;
        int a;
        Random rand = new Random((long)(this.getStartX() / 14) * 185226L + (long)(this.getStartZ() / 14) * 24071632895L ^ seed);
        int centerX = this.sizeX / 2;
        int centerZ = this.sizeZ / 2;
        int islandY = 32 + rand.nextInt(40);
        int roomAmount = 4;
        float rad = rand.nextFloat() * 3.5f + 9.0f;
        int ceilRad = MathUtil.ceil(rad);
        for (int a2 = centerX - ceilRad; a2 <= centerX + ceilRad; ++a2) {
            for (int b = centerX - ceilRad; b <= centerX + ceilRad; ++b) {
                double distFromCenter = MathUtil.distance(a2 - centerX, b - centerX);
                if (distFromCenter > (double)(rad - rand.nextFloat() * 1.1f + rand.nextFloat() * 0.5f)) continue;
                double distFactor = (double)ceilRad * 1.15 - distFromCenter;
                int spikeY = 0;
                while ((double)spikeY <= distFactor * 0.45 * Math.sqrt(distFactor * 0.5) + rand.nextDouble() * 1.5 * distFactor) {
                    this.structure.setBlock(a2, islandY - spikeY, b, Blocks.field_150377_bs);
                    ++spikeY;
                }
            }
        }
        int topY = islandY + 6 * roomAmount;
        for (a = 0; a < 2; ++a) {
            int y;
            int b;
            for (b = 0; b < 5; ++b) {
                for (y = islandY; y <= topY; ++y) {
                    this.structure.setBlock(centerX - 4 + 8 * a, y, centerZ - 2 + b, BlockList.obsidian_special);
                    this.structure.setBlock(centerX - 2 + b, y, centerZ - 4 + 8 * a, BlockList.obsidian_special);
                }
            }
            for (b = 0; b < 2; ++b) {
                for (y = islandY; y <= topY; ++y) {
                    this.structure.setBlock(centerX - 3 + 6 * a, y, centerZ - 3 + 6 * b, BlockList.obsidian_special);
                }
            }
        }
        for (a = 0; a < roomAmount; ++a) {
            yy = islandY + 6 * a;
            int ladderMeta = this.func_151555_a(Blocks.field_150468_ap, a % 2 == 0 ? 2 : 3);
            for (int py = yy + 1; py <= yy + 6; ++py) {
                this.structure.setBlock(centerX, py, centerZ - 3 + 6 * (a % 2), Blocks.field_150468_ap, ladderMeta);
            }
            this.generateWallDecorations(centerX, yy, centerZ);
            this.generateFloor(centerX, yy, centerZ, a);
            if (a < roomAmount - 1) {
                this.generateBasicRoom(centerX, yy + 1, centerZ, a, rand);
                continue;
            }
            this.generateChestRoom(centerX, yy + 1, centerZ, a, rand);
        }
        for (int yy2 = islandY + 1; yy2 <= islandY + 5; ++yy2) {
            int xx2;
            for (xx2 = centerX - 1; xx2 <= centerX + 1; ++xx2) {
                this.structure.setBlock(xx2, yy2, centerZ + 4, Blocks.field_150350_a);
            }
            for (xx2 = centerX - 2; xx2 <= centerX + 2; ++xx2) {
                this.structure.setBlock(xx2, yy2, centerZ + 5, Blocks.field_150350_a);
            }
        }
        for (xx = centerX - 1; xx <= centerX + 1; ++xx) {
            for (int zz = centerZ + 3; zz <= centerZ + 5; ++zz) {
                this.structure.setBlock(xx, islandY, zz, Blocks.field_150343_Z);
            }
            this.structure.setBlock(xx, islandY + 5, centerZ + 4, BlockList.obsidian_special, 5);
        }
        for (a = 0; a < 2; ++a) {
            for (int yy3 = islandY; yy3 <= islandY + 5; ++yy3) {
                this.structure.setBlock(centerX - 2 + 4 * a, yy3, centerZ + 5, BlockList.obsidian_special, 2);
            }
            this.structure.setBlock(centerX - 1 + 2 * a, islandY + 5, centerZ + 5, BlockList.obsidian_stairs, 4 + this.func_151555_a(Blocks.field_150446_ar, a == 0 ? 1 : 0));
        }
        for (xx = centerX - 3; xx <= centerX + 3; ++xx) {
            for (int zz = centerZ - 2; zz <= centerZ + 2; ++zz) {
                this.structure.setBlock(xx, topY, zz, Blocks.field_150343_Z);
            }
        }
        for (a = 0; a < 2; ++a) {
            int b;
            int yy4;
            for (int xx3 = centerX - 2; xx3 <= centerX + 2; ++xx3) {
                this.structure.setBlock(xx3, topY, centerZ - 3 + 6 * a, Blocks.field_150343_Z);
            }
            for (yy4 = topY - 2; yy4 <= topY + 5; ++yy4) {
                this.structure.setBlock(centerX - 5 + 10 * a, yy4, centerZ, Blocks.field_150343_Z);
            }
            for (yy4 = topY - 1; yy4 <= topY + 8; ++yy4) {
                this.structure.setBlock(centerX - 6 + 12 * a, yy4, centerZ, Blocks.field_150343_Z);
            }
            for (yy4 = topY; yy4 <= topY + 10; ++yy4) {
                this.structure.setBlock(centerX - 7 + 14 * a, yy4, centerZ, Blocks.field_150343_Z);
            }
            for (yy4 = topY + 3; yy4 <= topY + 12; ++yy4) {
                this.structure.setBlock(centerX - 8 + 16 * a, yy4, centerZ, Blocks.field_150343_Z);
            }
            for (b = 0; b < 2; ++b) {
                for (yy = topY - 1; yy <= topY; ++yy) {
                    this.structure.setBlock(centerX - 5 + 10 * a, yy, centerZ - 1 + 2 * b, Blocks.field_150343_Z);
                }
                for (yy = topY; yy <= topY + 4; ++yy) {
                    this.structure.setBlock(centerX - 6 + 12 * a, yy, centerZ - 1 + 2 * b, Blocks.field_150343_Z);
                }
                for (yy = topY + 4; yy <= topY + 8; ++yy) {
                    this.structure.setBlock(centerX - 7 + 14 * a, yy, centerZ - 1 + 2 * b, Blocks.field_150343_Z);
                }
            }
            this.structure.setBlock(centerX - 8 + 16 * a, topY + 13, centerZ, Blocks.field_150426_aN, 0, true);
            for (yy4 = topY - 2; yy4 <= topY + 5; ++yy4) {
                this.structure.setBlock(centerX, yy4, centerZ - 5 + 10 * a, Blocks.field_150343_Z);
            }
            for (yy4 = topY - 1; yy4 <= topY + 8; ++yy4) {
                this.structure.setBlock(centerX, yy4, centerZ - 6 + 12 * a, Blocks.field_150343_Z);
            }
            for (yy4 = topY; yy4 <= topY + 10; ++yy4) {
                this.structure.setBlock(centerX, yy4, centerZ - 7 + 14 * a, Blocks.field_150343_Z);
            }
            for (yy4 = topY + 3; yy4 <= topY + 12; ++yy4) {
                this.structure.setBlock(centerX, yy4, centerZ - 8 + 16 * a, Blocks.field_150343_Z);
            }
            for (b = 0; b < 2; ++b) {
                for (yy = topY - 1; yy <= topY; ++yy) {
                    this.structure.setBlock(centerX - 1 + 2 * b, yy, centerZ - 5 + 10 * a, Blocks.field_150343_Z);
                }
                for (yy = topY; yy <= topY + 4; ++yy) {
                    this.structure.setBlock(centerX - 1 + 2 * b, yy, centerZ - 6 + 12 * a, Blocks.field_150343_Z);
                }
                for (yy = topY + 4; yy <= topY + 8; ++yy) {
                    this.structure.setBlock(centerX - 1 + 2 * b, yy, centerZ - 7 + 14 * a, Blocks.field_150343_Z);
                }
            }
            this.structure.setBlock(centerX, topY + 13, centerZ - 8 + 16 * a, Blocks.field_150426_aN, 0, true);
        }
        int zOffset = roomAmount % 2 == 1 ? 2 : -2;
        this.structure.setBlock(centerX, topY, centerZ + (roomAmount % 2 == 1 ? -3 : 3), Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, roomAmount % 2 == 0 ? 3 : 2));
        this.structure.setBlock(centerX, topY + 1, centerZ + zOffset, BlockList.obsidian_special_glow, 1, true);
        EntityMiniBossEnderEye eye = new EntityMiniBossEnderEye(null, (double)centerX + 0.5, (double)topY + 1.825, (double)(centerZ + zOffset) + 0.5);
        eye.func_70080_a(eye.field_70165_t, eye.field_70163_u, eye.field_70161_v, 90 * this.field_74885_f, 0.0f);
        this.structure.addEntity((Entity)eye);
        return 0;
    }

    private void generateWallDecorations(int x, int y, int z) {
        for (int a = 0; a < 2; ++a) {
            int b;
            for (int zz = z - 2; zz <= z + 2; ++zz) {
                this.structure.setBlock(x - 5 + 10 * a, y + 6, zz, BlockList.obsidian_special, 1);
            }
            for (int xx = x - 2; xx <= x + 2; ++xx) {
                this.structure.setBlock(xx, y + 6, z - 5 + 10 * a, BlockList.obsidian_special, 1);
            }
            for (b = 0; b < 2; ++b) {
                this.structure.setBlock(x - 4 + 8 * a, y + 6, z - 3 + 6 * b, BlockList.obsidian_special, 1);
                this.structure.setBlock(x - 3 + 6 * a, y + 6, z - 4 + 8 * b, BlockList.obsidian_special, 1);
            }
            for (int yy = y + 1; yy <= y + 5; ++yy) {
                this.structure.setBlock(x - 5 + 10 * a, yy, z, BlockList.obsidian_special, 2);
                this.structure.setBlock(x, yy, z - 5 + 10 * a, BlockList.obsidian_special, 2);
            }
            for (b = 0; b < 2; ++b) {
                this.structure.setBlock(x - 4 + 8 * a, y + 3, z - 1 + 2 * b, BlockList.obsidian_special_glow, 0, true);
                this.structure.setBlock(x - 1 + 2 * b, y + 3, z - 4 + 8 * a, BlockList.obsidian_special_glow, 0, true);
                for (int c = 0; c < 2; ++c) {
                    this.structure.setBlock(x - 5 + 10 * a, y + 1 + 4 * c, z - 1 + 2 * b, Blocks.field_150343_Z, 0);
                    this.structure.setBlock(x - 5 + 10 * a, y + 1 + 4 * c, z - 2 + 4 * b, BlockList.obsidian_stairs, c * 4 + this.func_151555_a(Blocks.field_150446_ar, b == 0 ? 3 : 2));
                    this.structure.setBlock(x - 5 + 10 * a, y + 2 + 2 * c, z - 1 + 2 * b, BlockList.obsidian_stairs, c * 4 + this.func_151555_a(Blocks.field_150446_ar, b == 0 ? 3 : 2));
                    this.structure.setBlock(x - 1 + 2 * b, y + 1 + 4 * c, z - 5 + 10 * a, Blocks.field_150343_Z, 0);
                    this.structure.setBlock(x - 2 + 4 * b, y + 1 + 4 * c, z - 5 + 10 * a, BlockList.obsidian_stairs, c * 4 + this.func_151555_a(Blocks.field_150446_ar, b == 0 ? 0 : 1));
                    this.structure.setBlock(x - 1 + 2 * b, y + 2 + 2 * c, z - 5 + 10 * a, BlockList.obsidian_stairs, c * 4 + this.func_151555_a(Blocks.field_150446_ar, b == 0 ? 0 : 1));
                }
            }
        }
    }

    private void generateFloor(int x, int y, int z, int roomNb) {
        for (int a = 0; a < 2; ++a) {
            int zz;
            for (int b = 0; b < 2; ++b) {
                int xx;
                for (xx = x - 2 + a * 3; xx <= x - 1 + a * 3; ++xx) {
                    for (int zz2 = z - 3 + b * 4; zz2 <= z - 2 + b * 5; ++zz2) {
                        this.structure.setBlock(xx, y, zz2, Blocks.field_150343_Z);
                    }
                }
                for (xx = x - 2 + a * 3; xx <= x - 1 + a * 3; ++xx) {
                    this.structure.setBlock(xx, y, z - 1 + b * 2, BlockList.obsidian_special);
                }
                for (xx = x - 3 + a * 6; xx <= x - 3 + a * 6; ++xx) {
                    this.structure.setBlock(xx, y, z - 2 + b * 4, BlockList.obsidian_special);
                }
            }
            this.structure.setBlock(x, y, z - 2 + a * 4, BlockList.obsidian_special, 0);
            for (zz = z - 1; zz <= z + 1; ++zz) {
                this.structure.setBlock(x - 3 + a * 6, y, zz, Blocks.field_150343_Z);
            }
            for (int xx = x - 2 + a * 3; xx <= x - 1 + a * 3; ++xx) {
                this.structure.setBlock(xx, y, z, Blocks.field_150343_Z);
            }
            for (zz = z - 1 + a * 2; zz <= z + a; ++zz) {
                this.structure.setBlock(x, y, zz, Blocks.field_150343_Z);
            }
        }
        this.structure.setBlock(x, y, z, BlockList.obsidian_special, 6);
        if (roomNb % 2 == 0) {
            this.structure.setBlock(x, y, z - 3, BlockList.obsidian_special, 0);
        } else {
            this.structure.setBlock(x, y, z + 3, BlockList.obsidian_special, 0);
        }
    }

    private void generateBasicRoom(int x, int y, int z, int roomNb, Random rand) {
        block40: {
            boolean isRoomEven;
            int n;
            block47: {
                int[][] pillars;
                block46: {
                    block45: {
                        int a;
                        block44: {
                            block43: {
                                block42: {
                                    block41: {
                                        int a2;
                                        block39: {
                                            n = roomNb == 0 ? rand.nextInt(8) + 1 : rand.nextInt(9) + 1;
                                            boolean bl = isRoomEven = roomNb % 2 == 0;
                                            if (n == this.lastRoomUsed) {
                                                n = rand.nextInt(9) + 1;
                                            }
                                            this.lastRoomUsed = (byte)n;
                                            if (n != 1) break block39;
                                            this.structure.setBlock(x, y, z, Blocks.field_150381_bn, 0);
                                            int flowerType = rand.nextInt(3) == 0 ? 15 : rand.nextInt(5);
                                            for (int a3 = 0; a3 < 2; ++a3) {
                                                int b;
                                                this.structure.setBlock(x - 3 + a3 * 6, y + 4, z, BlockList.death_flower_pot, flowerType);
                                                this.structure.setBlock(x - 2 + a3 * 4, y, z + (isRoomEven ? 3 : -3), BlockList.obsidian_special, 0);
                                                this.spawnBrewingStand(x - 2 + a3 * 4, y + 1, z + (isRoomEven ? 3 : -3), rand);
                                                for (b = 0; b < 2; ++b) {
                                                    for (int yy = y; yy <= y + 3; ++yy) {
                                                        this.structure.setBlock(x - 3 + a3 * 6, yy, z - 1 + b * 2, Blocks.field_150342_X);
                                                    }
                                                    this.spawnEndermanHead(x - 3 + a3 * 6, y + 4, z - 2 + b * 4, x - 1 + a3 * 2, z);
                                                    for (int c = 0; c < 2; ++c) {
                                                        this.structure.setBlock(x - 3 + a3 * 6, y + c * 3, z + 2 - b * 4, Blocks.field_150476_ad, c * 4 + this.func_151555_a(Blocks.field_150446_ar, (b == 1 ? Facing.NORTH_NEGZ : Facing.SOUTH_POSZ).getStairs()));
                                                    }
                                                }
                                                for (b = 0; b < 4; ++b) {
                                                    this.structure.setBlock(x - 3 + a3 * 6, y + b, z, Blocks.field_150476_ad, (b % 2 == 1 ? 4 : 0) + this.func_151555_a(Blocks.field_150446_ar, (a3 == 1 ? Facing.EAST_POSX : Facing.WEST_NEGX).getStairs()));
                                                }
                                            }
                                            break block40;
                                        }
                                        if (n != 2) break block41;
                                        this.spawnEndermanSpawner(x, y, z, 2 + roomNb);
                                        for (a2 = 0; a2 < 2; ++a2) {
                                            this.spawnDispenser(x - 3 + a2 * 6, y, z, 0, 2, Facing.UP);
                                            this.spawnEndermanHead(x - 3 + a2 * 6, y + 1, z, x, z);
                                        }
                                        for (a2 = 0; a2 < 6 + rand.nextInt(10); ++a2) {
                                            int zz;
                                            int xx = x + rand.nextInt(7) - 3;
                                            if (this.structure.getBlock(xx, y, zz = z + rand.nextInt(7) - 3).func_149688_o() != Material.field_151579_a || !this.structure.getBlock(xx, y - 1, zz).func_149721_r()) continue;
                                            this.structure.setBlock(xx, y, zz, (Block)Blocks.field_150488_af, 0);
                                        }
                                        break block40;
                                    }
                                    if (n != 3) break block42;
                                    this.spawnDispenser(x, y, z, 0, 2, Facing.UP);
                                    this.structure.setBlock(x, y + 1, z, BlockList.death_flower_pot, rand.nextInt(3));
                                    for (int a4 = 0; a4 < 2; ++a4) {
                                        this.spawnEndermanSpawner(x - 3 + a4 * 6, y, z, 1 + roomNb);
                                        for (int b = 0; b < 2; ++b) {
                                            this.structure.setBlock(x - 3 + a4 * 6, y + 2, z - 2 + b * 4, BlockList.obsidian_stairs, 4 + this.func_151555_a(Blocks.field_150446_ar, (a4 == 1 ? Facing.EAST_POSX : Facing.WEST_NEGX).getStairs()));
                                            this.spawnEndermanHead(x - 3 + a4 * 6, y + 3, z - 2 + b * 4, x, z - 2 + b * 4);
                                        }
                                    }
                                    break block40;
                                }
                                if (n != 4) break block43;
                                for (int a5 = 0; a5 < 2; ++a5) {
                                    this.spawnDispenser(x - 3 + a5 * 6, y, z, 0, 2, Facing.UP);
                                    this.spawnEndermanHead(x - 3 + a5 * 6, y + 1, z, x, z);
                                    for (int b = 0; b < 2; ++b) {
                                        this.spawnEndermanSpawner(x - 3 + a5 * 6, y + 2, z - 2 + b * 4, 1 + roomNb);
                                        this.spawnEndermanSpawner(x - 2 + a5 * 4, y + 2, z - 3 + b * 6, 1 + roomNb);
                                        for (int c = 0; c < 2; ++c) {
                                            for (int d = 0; d < 2; ++d) {
                                                this.structure.setBlock(x - 3 + a5 * 6, y + c + 3 * d, z - 2 + b * 4, Blocks.field_150390_bg, c * 4 + this.func_151555_a(Blocks.field_150446_ar, (b == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                                                this.structure.setBlock(x - 2 + a5 * 4, y + c + 3 * d, z - 3 + b * 6, Blocks.field_150390_bg, c * 4 + this.func_151555_a(Blocks.field_150446_ar, (a5 == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                                            }
                                        }
                                    }
                                }
                                break block40;
                            }
                            if (n != 5) break block44;
                            for (int a6 = 0; a6 < 2; ++a6) {
                                this.structure.setBlock(x - 3 + a6 * 6, y, z, (Block)Blocks.field_150334_T, 0);
                                this.spawnEndermanHead(x - 3 + a6 * 6, y + 1, z, x, z);
                                for (int b = 0; b < 2; ++b) {
                                    this.spawnAnvil(x - 3 + a6 * 6, y, z - 1 + b * 2, Facing.NORTH_NEGZ, rand);
                                    this.structure.setBlock(x - 3 + a6 * 6, y, z - 2 + b * 4, (Block)Blocks.field_150334_T, 0);
                                    this.structure.setBlock(x - 3 + a6 * 6, y + 1, z - 2 + b * 4, Blocks.field_150390_bg, 4 + this.func_151555_a(Blocks.field_150446_ar, (a6 == 1 ? Facing.EAST_POSX : Facing.WEST_NEGX).getStairs()));
                                    for (int yy = y + 2; yy <= y + 3; ++yy) {
                                        this.structure.setBlock(x - 3 + a6 * 6, yy, z - 2 + b * 4, Blocks.field_150386_bk);
                                    }
                                    this.spawnEndermanSpawner(x - 3 + a6 * 6, y + 4, z - 2 + b * 4, 1 + roomNb);
                                    this.structure.setBlock(x - 1 + a6 * 2, y, z - 3 + b * 6, Blocks.field_150390_bg, this.func_151555_a(Blocks.field_150446_ar, (a6 == 1 ? Facing.EAST_POSX : Facing.WEST_NEGX).getStairs()));
                                    this.structure.setBlock(x - 2 + a6 * 4, y, z - 3 + b * 6, Blocks.field_150342_X, 0);
                                    this.spawnBrewingStand(x - 2 + a6 * 4, y + 1, z - 3 + b * 6, rand);
                                }
                            }
                            break block40;
                        }
                        if (n != 6) break block45;
                        this.spawnEndermanSpawner(x, y + 4, z, 2 + roomNb);
                        for (a = 0; a < 2; ++a) {
                            int yy;
                            for (int b = 0; b < 2; ++b) {
                                this.structure.setBlock(x - 3 + a * 6, y + b, z, Blocks.field_150387_bl, b * 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 1 ? Facing.EAST_POSX : Facing.WEST_NEGX).getStairs()));
                                this.spawnDispenser(x - 3 + a * 6, y, z - 2 + b * 4, 0, 1, Facing.UP);
                                this.structure.setBlock(x - 3 + a * 6, y + 1, z - 2 + b * 4, BlockList.death_flower_pot, rand.nextInt(5));
                            }
                            this.structure.setBlock(x - 3 + a * 6, y + 4, z, BlockList.obsidian_special, 1);
                            for (yy = y + 2; yy <= y + 3; ++yy) {
                                this.structure.setBlock(x - 3 + a * 6, yy, z, Blocks.field_150411_aY);
                            }
                            for (yy = y + 3; yy <= y + 4; ++yy) {
                                this.structure.setBlock(x - 2 + a * 4, yy, z, Blocks.field_150411_aY);
                            }
                            this.structure.setBlock(x - 1 + a * 2, y + 5, z, Blocks.field_150411_aY, 0);
                        }
                        for (a = 0; a < 5 + rand.nextInt(8); ++a) {
                            int zz;
                            int xx = x + rand.nextInt(7) - 3;
                            if (this.structure.getBlock(xx, y, zz = z + rand.nextInt(7) - 3).func_149688_o() != Material.field_151579_a || !this.structure.getBlock(xx, y - 1, zz).func_149721_r()) continue;
                            this.structure.setBlock(xx, y, zz, (Block)Blocks.field_150488_af, 0);
                        }
                        break block40;
                    }
                    if (n != 7) break block46;
                    int zOffset = isRoomEven ? -3 : 3;
                    this.structure.setBlock(x, y + 4, z - zOffset, Blocks.field_150390_bg, 4 + this.func_151555_a(Blocks.field_150446_ar, Facing.SOUTH_POSZ.getStairs()));
                    for (int a = 0; a < 2; ++a) {
                        for (int yy = y + 1; yy <= y + 3; ++yy) {
                            this.structure.setBlock(x - 3 + a * 6, yy, z, Blocks.field_150342_X);
                        }
                        for (int b = 0; b < 2; ++b) {
                            this.structure.setBlock(x - 3 + a * 6, y + 2, z - 1 + b * 2, Blocks.field_150342_X, 0);
                            this.structure.setBlock(x - 1 + b * 2, y + 2, z - 3 + a * 6, Blocks.field_150342_X, 0);
                            this.spawnEndermanSpawner(x - 3 + a * 6, y, z - 2 + b * 4, 1 + roomNb);
                            this.spawnEndermanSpawner(x - 2 + a * 4, y, z - 3 + b * 6, 1 + roomNb);
                            this.spawnAnvil(x - 2 + a * 4, y, z - 2 + b * 4, Facing.EAST_POSX, rand);
                            this.structure.setBlock(x - 2 + a * 4, y + 1, z - 2 + b * 4, Blocks.field_150374_bv, 0);
                            this.structure.setBlock(x - 2 + a * 4, y + 2, z - 2 + b * 4, (Block)Blocks.field_150333_U, 0);
                            this.structure.setBlock(x - 3 + a * 6, y + b * 4, z, Blocks.field_150390_bg, b * 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                            for (int c = 0; c < 2; ++c) {
                                for (int d = 0; d < 2; ++d) {
                                    this.structure.setBlock(x - 3 + a * 6, y + c + 3 * d, z - 1 + b * 2, Blocks.field_150390_bg, c * 4 + this.func_151555_a(Blocks.field_150446_ar, (b == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                                    this.structure.setBlock(x - 1 + a * 2, y + c + 3 * d, z - 3 + b * 6, Blocks.field_150390_bg, c * 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                                }
                            }
                        }
                    }
                    break block40;
                }
                if (n != 8) break block47;
                for (int[] xz : pillars = new int[][]{{-2, -1}, {0, -2}, {1, -2}, {1, -3}, {-3, 2}, {-1, 2}, {-1, 3}, {0, 1}, {3, 1}}) {
                    for (int yy = y; yy <= y + 4; ++yy) {
                        this.structure.setBlock(x + xz[0], yy, z + xz[1], BlockList.obsidian_special, 2);
                    }
                    if (!(rand.nextFloat() < 0.25f)) continue;
                    this.spawnEndermanSpawner(x + xz[0], y + rand.nextInt(5), z + xz[1], 1);
                }
                for (int yy = y; yy <= y + 1; ++yy) {
                    this.structure.setBlock(x + 2, yy, z - 1, BlockList.obsidian_special, 2);
                }
                this.spawnEndermanSpawner(x + 2, y + 2, z - 1, 2 + roomNb);
                this.structure.setBlock(x + 2, y + 3, z - 1, BlockList.obsidian_stairs, this.func_151555_a(Blocks.field_150446_ar, Facing.SOUTH_POSZ.getStairs()));
                int placed = 0;
                for (int attempt = 0; attempt < 8 && placed < rand.nextInt(4); ++attempt) {
                    int zz;
                    int xx = x + rand.nextInt(7) - 3;
                    if (!this.structure.isAir(xx, y, zz = z + rand.nextInt(7) - 3)) continue;
                    this.spawnEndermanSpawner(xx, y, zz, 1);
                    ++placed;
                }
                this.spawnChest(x + 2, y, z - 3, rand.nextBoolean(), 3, 5, Facing.SOUTH_POSZ);
                break block40;
            }
            if (n != 9) break block40;
            this.structure.setBlock(x, y, z, Blocks.field_150381_bn, 0);
            for (int yy = y + 3 + (roomNb == 0 ? 1 : 0); yy <= y + 4; ++yy) {
                this.structure.setBlock(x, yy, z + (isRoomEven ? 3 : -3), Blocks.field_150343_Z);
            }
            for (int a = 0; a < 2; ++a) {
                this.spawnEndermanSpawner(x - 3 + a * 6, y + 2, z, 3 + roomNb);
                this.structure.setBlock(x, y + 4, z - 2 + a * 4, BlockList.obsidian_stairs, 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                for (int b = 0; b < 2; ++b) {
                    int yy;
                    for (yy = y + b * 3; yy <= y + 1 + b * 3; ++yy) {
                        this.structure.setBlock(x - 3 + a * 6, yy, z, Blocks.field_150343_Z);
                    }
                    this.structure.setBlock(x - 2 + 4 * a, y + 4 * b, z, BlockList.obsidian_stairs, 4 * b + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                    for (yy = y; yy <= y + 4; ++yy) {
                        this.structure.setBlock(x - 3 + a * 6, yy, z - 2 + b * 4, Blocks.field_150342_X);
                    }
                    for (yy = y; yy <= y + 4; ++yy) {
                        this.structure.setBlock(x - 2 + a * 4, yy, z - 3 + b * 6, Blocks.field_150342_X);
                    }
                    this.structure.setBlock(x - 3 + a * 6, y, z - 1 + b * 2, Blocks.field_150476_ad, 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                    this.structure.setBlock(x - 1 + a * 2, y, z - 3 + b * 6, Blocks.field_150476_ad, 4 + this.func_151555_a(Blocks.field_150446_ar, (b == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                    for (int c = 0; c < 2; ++c) {
                        int zz;
                        if (!(rand.nextFloat() < 0.42f)) continue;
                        int xx = c == 0 ? x - 3 + a * 6 : x - 1 + a * 2;
                        int n2 = zz = c == 0 ? z - 1 + b * 2 : z - 3 + b * 6;
                        if (rand.nextBoolean()) {
                            this.structure.setBlock(xx, y + 1, zz, BlockList.death_flower_pot, rand.nextInt(10) == 0 ? 15 : rand.nextInt(4));
                            continue;
                        }
                        this.spawnBrewingStand(xx, y + 1, zz, rand);
                    }
                }
            }
        }
    }

    private void generateChestRoom(int x, int y, int z, int roomNb, Random rand) {
        block12: {
            boolean isRoomEven;
            int n;
            block13: {
                int yy;
                block11: {
                    n = rand.nextInt(3) + 1;
                    boolean bl = isRoomEven = roomNb % 2 == 0;
                    if (n != 1) break block11;
                    for (int a = 0; a < 2; ++a) {
                        this.spawnChest(x - 3 + a * 6, y, z, false, 7, 11, a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX);
                        for (int b = 0; b < 2; ++b) {
                            int yy2;
                            this.spawnEndermanSpawner(x - 3 + a * 6, y, z - 2 + b * 4, 2);
                            this.spawnEndermanSpawner(x - 2 + a * 4, y, z - 3 + b * 6, 2);
                            this.structure.setBlock(x - 2 + a * 4, y, z - 2 + b * 4, BlockList.obsidian_special, 2);
                            this.spawnEndermanHead(x - 2 + a * 4, y + 1, z - 2 + b * 4, x, z);
                            for (yy2 = y + 2; yy2 <= y + 3; ++yy2) {
                                this.structure.setBlock(x - 3 + a * 6, yy2, z - 2 + b * 4, Blocks.field_150386_bk);
                            }
                            this.structure.setBlock(x - 3 + a * 6, y + 4, z - 2 + b * 4, (Block)Blocks.field_150438_bZ, 0);
                            for (yy2 = y + 2; yy2 <= y + 3; ++yy2) {
                                this.structure.setBlock(x - 2 + a * 4, yy2, z - 3 + b * 6, Blocks.field_150386_bk);
                            }
                            this.structure.setBlock(x - 2 + a * 4, y + 4, z - 3 + b * 6, (Block)Blocks.field_150438_bZ, 0);
                            this.structure.setBlock(x - 3 + a * 6, y, z - 1 + b * 2, BlockList.obsidian_stairs, this.func_151555_a(Blocks.field_150476_ad, (b == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                            this.structure.setBlock(x - 3 + a * 6, y + 1, z - 2 + b * 4, BlockList.obsidian_stairs, this.func_151555_a(Blocks.field_150476_ad, (b == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                            this.structure.setBlock(x - 1 + b * 2, y, z - 3 + a * 6, BlockList.obsidian_stairs, this.func_151555_a(Blocks.field_150476_ad, (b == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                            this.structure.setBlock(x - 2 + b * 4, y + 1, z - 3 + a * 6, BlockList.obsidian_stairs, this.func_151555_a(Blocks.field_150476_ad, (b == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                        }
                    }
                    break block12;
                }
                if (n != 2) break block13;
                for (int a = 0; a < 2; ++a) {
                    this.spawnEndermanSpawner(x - 3 + a * 6, y, z, 6);
                    for (yy = y + 1; yy <= y + 3; ++yy) {
                        this.structure.setBlock(x - 3 + a * 6, yy, z, Blocks.field_150386_bk);
                    }
                    this.structure.setBlock(x - 3 + a * 6, y + 4, z, (Block)Blocks.field_150438_bZ, 0);
                    for (int b = 0; b < 2; ++b) {
                        for (int c = 0; c < 2; ++c) {
                            this.spawnChest(x - 3 + a * 6, y, z + (c + 1) * (-1 + b * 2), true, 0, rand.nextInt(5) <= 1 ? 4 : 2, a == 0 ? Facing.EAST_POSX : Facing.WEST_NEGX);
                            this.spawnChest(x + (c + 1) * (-1 + b * 2), y, z - 3 + a * 6, true, 0, rand.nextInt(5) <= 1 ? 4 : 2, a == 0 ? Facing.NORTH_NEGZ : Facing.SOUTH_POSZ);
                            this.structure.setBlock(x - 3 + a * 6, y + 2 + c * 2, z - 1 + b * 2, Blocks.field_150390_bg, 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                            this.structure.setBlock(x - 3 + a * 6, y + 2 + c * 2, z - 2 + b * 4, Blocks.field_150390_bg, 4 + this.func_151555_a(Blocks.field_150446_ar, (b == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                            this.structure.setBlock(x - 1 + a * 2, y + 2 + c * 2, z - 3 + b * 6, Blocks.field_150390_bg, 4 + this.func_151555_a(Blocks.field_150446_ar, (b == 0 ? Facing.SOUTH_POSZ : Facing.NORTH_NEGZ).getStairs()));
                            this.structure.setBlock(x - 2 + a * 4, y + 2 + c * 2, z - 3 + b * 6, Blocks.field_150390_bg, 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                        }
                        this.structure.setBlock(x - 2 + a * 4, y + 4, z - 2 + b * 4, Blocks.field_150390_bg, 4 + this.func_151555_a(Blocks.field_150446_ar, (a == 0 ? Facing.WEST_NEGX : Facing.EAST_POSX).getStairs()));
                        this.spawnFurnace(x - 3 + a * 6, y + 3, z - 2 + b * 4, 0.35f, a == 0 ? Facing.EAST_POSX : Facing.WEST_NEGX, rand);
                        this.spawnFurnace(x - 2 + a * 4, y + 3, z - 3 + b * 6, 0.35f, b == 0 ? Facing.NORTH_NEGZ : Facing.SOUTH_POSZ, rand);
                    }
                }
                int zOffset = isRoomEven ? 3 : -3;
                for (yy = y + 2; yy <= y + 3; ++yy) {
                    this.structure.setBlock(x, yy, z + zOffset, Blocks.field_150386_bk);
                }
                this.structure.setBlock(x, y + 4, z + zOffset, (Block)Blocks.field_150438_bZ, 0);
                break block12;
            }
            if (n != 3) break block12;
            this.spawnChest(x, y, z, false, 17, 21, isRoomEven ? Facing.NORTH_NEGZ : Facing.SOUTH_POSZ);
            this.structure.setBlock(x, y + 2, z, BlockList.obsidian_special_glow, 2, true);
            this.spawnEndermanSpawner(x, y + 3, z, 7);
            for (int a = 0; a < 2; ++a) {
                this.structure.setBlock(x - 1 + a * 2, y + 3, z, Blocks.field_150343_Z, 0);
                this.structure.setBlock(x, y + 3, z - 1 + a * 2, Blocks.field_150343_Z, 0);
                this.structure.setBlock(x - 2 + a * 4, y + 4, z, Blocks.field_150343_Z, 0);
                this.structure.setBlock(x, y + 4, z - 2 + a * 4, Blocks.field_150343_Z, 0);
                for (int b = 0; b < 2; ++b) {
                    this.structure.setBlock(x - 1 + a * 2, y + 4, z - 1 + b * 2, Blocks.field_150343_Z, 0);
                    this.structure.setBlock(x - 3 + a * 6, y, z - 2 + b * 4, Blocks.field_150386_bk, 0);
                    this.structure.setBlock(x - 3 + a * 6, y + 1, z - 2 + b * 4, Blocks.field_150478_aa, 5);
                    this.structure.setBlock(x - 2 + a * 4, y, z - 3 + b * 6, Blocks.field_150386_bk, 0);
                    this.structure.setBlock(x - 2 + a * 4, y + 1, z - 3 + b * 6, Blocks.field_150478_aa, 5);
                }
            }
        }
    }

    private void spawnBrewingStand(int x, int y, int z, Random rand) {
        this.structure.setBlock(x, y, z, rand.nextInt(100) == 0 ? BlockList.enhanced_brewing_stand : Blocks.field_150382_bo, 0);
        this.structure.setTileEntityGenerator(x, y, z, "BrewingStand", this);
    }

    private void spawnChest(int x, int y, int z, boolean isTrapped, int minItems, int maxItems, Facing facing) {
        this.structure.setBlock(x, y, z, (Block)(isTrapped ? Blocks.field_150447_bR : Blocks.field_150486_ae), this.func_151555_a((Block)Blocks.field_150486_ae, facing.get6Directional()));
        this.structure.setTileEntityGenerator(x, y, z, "Chest:" + minItems + ":" + maxItems, this);
    }

    private void spawnDispenser(int x, int y, int z, int minItems, int maxItems, Facing facing) {
        int meta = facing.get6Directional();
        if (facing != Facing.DOWN && facing != Facing.UP) {
            meta = this.func_151555_a(Blocks.field_150367_z, meta);
        }
        this.structure.setBlock(x, y, z, Blocks.field_150367_z, meta);
        this.structure.setTileEntityGenerator(x, y, z, "Dispenser:" + minItems + ":" + maxItems + ":" + meta, this);
    }

    private void spawnFurnace(int x, int y, int z, float fuelChance, Facing facing, Random rand) {
        this.structure.setBlock(x, y, z, Blocks.field_150460_al, this.func_151555_a(Blocks.field_150423_aK, facing.get6Directional()));
        if (rand.nextFloat() < fuelChance) {
            this.structure.setTileEntityGenerator(x, y, z, "Furnace", this);
        }
    }

    private void spawnEndermanHead(int x, int y, int z, Facing facing) {
        this.structure.setBlock(x, y, z, BlockList.enderman_head, this.func_151555_a(Blocks.field_150465_bP, facing.getSkull()));
        this.structure.setTileEntityGenerator(x, y, z, "Skull", this);
    }

    private void spawnEndermanHead(int x, int y, int z, int pointingAtX, int pointingAtZ) {
        this.structure.setBlock(x, y, z, BlockList.enderman_head, 1);
        this.structure.setTileEntityGenerator(x, y, z, "Head:" + (byte)Math.floor(90.0 + MathUtil.toDeg(Math.atan2(pointingAtZ - z, pointingAtX - x)) / 22.5), this);
    }

    private void spawnEndermanSpawner(int x, int y, int z, int difficulty) {
        this.structure.setBlock(x, y, z, BlockList.custom_spawner, 0);
        this.structure.setTileEntityGenerator(x, y, z, "Spawner:" + difficulty, this);
    }

    private void spawnAnvil(int x, int y, int z, Facing facing, Random rand) {
        float broken;
        int meta = facing.getAnvil();
        if (this.field_74885_f == 1 || this.field_74885_f == 3) {
            meta = 1 - meta;
        }
        if ((broken = rand.nextFloat()) < 0.25f) {
            meta |= 8;
        } else if (broken < 0.7f) {
            meta |= 4;
        }
        this.structure.setBlock(x, y, z, Blocks.field_150467_bQ, meta);
    }

    @Override
    public void onTileEntityRequested(String key, TileEntity tile, Random rand) {
        block13: {
            block15: {
                CustomSpawnerLogic logic;
                block14: {
                    block12: {
                        if (!key.startsWith("Chest:")) break block12;
                        String[] split = StringUtils.split((String)key, (String)":", (int)3);
                        int minItems = DragonUtil.tryParse(split[1], 0);
                        int maxItems = DragonUtil.tryParse(split[2], 0);
                        TileEntityChest chest = (TileEntityChest)tile;
                        for (int a = 0; a < rand.nextInt(maxItems - minItems + 1) + minItems; ++a) {
                            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), lootTower.generateIS(rand));
                        }
                        break block13;
                    }
                    if (!key.startsWith("Dispenser:")) break block14;
                    String[] split = StringUtils.split((String)key, (String)":", (int)4);
                    int minItems = DragonUtil.tryParse(split[1], 0);
                    int maxItems = DragonUtil.tryParse(split[2], 0);
                    TileEntityDispenser dispenser = (TileEntityDispenser)tile;
                    for (int a = 0; a < rand.nextInt(maxItems - minItems + 1) + minItems; ++a) {
                        dispenser.func_70299_a(rand.nextInt(dispenser.func_70302_i_()), lootTower.generateIS(rand));
                    }
                    tile.field_145847_g = DragonUtil.tryParse(split[3], 0);
                    break block13;
                }
                if (!key.startsWith("Spawner:")) break block15;
                int minY = tile.field_145848_d + 32;
                int difficulty = DragonUtil.tryParse(StringUtils.split((String)key, (String)":", (int)2)[1], 0);
                ArrayList<Potion> availablePotions = CollectionUtil.newList(Potion.field_76420_g, Potion.field_76424_c, Potion.field_76428_l, Potion.field_76429_m, Potion.field_76426_n);
                ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                int amount = (int)Math.round((double)difficulty / 2.7) + rand.nextInt(1 + MathUtil.ceil((double)difficulty / 3.0));
                for (int a = 0; a < amount; ++a) {
                    Potion potion = (Potion)availablePotions.get(rand.nextInt(availablePotions.size()));
                    effects.add(new PotionEffect(potion.field_76415_H, 12000, Math.min(3, MathUtil.floor((double)difficulty / 4.4 + rand.nextDouble() * ((double)difficulty / 3.8)))));
                    availablePotions.remove(potion);
                    if (availablePotions.isEmpty()) break;
                }
                if (!((logic = ((TileEntityCustomSpawner)tile).getSpawnerLogic()) instanceof TowerEndermanSpawnerLogic)) break block13;
                ((TowerEndermanSpawnerLogic)logic).setSpawnEffects(effects).setTestingY(minY, minY + 6 - 2);
                break block13;
            }
            if (key.startsWith("Head:")) {
                ((TileEntityEndermanHead)tile).setRotation(DragonUtil.tryParse(StringUtils.split((String)key, (String)":", (int)2)[1], 0));
            } else if (key.equals("Head")) {
                tile.field_145847_g = -1;
                tile.func_145832_p();
            } else if (key.equals("Furnace")) {
                ((TileEntityFurnace)tile).func_70299_a(1, lootFuel.generateIS(rand));
            } else if (key.startsWith("BrewingStand")) {
                TileEntityBrewingStand brewingStand = (TileEntityBrewingStand)tile;
                TByteArrayList slots = new TByteArrayList(3);
                for (byte a = 0; a < 3; a = (byte)(a + 1)) {
                    slots.add(a);
                }
                float r = rand.nextFloat();
                int fill = r > 0.9f ? 3 : (r > 0.6f ? 2 : (r > 0.25f ? 1 : 0));
                for (int a = 0; a < fill; ++a) {
                    byte slot = slots.get(rand.nextInt(slots.size()));
                    slots.remove(slot);
                    int data = this.potionData[rand.nextInt(this.potionData.length)];
                    brewingStand.func_70299_a((int)slot, new ItemStack((Item)Items.field_151068_bn, 1, data > 16 && rand.nextInt(5) == 0 ? data | 0x4000 : data));
                }
            }
        }
    }
}

