/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.decorator;

import chylex.hee.entity.block.EntityBlockHomelandCache;
import chylex.hee.entity.mob.EntityMobHomelandEnderman;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.misc.HomelandEndermen;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.IslandBiomeEnchantedIsland;
import chylex.hee.world.structure.island.biome.decorator.IslandBiomeDecorator;
import chylex.hee.world.structure.island.biome.feature.island.StructureGooLake;
import chylex.hee.world.structure.island.biome.feature.island.StructureHiddenCellar;
import chylex.hee.world.structure.island.biome.feature.island.StructureLaboratory;
import chylex.hee.world.structure.island.biome.feature.island.StructureObsidianRoad;
import chylex.hee.world.structure.island.biome.feature.island.StructureShadowOrchid;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;

public class BiomeDecoratorEnchantedIsland
extends IslandBiomeDecorator {
    private final StructureGooLake genGooLake = new StructureGooLake();
    private final StructureObsidianRoad genRoads = new StructureObsidianRoad();
    private final StructureHiddenCellar genCellar = new StructureHiddenCellar();
    private final StructureLaboratory genLaboratory = new StructureLaboratory();
    private final StructureShadowOrchid genShadowOrchid = new StructureShadowOrchid();

    @Override
    protected final IslandBiomeBase getBiome() {
        return IslandBiomeBase.enchantedIsland;
    }

    public void genHomeland() {
        int attempt;
        this.genCellar.setVariation(StructureHiddenCellar.EnchantedIslandVariation.HOMELAND);
        int placed = 0;
        for (int attempt2 = 0; attempt2 < 20 && placed < 4 + this.rand.nextInt(3); ++attempt2) {
            if (!this.genCellar.generateInWorld(this.world, this.rand, this.getBiome())) continue;
            ++placed;
        }
        boolean swamp = this.data.hasDeviation(IslandBiomeEnchantedIsland.GOO_SWAMP);
        int placed2 = 0;
        int amount = this.rand.nextInt(3) + 5;
        for (attempt = 0; attempt < (swamp ? 450 : 170) && placed2 < (swamp ? amount * 3 : amount); ++attempt) {
            if (!this.generateStructure(this.genGooLake)) continue;
            ++placed2;
        }
        for (int cx = 0; cx < this.world.getChunkAmountX(); ++cx) {
            for (int cz = 0; cz < this.world.getChunkAmountZ(); ++cz) {
                int zz;
                int xx;
                int oz;
                if (this.rand.nextInt(5) > 2) continue;
                int height = this.rand.nextInt(14) + (this.data.hasDeviation(IslandBiomeEnchantedIsland.TALL_PILES) ? 6 + this.rand.nextInt(12) : 4);
                int radius = this.rand.nextInt(2) + 1;
                int ox = cx * 16 + this.rand.nextInt(16);
                int oy = this.world.getHighestY(ox, oz = cz * 16 + this.rand.nextInt(16));
                if (oy <= 0) continue;
                boolean generateObsidian = true;
                for (xx = ox - radius; xx <= ox + radius && generateObsidian; ++xx) {
                    for (zz = oz - radius; zz <= oz + radius && generateObsidian; ++zz) {
                        if (MathUtil.square(xx - ox) + MathUtil.square(zz - oz) > radius * radius + 1 || Math.abs(this.world.getHighestY(xx, zz) - oy) <= 2) continue;
                        generateObsidian = false;
                    }
                }
                if (!generateObsidian) continue;
                for (xx = ox - radius; xx <= ox + radius; ++xx) {
                    for (zz = oz - radius; zz <= oz + radius; ++zz) {
                        for (int yy = this.world.getHighestY(xx, zz) + 1; yy < oy + height && yy < 128; ++yy) {
                            if (!((double)(MathUtil.square(xx - ox) + MathUtil.square(zz - oz)) <= (double)(radius * radius) + 0.5 + this.rand.nextGaussian() * 0.7)) continue;
                            this.world.setBlock(xx, yy, zz, BlockList.obsidian_falling, 0, true);
                        }
                    }
                }
            }
        }
        placed2 = 0;
        int placedMax = 8 + this.rand.nextInt(5);
        for (attempt = 0; attempt < 36 && placed2 < placedMax; ++attempt) {
            if (!this.generateStructure(this.genRoads)) continue;
            ++placed2;
        }
        int n = attempt = this.data.hasDeviation(IslandBiomeEnchantedIsland.MORE_SHADOW_ORCHIDS) ? 750 : 450;
        while (attempt > 0) {
            if (this.generateStructure(this.genShadowOrchid)) {
                ++attempt;
            }
            --attempt;
        }
        placed2 = 14 + this.rand.nextInt(10);
        block11: for (attempt = 280 + this.rand.nextInt(42); attempt > 0 && placed2 > 0; --attempt) {
            int zz;
            int yy;
            int xx = this.rand.nextInt(198) + 5;
            if (this.world.getBlock(xx, yy = this.world.getHighestY(xx, zz = this.rand.nextInt(198) + 5), zz) != BlockList.end_terrain) continue;
            for (int obsidianSearch = 0; obsidianSearch < 40; ++obsidianSearch) {
                Block block = this.world.getBlock(xx + this.rand.nextInt(11) - 5, yy, zz + this.rand.nextInt(11) - 5);
                if (block != Blocks.field_150343_Z && block != BlockList.obsidian_falling) continue;
                EntityBlockHomelandCache cache = new EntityBlockHomelandCache(null);
                cache.func_70107_b((double)xx + 0.5, (double)yy + 1.0, (double)zz + 0.5);
                this.world.addEntity(cache);
                --placed2;
                continue block11;
            }
        }
        TObjectIntHashMap map = new TObjectIntHashMap();
        int spawnedTotal = 52 + this.rand.nextInt(28) + this.rand.nextInt(16);
        block13: for (int spawnAttempt = 0; spawnAttempt < spawnedTotal; ++spawnAttempt) {
            EntityMobHomelandEnderman enderman = new EntityMobHomelandEnderman(null);
            HomelandEndermen.HomelandRole role = HomelandEndermen.HomelandRole.getRandomRole(this.rand);
            enderman.setHomelandRole(role);
            map.adjustOrPutValue((Object)role, 1, 1);
            for (int posAttempt = 0; posAttempt < 30; ++posAttempt) {
                int zz;
                int yy;
                int xx = this.rand.nextInt(168) + 20;
                if (this.world.getBlock(xx, yy = this.world.getHighestY(xx, zz = this.rand.nextInt(168) + 20), zz) != topBlock) continue;
                enderman.func_70107_b(xx, yy + 1, zz);
                this.world.addEntity((Entity)enderman);
                continue block13;
            }
        }
        List<EntityMobHomelandEnderman> endermanList = this.world.getAllEntities(EntityMobHomelandEnderman.class);
        int size = endermanList.size();
        if (size > 0) {
            for (int leaders = 1 + this.rand.nextInt(3 + this.rand.nextInt(3)); leaders > 0 && size > 0; --leaders) {
                endermanList.remove(this.rand.nextInt(size--)).setHomelandRole(HomelandEndermen.HomelandRole.ISLAND_LEADERS);
            }
        }
        for (int groupLeaders = this.rand.nextInt(3 + this.rand.nextInt(3) * this.rand.nextInt(2)); groupLeaders > 0 && size > 0; --groupLeaders) {
            int state;
            long groupId;
            if ((groupId = endermanList.remove(this.rand.nextInt(size--)).setNewGroupLeader()) == -1L) continue;
            int n2 = state = this.rand.nextBoolean() ? this.rand.nextInt(1 + this.rand.nextInt(4 + this.rand.nextInt(8))) : 0;
            while (state > 0 && size > 0) {
                endermanList.remove(this.rand.nextInt(size--)).setGroupMember(groupId, HomelandEndermen.OvertakeGroupRole.getRandomMember(this.rand));
                --state;
            }
        }
    }

    public void genLaboratory() {
        int attempt;
        this.genCellar.setVariation(StructureHiddenCellar.EnchantedIslandVariation.LABORATORY);
        int placed = 0;
        for (attempt = 0; attempt < 20 && placed < 4 + this.rand.nextInt(3); ++attempt) {
            if (!this.genCellar.generateInWorld(this.world, this.rand, this.getBiome())) continue;
            ++placed;
        }
        this.genLaboratory.generateInWorld(this.world, this.rand, this.getBiome());
        int placed2 = 0;
        block1: for (int amount = 30 + this.rand.nextInt(6) + this.rand.nextInt(8); amount > 0; --amount) {
            for (int attempt2 = 0; attempt2 < 6; ++attempt2) {
                int yAttempt;
                int zz;
                int xx = this.rand.nextInt(178) + 15;
                int yy = this.world.getHighestY(xx, zz = this.rand.nextInt(178) + 15);
                if (yy == 0 || this.world.getBlock(xx, yy, zz) != BlockList.end_terrain) continue;
                for (yAttempt = 0; yAttempt < 7; ++yAttempt) {
                    int tmpY = yy - this.rand.nextInt(20);
                    if (tmpY <= 0 || this.world.getBlock(xx, tmpY, zz) != BlockList.end_terrain || !this.world.isAir(xx, tmpY + 1, zz)) continue;
                    yy = tmpY;
                    break;
                }
                for (int clumps = 4 + this.rand.nextInt(15); clumps >= 0; --clumps) {
                    placed2 = 0;
                    block5: for (int placeAttempt = 0; placeAttempt < 12 + this.rand.nextInt(30); ++placeAttempt) {
                        int px = xx + MathUtil.floor(25.0f * (this.rand.nextFloat() - 0.5f) * this.rand.nextFloat());
                        int pz = zz + MathUtil.floor(25.0f * (this.rand.nextFloat() - 0.5f) * this.rand.nextFloat());
                        int py = yy + this.rand.nextInt(4);
                        for (yAttempt = 0; yAttempt < 5; ++yAttempt) {
                            if (this.world.getBlock(px, py - 1, pz) == BlockList.end_terrain && this.world.isAir(px, py, pz)) {
                                this.world.setBlock(px, py, pz, BlockList.crossed_decoration, this.rand.nextInt(4) == 0 ? 7 : (this.rand.nextInt(3) == 0 ? 8 : 9));
                                ++placed2;
                                continue block5;
                            }
                            if (--py <= 0) continue block5;
                        }
                    }
                    if (this.rand.nextInt(20) == 0 || placed2 == 0) continue block1;
                    float ang = (float)((double)(this.rand.nextFloat() * 2.0f) * Math.PI);
                    float dist = 8.0f + this.rand.nextFloat() * 10.0f;
                    xx = (int)((float)xx + (float)((int)MathHelper.func_76134_b((float)ang)) * dist);
                    zz = (int)((float)zz + (float)((int)MathHelper.func_76126_a((float)ang)) * dist);
                    yy += this.rand.nextInt(3) - this.rand.nextInt(3);
                }
                continue block1;
            }
        }
        int n = attempt = this.data.hasDeviation(IslandBiomeEnchantedIsland.MORE_SHADOW_ORCHIDS) ? 550 : 350;
        while (attempt > 0) {
            if (this.generateStructure(this.genShadowOrchid)) {
                ++attempt;
            }
            --attempt;
        }
    }
}

