/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity.spawner;

import chylex.hee.entity.mob.EntityMobLouse;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.tileentity.TileEntityCustomSpawner;
import chylex.hee.tileentity.spawner.CustomSpawnerLogic;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LouseRavagedSpawnerLogic
extends CustomSpawnerLogic {
    private LouseSpawnData louseData;

    public LouseRavagedSpawnerLogic(TileEntityCustomSpawner spawnerTile) {
        super(spawnerTile);
        this.field_98283_g = 85;
        this.field_98293_h = 220;
        this.field_98290_m = (byte)3;
        this.field_98294_i = (byte)2;
        this.field_98292_k = (byte)5;
        this.field_98289_l = (byte)12;
    }

    public void setLouseSpawnData(LouseSpawnData louseData) {
        this.louseData = louseData;
    }

    @Override
    protected AxisAlignedBB getSpawnerCheckBB() {
        int sx = this.func_98275_b();
        int sy = this.func_98274_c();
        int sz = this.func_98266_d();
        return AxisAlignedBB.func_72330_a((double)sx, (double)sy, (double)sz, (double)(sx + 1), (double)(sy + 1), (double)(sz + 1)).func_72314_b((double)this.field_98290_m * 2.0, 2.5, (double)this.field_98290_m * 2.0);
    }

    @Override
    protected boolean checkSpawnerConditions() {
        int sx = this.func_98275_b();
        int sy = this.func_98274_c();
        int sz = this.func_98266_d();
        return this.func_98271_a().func_72872_a(EntityMobLouse.class, AxisAlignedBB.func_72330_a((double)sx, (double)sy, (double)sz, (double)(sx + 1), (double)(sy + 1), (double)(sz + 1)).func_72314_b(10.0, 10.0, 10.0)).size() <= 9;
    }

    @Override
    protected boolean canMobSpawn(EntityLiving entity) {
        int spawnerY;
        for (int yy = spawnerY = this.func_98274_c(); yy > spawnerY - 5; --yy) {
            if (BlockPosM.tmp(entity.field_70165_t, (double)yy, entity.field_70161_v).isAir(entity.field_70170_p) && yy != spawnerY - 4) continue;
            entity.func_70012_b(entity.field_70165_t, (double)(yy + 1), entity.field_70161_v, entity.field_70177_z, 0.0f);
            if (!entity.field_70170_p.func_72855_b(entity.field_70121_D) || !entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void func_98280_b(NBTTagCompound nbt) {
        super.func_98280_b(nbt);
        if (this.louseData == null) {
            this.louseData = new LouseSpawnData(0, this.func_98271_a().field_73012_v);
        }
        nbt.func_74782_a("louseData", (NBTBase)this.louseData.writeToNBT(new NBTTagCompound()));
    }

    public void func_98270_a(NBTTagCompound nbt) {
        super.func_98270_a(nbt);
        this.louseData = new LouseSpawnData(nbt.func_74775_l("louseData"));
    }

    @Override
    protected EntityLiving createMob(World world) {
        return new EntityMobLouse(world, this.louseData);
    }

    public static final class LouseSpawnData {
        public static final byte maxLevel = 3;
        public final byte level;
        private final Set<EnumLouseAttribute> attributes = new HashSet<EnumLouseAttribute>();
        private final Set<EnumLouseAbility> abilities = new HashSet<EnumLouseAbility>();

        public LouseSpawnData(int level, Random rand) {
            this.level = (byte)level;
            if (level == 0 || rand.nextInt(3) != 0) {
                int amt = level == 1 && rand.nextBoolean() || level == 2 && rand.nextInt(4) != 0 ? 2 : 1;
                for (int a = 0; a < amt; ++a) {
                    this.attributes.add(EnumLouseAttribute.values[rand.nextInt(EnumLouseAttribute.values.length)]);
                }
            } else {
                this.attributes.add(EnumLouseAttribute.values[rand.nextInt(EnumLouseAttribute.values.length)]);
                this.abilities.add(EnumLouseAbility.values[rand.nextInt(EnumLouseAbility.values.length)]);
            }
        }

        public LouseSpawnData(NBTTagCompound tag) {
            this.level = tag.func_74771_c("lvl");
            for (EnumLouseAttribute enumLouseAttribute : EnumLouseAttribute.values) {
                if (!tag.func_74764_b("attr-" + enumLouseAttribute.name())) continue;
                this.attributes.add(enumLouseAttribute);
            }
            for (Enum enum_ : EnumLouseAbility.values) {
                if (!tag.func_74764_b("abil-" + enum_.name())) continue;
                this.abilities.add((EnumLouseAbility)enum_);
            }
        }

        public LouseSpawnData(String serializedString) {
            String[] parts = serializedString.split("/");
            if (parts.length != 3) {
                this.level = 0;
            } else {
                byte lvl = 0;
                try {
                    int ordinal;
                    lvl = (byte)Integer.parseInt(parts[0]);
                    for (String s : parts[1].split("\\+")) {
                        if (s.equals("nil")) break;
                        ordinal = Integer.parseInt(s);
                        if (ordinal < 0 || ordinal >= EnumLouseAttribute.values.length) continue;
                        this.attributes.add(EnumLouseAttribute.values[ordinal]);
                    }
                    for (String s : parts[2].split("\\+")) {
                        if (s.equals("nil")) break;
                        ordinal = Integer.parseInt(s);
                        if (ordinal < 0 || ordinal >= EnumLouseAbility.values.length) continue;
                        this.abilities.add(EnumLouseAbility.values[ordinal]);
                    }
                }
                catch (NumberFormatException e) {
                    Log.throwable(e, "Invalid spawner data format: $0", serializedString);
                }
                this.level = lvl;
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74774_a("lvl", this.level);
            for (EnumLouseAttribute attribute : this.attributes) {
                tag.func_74757_a("attr-" + attribute.name(), true);
            }
            for (EnumLouseAbility ability : this.abilities) {
                tag.func_74757_a("abil-" + ability.name(), true);
            }
            return tag;
        }

        public int attribute(EnumLouseAttribute attribute) {
            return this.attributes.contains((Object)attribute) ? this.level + 1 : 0;
        }

        public int ability(EnumLouseAbility ability) {
            return this.abilities.contains((Object)ability) ? this.level + 1 : 0;
        }

        public Set<EnumLouseAttribute> getAttributeSet() {
            return this.attributes;
        }

        public Set<EnumLouseAbility> getAbilitySet() {
            return this.abilities;
        }

        public String serializeToString() {
            StringBuilder build = new StringBuilder();
            build.append(this.level).append('/');
            for (EnumLouseAttribute attribute : this.attributes) {
                build.append(attribute.ordinal()).append('+');
            }
            if (!this.attributes.isEmpty()) {
                build.deleteCharAt(build.length() - 1);
            } else {
                build.append("nil");
            }
            build.append('/');
            for (EnumLouseAbility ability : this.abilities) {
                build.append(ability.ordinal()).append('+');
            }
            if (!this.abilities.isEmpty()) {
                build.deleteCharAt(build.length() - 1);
            } else {
                build.append("nil");
            }
            return build.toString();
        }

        public static enum EnumLouseAbility {
            KNOCKBACK,
            MAGICDMG,
            HEAL;

            public static final EnumLouseAbility[] values;

            static {
                values = EnumLouseAbility.values();
            }
        }

        public static enum EnumLouseAttribute {
            ATTACK,
            SPEED,
            HEALTH,
            ARMOR,
            TELEPORT;

            public static final EnumLouseAttribute[] values;

            static {
                values = EnumLouseAttribute.values();
            }
        }
    }
}

