/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.orb;

import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.util.ItemPattern;
import gnu.trove.list.array.TShortArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WeightedItem
implements IWeightProvider {
    private Item item;
    private short[] possibleDamageValues;
    private int weight;

    public WeightedItem(Block block, int damage, int weight) {
        this(Item.func_150898_a((Block)block), damage, weight);
    }

    public WeightedItem(Item item, int damage, int weight) {
        this.item = item;
        this.possibleDamageValues = new short[]{(short)damage};
        this.weight = weight;
    }

    public Item getItem() {
        return this.item;
    }

    public void combineDamageValues(WeightedItem otherItem) {
        this.possibleDamageValues = ArrayUtils.addAll((short[])this.possibleDamageValues, (short[])otherItem.possibleDamageValues);
    }

    public short[] getDamageValues() {
        return this.possibleDamageValues;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public Pair<Integer, Boolean> runBlacklistPattern(ItemPattern pattern) {
        if (pattern.matchesAnyDamage()) {
            return Pair.of((Object)this.possibleDamageValues.length, (Object)true);
        }
        TShortArrayList dmgToRemove = new TShortArrayList(this.possibleDamageValues.length);
        for (short damage : this.possibleDamageValues) {
            if (!pattern.matches(new ItemStack(this.item, 1, (int)damage))) continue;
            dmgToRemove.add(damage);
        }
        this.possibleDamageValues = ArrayUtils.removeElements((short[])this.possibleDamageValues, (short[])dmgToRemove.toArray());
        return Pair.of((Object)dmgToRemove.size(), (Object)(this.possibleDamageValues.length == 0 ? 1 : 0));
    }

    public boolean equals(Object o) {
        return o instanceof WeightedItem && ((WeightedItem)o).item == this.item;
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public String toString() {
        return "WeightedItemID: ITEM " + this.item.func_77658_a() + ", DMG " + Arrays.toString(this.possibleDamageValues) + ", WEIGHT " + this.weight;
    }
}

