/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.charms.handler;

import chylex.hee.entity.fx.FXType;
import chylex.hee.mechanics.charms.CharmPouchInfo;
import chylex.hee.mechanics.charms.CharmRecipe;
import chylex.hee.mechanics.charms.CharmType;
import chylex.hee.mechanics.charms.handler.CharmPouchHandler;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C06SetPlayerVelocity;
import chylex.hee.packets.client.C07AddPlayerVelocity;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.packets.client.C22EffectLine;
import chylex.hee.system.ReflectionPublicizer;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class CharmEvents {
    private final TObjectByteHashMap<UUID> playerRegen = new TObjectByteHashMap();
    private final TObjectFloatHashMap<UUID> playerSpeed = new TObjectFloatHashMap();
    private final TObjectFloatHashMap<UUID> playerStealDealtDamage = new TObjectFloatHashMap();
    private final TObjectByteHashMap<UUID> playerLastResortCooldown = new TObjectByteHashMap();
    private final AttributeModifier attrSpeed = new AttributeModifier(UUID.fromString("91AEAA56-376B-4498-935B-2F7F68070635"), "HeeCharmSpeed", 0.15, 2);

    public static float[] getProp(EntityPlayer player, String prop) {
        CharmPouchInfo info = CharmPouchHandler.getActivePouch(player);
        if (info == null) {
            return ArrayUtils.EMPTY_FLOAT_ARRAY;
        }
        TFloatArrayList values = new TFloatArrayList(5);
        for (Pair<CharmType, CharmRecipe> entry : info.charms) {
            float value = ((CharmRecipe)entry.getRight()).getProp(prop);
            if (value == -1.0f) continue;
            values.add(value);
        }
        return values.toArray();
    }

    public static float getPropSummed(EntityPlayer player, String prop) {
        float finalValue = 0.0f;
        for (float val : CharmEvents.getProp(player, prop)) {
            finalValue += val;
        }
        return finalValue;
    }

    public static float getPropPercentIncrease(EntityPlayer player, String prop, float baseValue) {
        float finalValue = 0.0f;
        for (float val : CharmEvents.getProp(player, prop)) {
            finalValue += val * baseValue - baseValue;
        }
        return finalValue;
    }

    public static float getPropPercentDecrease(EntityPlayer player, String prop, float baseValue) {
        float finalValue = 0.0f;
        for (float val : CharmEvents.getProp(player, prop)) {
            float tmp = baseValue * val;
            finalValue += tmp;
            baseValue -= tmp;
        }
        return finalValue;
    }

    CharmEvents() {
    }

    public void onDisabled() {
        if (!this.playerSpeed.isEmpty()) {
            for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                IAttributeInstance attribute;
                UUID id = player.func_146103_bH().getId();
                if (!this.playerSpeed.containsKey((Object)id) || (attribute = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d)) == null) continue;
                attribute.func_111124_b(this.attrSpeed);
            }
        }
        this.playerRegen.clear();
        this.playerSpeed.clear();
        this.playerStealDealtDamage.clear();
        this.playerLastResortCooldown.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.side != Side.SERVER) {
            return;
        }
        if (e.phase == TickEvent.Phase.START) {
            float regen;
            CharmPouchInfo info = CharmPouchHandler.getActivePouch(e.player);
            if (info != null && info.isIdle(e.player.field_70170_p)) {
                CharmPouchHandler.setActivePouch(e.player, null);
            }
            UUID playerID = e.player.func_146103_bH().getId();
            float spd = CharmEvents.getPropSummed(e.player, "spd");
            float prevSpd = this.playerSpeed.get((Object)playerID);
            if (MathUtil.floatEquals(prevSpd, this.playerSpeed.getNoEntryValue()) || !MathUtil.floatEquals(prevSpd, spd)) {
                IAttributeInstance attribute = e.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
                if (attribute != null) {
                    attribute.func_111124_b(this.attrSpeed);
                    attribute.func_111121_a(new AttributeModifier(this.attrSpeed.func_111167_a(), this.attrSpeed.func_111166_b() + spd, this.attrSpeed.func_111164_d() * (double)spd, this.attrSpeed.func_111169_c()));
                }
                this.playerSpeed.put((Object)playerID, spd);
            }
            if (e.player.func_70996_bM() && e.player.func_71024_bL().func_75116_a() >= 18 && (regen = CharmEvents.getPropPercentDecrease(e.player, "regenspd", 90.0f)) > 0.0f && (float)this.playerRegen.adjustOrPutValue((Object)playerID, (byte)1, (byte)0) >= 100.0f - regen) {
                e.player.func_70691_i(1.0f);
                this.playerRegen.put((Object)playerID, (byte)0);
            }
            if (this.playerLastResortCooldown.containsKey((Object)playerID) && this.playerLastResortCooldown.adjustOrPutValue((Object)playerID, (byte)-1, (byte)-100) <= -100) {
                this.playerLastResortCooldown.remove((Object)playerID);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent e) {
        boolean isTargetPlayer = e.entityLiving instanceof EntityPlayer;
        if (e.source.func_76346_g() == null) {
            if (isTargetPlayer) {
                EntityPlayer targetPlayer = (EntityPlayer)e.entity;
                if (e.source == DamageSource.field_76379_h) {
                    e.ammount -= CharmEvents.getPropSummed(targetPlayer, "fallblocks") * 0.5f;
                    if (e.ammount <= 0.001f) {
                        e.ammount = 0.0f;
                    }
                } else if (e.source.func_82725_o()) {
                    e.ammount -= CharmEvents.getPropPercentDecrease(targetPlayer, "reducemagicdmg", e.ammount);
                }
            }
        } else {
            float[] stealHealth;
            int a;
            EntityPlayer sourcePlayer;
            boolean isSourcePlayer = e.source.func_76346_g() instanceof EntityPlayer;
            if (isSourcePlayer) {
                float magic;
                float[] badEff;
                sourcePlayer = (EntityPlayer)e.source.func_76346_g();
                e.ammount += CharmEvents.getPropPercentIncrease(sourcePlayer, "dmg", e.ammount);
                float[] crit = CharmEvents.getProp(sourcePlayer, "critchance");
                if (crit.length > 0) {
                    float[] critDmg = CharmEvents.getProp(sourcePlayer, "critdmg");
                    float val = 0.0f;
                    for (a = 0; a < crit.length; ++a) {
                        if (!(e.entity.field_70170_p.field_73012_v.nextFloat() < crit[a])) continue;
                        val += critDmg[a] * e.ammount - e.ammount;
                    }
                    if (val > 0.0f) {
                        e.ammount += val;
                        PacketPipeline.sendToAllAround(e.entity, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.CHARM_CRITICAL, e.entity));
                    }
                }
                if ((badEff = CharmEvents.getProp(sourcePlayer, "badeffchance")).length > 0) {
                    float[] badEffLvl = CharmEvents.getProp(sourcePlayer, "badefflvl");
                    float[] badEffTime = CharmEvents.getProp(sourcePlayer, "badefftime");
                    boolean causedEffect = false;
                    ArrayList<Potion> potionEffects = CollectionUtil.newList(Potion.field_76437_t, Potion.field_76421_d, Potion.field_76440_q, Potion.field_76436_u, null);
                    for (int a2 = 0; a2 < badEff.length && !potionEffects.isEmpty(); ++a2) {
                        if (!(e.entity.field_70170_p.field_73012_v.nextFloat() < badEff[a2])) continue;
                        Potion type = (Potion)potionEffects.remove(e.entity.field_70170_p.field_73012_v.nextInt(potionEffects.size()));
                        if (type == null) {
                            e.entity.func_70015_d((int)badEffTime[a2]);
                        } else {
                            e.entityLiving.func_70690_d(new PotionEffect(type.field_76415_H, 20 * (int)badEffTime[a2], (int)badEffLvl[a2] - 1));
                        }
                        causedEffect = true;
                    }
                    if (causedEffect) {
                        PacketPipeline.sendToAllAround(e.entity, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.CHARM_WITCH, e.entity));
                    }
                }
                if ((magic = CharmEvents.getPropPercentDecrease(sourcePlayer, "dmgtomagic", e.ammount)) > 0.001f) {
                    e.ammount -= magic;
                    e.entity.field_70172_ad = 0;
                    e.entity.func_70097_a(DamageSource.field_76376_m, magic);
                }
            }
            if (isTargetPlayer) {
                float[] redirMobs;
                EntityPlayer targetPlayer = (EntityPlayer)e.entityLiving;
                e.ammount -= CharmEvents.getPropPercentDecrease(targetPlayer, "reducedmg", e.ammount);
                if (targetPlayer.func_70632_aY()) {
                    float repulseAmt;
                    e.ammount -= CharmEvents.getPropPercentDecrease(targetPlayer, "reducedmgblock", e.ammount);
                    boolean showBlockingEffect = false;
                    float[] reflectDmg = CharmEvents.getProp(targetPlayer, "blockreflectdmg");
                    if (reflectDmg.length > 0) {
                        float reflected = 0.0f;
                        for (a = 0; a < reflectDmg.length; ++a) {
                            reflected += e.ammount * reflectDmg[a];
                        }
                        e.source.func_76346_g().func_70097_a(DamageSource.func_76365_a((EntityPlayer)targetPlayer), reflected);
                        showBlockingEffect = true;
                    }
                    if ((repulseAmt = CharmEvents.getPropSummed(targetPlayer, "blockrepulsepower")) > 0.001f) {
                        float mp = 0.5f + 0.8f * repulseAmt;
                        Entity source = e.source.func_76346_g();
                        double[] vec = DragonUtil.getNormalizedVector(source.field_70165_t - targetPlayer.field_70165_t, source.field_70161_v - targetPlayer.field_70161_v);
                        vec[0] = vec[0] * (double)mp;
                        vec[1] = vec[1] * (double)mp;
                        if (source instanceof EntityPlayer) {
                            PacketPipeline.sendToPlayer((EntityPlayer)source, new C07AddPlayerVelocity(vec[0], 0.25, vec[1]));
                            source.field_70159_w += vec[0];
                            source.field_70181_x += 0.25;
                            source.field_70179_y += vec[1];
                        } else {
                            source.func_70024_g(vec[0], 0.25, vec[1]);
                        }
                        showBlockingEffect = true;
                    }
                    if (showBlockingEffect) {
                        PacketPipeline.sendToAllAround(e.entity, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.CHARM_BLOCK_EFFECT, e.entity));
                    }
                }
                if ((redirMobs = CharmEvents.getProp(targetPlayer, "redirmobs")).length > 0) {
                    float[] redirAmt = CharmEvents.getProp(targetPlayer, "rediramt");
                    List nearbyEntities = e.entity.field_70170_p.func_72872_a(EntityLivingBase.class, targetPlayer.field_70121_D.func_72314_b(6.0, 3.0, 6.0));
                    Iterator iter = nearbyEntities.iterator();
                    for (int a3 = 0; a3 < redirMobs.length; ++a3) {
                        block4: for (int mob = 0; mob < Math.round(redirMobs[a3]); ++mob) {
                            while (iter.hasNext()) {
                                EntityLivingBase entity = (EntityLivingBase)iter.next();
                                if (entity == targetPlayer || entity == e.source.func_76346_g()) continue;
                                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)targetPlayer), redirAmt[a3] * e.ammount);
                                PacketPipeline.sendToAllAround((Entity)targetPlayer, 64.0, (AbstractPacket)new C22EffectLine(FXType.Line.CHARM_DAMAGE_REDIRECTION, (Entity)entity, (Entity)targetPlayer));
                                e.ammount -= redirAmt[a3];
                                continue block4;
                            }
                        }
                    }
                }
            }
            if (isSourcePlayer && (stealHealth = CharmEvents.getProp(sourcePlayer = (EntityPlayer)e.source.func_76346_g(), "stealhealth")).length > 0) {
                float[] stealDealt = CharmEvents.getProp(sourcePlayer, "stealdealt");
                int randIndex = sourcePlayer.field_70170_p.field_73012_v.nextInt(stealHealth.length);
                if (this.playerStealDealtDamage.adjustOrPutValue((Object)sourcePlayer.func_146103_bH().getId(), e.ammount, e.ammount) >= stealDealt[randIndex]) {
                    sourcePlayer.func_70691_i(stealHealth[randIndex]);
                    this.playerStealDealtDamage.adjustValue((Object)sourcePlayer.func_146103_bH().getId(), -e.ammount);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeath(LivingDeathEvent e) {
        EntityPlayer sourcePlayer;
        float[] impactRad;
        EntityPlayer targetPlayer;
        float[] lastResortCooldown;
        if (e.entity instanceof EntityPlayer && (lastResortCooldown = CharmEvents.getProp(targetPlayer = (EntityPlayer)e.entity, "lastresortcooldown")).length > 0 && !this.playerLastResortCooldown.containsKey((Object)targetPlayer.func_146103_bH().getId())) {
            float[] lastResortDist = CharmEvents.getProp(targetPlayer, "lastresortblocks");
            int randIndex = targetPlayer.field_70170_p.field_73012_v.nextInt(lastResortCooldown.length);
            BlockPosM tmpPos = BlockPosM.tmp();
            block0: for (int attempt = 0; attempt < 128; ++attempt) {
                float ang = targetPlayer.field_70170_p.field_73012_v.nextFloat() * 2.0f * (float)Math.PI;
                tmpPos.x = MathUtil.floor(targetPlayer.field_70165_t + (double)(MathHelper.func_76134_b((float)ang) * lastResortDist[randIndex]));
                tmpPos.y = MathUtil.floor(targetPlayer.field_70163_u) - 2;
                tmpPos.z = MathUtil.floor(targetPlayer.field_70161_v + (double)(MathHelper.func_76126_a((float)ang) * lastResortDist[randIndex]));
                int origY = tmpPos.y;
                for (int yAttempt = 0; yAttempt <= 6; ++yAttempt) {
                    if (tmpPos.setY(origY - 1).isAir(targetPlayer.field_70170_p) || !tmpPos.setY(origY).isAir(targetPlayer.field_70170_p) || !tmpPos.setY(origY + 1).isAir(targetPlayer.field_70170_p)) continue;
                    PacketPipeline.sendToAllAround((Entity)targetPlayer, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.CHARM_LAST_RESORT, (Entity)targetPlayer));
                    targetPlayer.func_70634_a((double)tmpPos.x + 0.5, (double)tmpPos.y + 0.01, (double)tmpPos.z + 0.5);
                    attempt = 129;
                    continue block0;
                }
            }
            targetPlayer.func_70606_j(targetPlayer.field_70735_aL);
            targetPlayer.field_70179_y = 0.0;
            targetPlayer.field_70181_x = 0.0;
            targetPlayer.field_70159_w = 0.0;
            this.playerLastResortCooldown.put((Object)targetPlayer.func_146103_bH().getId(), (byte)(-100.0f + lastResortCooldown[randIndex] * 20.0f));
            PacketPipeline.sendToPlayer(targetPlayer, new C06SetPlayerVelocity(0.0, 0.0, 0.0));
            PacketPipeline.sendToAllAround((Entity)targetPlayer, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.CHARM_LAST_RESORT, (Entity)targetPlayer));
            e.setCanceled(true);
            return;
        }
        if (e.source.func_76346_g() instanceof EntityPlayer && (impactRad = CharmEvents.getProp(sourcePlayer = (EntityPlayer)e.source.func_76346_g(), "impactrad")).length > 0) {
            float[] impactAmt = CharmEvents.getProp(sourcePlayer, "impactamt");
            float lastDamage = e.entityLiving.field_110153_bc;
            for (int a = 0; a < impactRad.length; ++a) {
                List entities = e.entity.field_70170_p.func_72872_a(EntityLivingBase.class, e.entity.field_70121_D.func_72314_b((double)impactRad[a], (double)impactRad[a], (double)impactRad[a]));
                for (EntityLivingBase entity : entities) {
                    if (entity == sourcePlayer || entity == e.entity || !(entity.func_70032_d(e.entity) <= impactRad[a])) continue;
                    entity.func_70097_a(DamageSource.field_76377_j, impactAmt[a] * lastDamage);
                    PacketPipeline.sendToAllAround(e.entity, 64.0, (AbstractPacket)new C22EffectLine(FXType.Line.CHARM_SLAUGHTER_IMPACT, (Entity)entity, e.entity));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent e) {
        if (e.recentlyHit && e.source.func_76346_g() instanceof EntityPlayer && e.entityLiving instanceof EntityLiving && !e.entityLiving.func_70631_g_() && e.entity.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int xp = (Integer)ReflectionPublicizer.invoke(ReflectionPublicizer.entityLivingBaseGetExperiencePoints, e.entityLiving, (EntityPlayer)e.source.func_76346_g());
            xp = MathUtil.ceil(CharmEvents.getPropPercentIncrease((EntityPlayer)e.source.func_76346_g(), "exp", xp));
            DragonUtil.spawnXP(e.entity, xp);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        if (e.getPlayer() == null) {
            return;
        }
        e.setExpToDrop(e.getExpToDrop() + MathUtil.ceil(CharmEvents.getPropPercentIncrease(e.getPlayer(), "exp", e.getExpToDrop())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemDestroyed(PlayerDestroyItemEvent e) {
        float[] repair;
        if (e.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (e.original.func_77984_f() && e.original.func_77973_b().isRepairable() && (repair = CharmEvents.getProp(e.entityPlayer, "recdurabilitychance")).length > 0) {
            float[] repairAmt = CharmEvents.getProp(e.entityPlayer, "recdurabilityamt");
            float toRepair = 0.0f;
            for (int a = 0; a < repair.length; ++a) {
                if (!(e.entity.field_70170_p.field_73012_v.nextFloat() < repair[a])) continue;
                toRepair += repairAmt[a];
            }
            if (MathUtil.floatEquals(toRepair, 0.0f)) {
                return;
            }
            ItemStack newIS = e.original.func_77946_l();
            newIS.field_77994_a = 1;
            newIS.func_77964_b(newIS.func_77958_k() - MathUtil.floor((float)newIS.func_77958_k() * Math.min(1.0f, toRepair)));
            EntityItem newItem = new EntityItem(e.entity.field_70170_p, e.entity.field_70165_t, e.entity.field_70163_u + (double)e.entityPlayer.func_70047_e() - 0.3, e.entity.field_70161_v, newIS);
            newItem.field_145804_b = 40;
            float power = 0.3f;
            float yawRadians = (float)Math.toRadians(e.entityPlayer.field_70177_z);
            float randomAngle = e.entity.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            newItem.field_70159_w = -MathHelper.func_76126_a((float)yawRadians) * MathHelper.func_76134_b((float)yawRadians) * power;
            newItem.field_70179_y = MathHelper.func_76134_b((float)yawRadians) * MathHelper.func_76134_b((float)yawRadians) * power;
            newItem.field_70181_x = -MathHelper.func_76126_a((float)((float)Math.toRadians(e.entity.field_70125_A))) * power + 0.1f;
            power = 0.02f * e.entity.field_70170_p.field_73012_v.nextFloat();
            newItem.field_70159_w += (double)(MathHelper.func_76134_b((float)randomAngle) * power);
            newItem.field_70181_x += (double)((e.entity.field_70170_p.field_73012_v.nextFloat() - e.entity.field_70170_p.field_73012_v.nextFloat()) * 0.1f);
            newItem.field_70179_y += (double)(MathHelper.func_76126_a((float)randomAngle) * power);
            e.entity.field_70170_p.func_72838_d((Entity)newItem);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerFinishUsingItem(PlayerUseItemEvent.Finish e) {
        int hungerRecovered;
        float healthRecovered;
        if (e.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (e.item.func_77975_n() == EnumAction.eat && e.item.func_77973_b() instanceof ItemFood && (healthRecovered = CharmEvents.getPropPercentIncrease(e.entityPlayer, "healthperhunger", hungerRecovered = ((ItemFood)e.item.func_77973_b()).func_150905_g(e.item))) > 0.0f) {
            e.entityPlayer.func_70691_i(healthRecovered);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
        if (!e.entity.field_70170_p.field_72995_K) {
            e.newSpeed += CharmEvents.getPropPercentIncrease(e.entityPlayer, "breakspd", e.originalSpeed);
        }
    }
}

