/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.gui.element;

import com.pahimar.repackage.cofh.lib.gui.GuiBase;
import com.pahimar.repackage.cofh.lib.gui.element.ElementButtonManaged;
import java.util.HashMap;
import java.util.Map;

public abstract class ElementButtonOption
extends ElementButtonManaged {
    private final Map<Integer, String> _values = new HashMap<Integer, String>();
    private int _currentValue = 0;
    private int _maxValue;

    public ElementButtonOption(GuiBase containerScreen, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height, "");
    }

    public void setValue(int value, String label) {
        this._values.put(value, label);
        if (value > this._maxValue) {
            this._maxValue = value;
        }
    }

    @Override
    public void onClick() {
        int nextValue = this._currentValue;
        do {
            if (++nextValue <= this._maxValue) continue;
            nextValue = 0;
        } while (this._values.get(nextValue) == null);
        this.setSelectedIndex(nextValue);
    }

    @Override
    public void onRightClick() {
        int nextValue = this._currentValue;
        do {
            if (--nextValue >= 0) continue;
            nextValue = this._maxValue;
        } while (this._values.get(nextValue) == null);
        this.setSelectedIndex(nextValue);
    }

    public int getSelectedIndex() {
        return this._currentValue;
    }

    public void setSelectedIndex(int index) {
        this._currentValue = index;
        this.setText(this._values.get(this._currentValue));
        this.onValueChanged(this._currentValue, this._values.get(this._currentValue));
    }

    public String getValue() {
        return this._values.get(this._currentValue);
    }

    public abstract void onValueChanged(int var1, String var2);
}

