/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.pahimar.ee3.tileentity.TileEntityCalcinator;
import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;

public class MessageTileCalcinator
implements IMessage,
IMessageHandler<MessageTileCalcinator, IMessage> {
    public int x;
    public int y;
    public int z;
    public byte orientation;
    public byte state;
    public String customName;
    public UUID ownerUUID;
    public byte leftStackSize;
    public byte leftStackMeta;
    public byte rightStackSize;
    public byte rightStackMeta;

    public MessageTileCalcinator() {
    }

    public MessageTileCalcinator(TileEntityCalcinator tileEntityCalcinator) {
        this.x = tileEntityCalcinator.field_145851_c;
        this.y = tileEntityCalcinator.field_145848_d;
        this.z = tileEntityCalcinator.field_145849_e;
        this.orientation = (byte)tileEntityCalcinator.getOrientation().ordinal();
        this.state = (byte)tileEntityCalcinator.getState();
        this.customName = tileEntityCalcinator.getCustomName();
        this.ownerUUID = tileEntityCalcinator.getOwnerUUID();
        this.leftStackSize = tileEntityCalcinator.leftStackSize;
        this.leftStackMeta = tileEntityCalcinator.leftStackMeta;
        this.rightStackSize = tileEntityCalcinator.rightStackSize;
        this.rightStackMeta = tileEntityCalcinator.rightStackMeta;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        this.ownerUUID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
        this.leftStackSize = buf.readByte();
        this.leftStackMeta = buf.readByte();
        this.rightStackSize = buf.readByte();
        this.rightStackMeta = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        if (this.ownerUUID != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.ownerUUID.getMostSignificantBits());
            buf.writeLong(this.ownerUUID.getLeastSignificantBits());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeByte((int)this.leftStackSize);
        buf.writeByte((int)this.leftStackMeta);
        buf.writeByte((int)this.rightStackSize);
        buf.writeByte((int)this.rightStackMeta);
    }

    public IMessage onMessage(MessageTileCalcinator message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tileEntity instanceof TileEntityCalcinator) {
            ((TileEntityEE)tileEntity).setOrientation(message.orientation);
            ((TileEntityEE)tileEntity).setState(message.state);
            ((TileEntityEE)tileEntity).setCustomName(message.customName);
            ((TileEntityEE)tileEntity).setOwnerUUID(message.ownerUUID);
            ((TileEntityCalcinator)tileEntity).leftStackSize = message.leftStackSize;
            ((TileEntityCalcinator)tileEntity).leftStackMeta = message.leftStackMeta;
            ((TileEntityCalcinator)tileEntity).rightStackSize = message.rightStackSize;
            ((TileEntityCalcinator)tileEntity).rightStackMeta = message.rightStackMeta;
        }
        return null;
    }

    public String toString() {
        return String.format("MessageTileEntityCalcinator - x:%s, y:%s, z:%s, orientation:%s, state:%s, customName:%s, ownerUUID:%s, leftStackSize: %s, leftStackMeta: %s, rightStackSize: %s, rightStackMeta: %s", this.x, this.y, this.z, this.orientation, this.state, this.customName, this.ownerUUID, this.leftStackSize, this.leftStackMeta, this.rightStackSize, this.rightStackMeta);
    }
}

