/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.knowledge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.pahimar.ee3.api.event.AbilityEvent;
import com.pahimar.ee3.api.knowledge.AbilityRegistryProxy;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.LoaderHelper;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public class AbilityRegistry
implements JsonSerializer<AbilityRegistry>,
JsonDeserializer<AbilityRegistry> {
    private static final Gson jsonSerializer = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(AbilityRegistry.class, (Object)new AbilityRegistry()).create();
    private static AbilityRegistry abilityRegistry = null;
    private static File abilityDirectory;
    private boolean hasBeenModified = false;
    private Set<WrappedStack> notLearnableSet = new TreeSet<WrappedStack>();
    private Set<WrappedStack> notRecoverableSet = new TreeSet<WrappedStack>();

    private AbilityRegistry() {
    }

    public static AbilityRegistry getInstance() {
        if (abilityRegistry == null) {
            abilityRegistry = new AbilityRegistry();
            abilityRegistry.init();
        }
        return abilityRegistry;
    }

    private void init() {
        this.notLearnableSet = new TreeSet<WrappedStack>();
        this.notRecoverableSet = new TreeSet<WrappedStack>();
    }

    public Set<WrappedStack> getNotLearnableStacks() {
        return this.notLearnableSet;
    }

    public boolean isLearnable(Object object) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack wrappedObject = WrappedStack.wrap(object);
            if (object instanceof ItemStack && ((ItemStack)object).func_77951_h()) {
                return false;
            }
            return !this.notLearnableSet.contains(wrappedObject) && EnergyValueRegistry.getInstance().hasEnergyValue(wrappedObject);
        }
        return false;
    }

    public void setAsLearnable(Object object) {
        WrappedStack wrappedStack;
        if (WrappedStack.canBeWrapped(object) && (wrappedStack = WrappedStack.wrap(object)) != null && !MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.SetLearnableEvent(object)) && this.notLearnableSet.remove(wrappedStack)) {
            this.hasBeenModified = true;
            LogHelper.trace(String.format("AbilityRegistry[%s]: Mod with ID '%s' set object %s as LEARNABLE", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack));
        }
    }

    public void setAsNotLearnable(Object object) {
        WrappedStack wrappedStack;
        if (WrappedStack.canBeWrapped(object) && (wrappedStack = WrappedStack.wrap(object)) != null && !MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.SetNotLearnableEvent(object)) && this.notLearnableSet.add(wrappedStack)) {
            this.hasBeenModified = true;
            LogHelper.trace(String.format("AbilityRegistry[%s]: Mod with ID '%s' set object %s as NOT LEARNABLE", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack));
        }
    }

    public Set<WrappedStack> getNotRecoverableSet() {
        return this.notRecoverableSet;
    }

    public boolean isRecoverable(Object object) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack wrappedObject = WrappedStack.wrap(object);
            return !this.notRecoverableSet.contains(wrappedObject) && EnergyValueRegistry.getInstance().hasEnergyValue(wrappedObject);
        }
        return false;
    }

    public void setAsRecoverable(Object object) {
        WrappedStack wrappedStack;
        if (WrappedStack.canBeWrapped(object) && (wrappedStack = WrappedStack.wrap(object)) != null && !MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.SetRecoverableEvent(object)) && this.notRecoverableSet.remove(wrappedStack)) {
            this.hasBeenModified = true;
            LogHelper.trace(String.format("AbilityRegistry[%s]: Mod with ID '%s' set object %s as RECOVERABLE", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack));
        }
    }

    public void setAsNotRecoverable(Object object) {
        WrappedStack wrappedStack;
        if (WrappedStack.canBeWrapped(object) && (wrappedStack = WrappedStack.wrap(object)) != null && !MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.SetNotRecoverableEvent(object)) && this.notRecoverableSet.add(wrappedStack)) {
            this.hasBeenModified = true;
            LogHelper.trace(String.format("AbilityRegistry[%s]: Mod with ID '%s' set object %s as NOT RECOVERABLE", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), wrappedStack));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Not Learnables: ");
        for (WrappedStack wrappedStack : this.notLearnableSet) {
            stringBuilder.append(wrappedStack + " ");
        }
        stringBuilder.append(", Not Recoverables: ");
        for (WrappedStack wrappedStack : this.notRecoverableSet) {
            stringBuilder.append(wrappedStack + " ");
        }
        return stringBuilder.toString();
    }

    public AbilityRegistry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            WrappedStack wrappedStack;
            JsonArray jsonArray;
            JsonObject jsonObject = (JsonObject)json;
            TreeSet<WrappedStack> notLearnableStacks = new TreeSet<WrappedStack>();
            TreeSet<WrappedStack> notRecoverableStacks = new TreeSet<WrappedStack>();
            if (jsonObject.has("notLearnable") && jsonObject.get("notLearnable").isJsonArray()) {
                jsonArray = (JsonArray)jsonObject.get("notLearnable");
                for (JsonElement jsonElement : jsonArray) {
                    wrappedStack = (WrappedStack)WrappedStack.jsonSerializer.fromJson(jsonElement, WrappedStack.class);
                    if (wrappedStack == null) continue;
                    notLearnableStacks.add(wrappedStack);
                }
            }
            if (jsonObject.has("notRecoverable") && jsonObject.get("notRecoverable").isJsonArray()) {
                jsonArray = (JsonArray)jsonObject.get("notRecoverable");
                for (JsonElement jsonElement : jsonArray) {
                    wrappedStack = (WrappedStack)WrappedStack.jsonSerializer.fromJson(jsonElement, WrappedStack.class);
                    if (wrappedStack == null) continue;
                    notRecoverableStacks.add(wrappedStack);
                }
            }
            AbilityRegistry abilityRegistry1 = new AbilityRegistry();
            abilityRegistry1.notLearnableSet = notLearnableStacks;
            abilityRegistry1.notRecoverableSet = notRecoverableStacks;
            return abilityRegistry1;
        }
        return null;
    }

    public JsonElement serialize(AbilityRegistry abilityRegistry, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonAbilityRegistry = new JsonObject();
        JsonArray notLearnables = new JsonArray();
        for (WrappedStack wrappedStack : abilityRegistry.getNotLearnableStacks()) {
            notLearnables.add(WrappedStack.jsonSerializer.toJsonTree((Object)wrappedStack));
        }
        jsonAbilityRegistry.add("notLearnable", (JsonElement)notLearnables);
        JsonArray notRecoverables = new JsonArray();
        for (WrappedStack wrappedStack : abilityRegistry.getNotRecoverableSet()) {
            notRecoverables.add(WrappedStack.jsonSerializer.toJsonTree((Object)wrappedStack));
        }
        jsonAbilityRegistry.add("notRecoverable", (JsonElement)notRecoverables);
        return jsonAbilityRegistry;
    }

    public void save() {
        if (abilityDirectory != null) {
            abilityDirectory.mkdirs();
            this.writeToFile(new File(abilityDirectory, "abilities.json"));
        }
    }

    private void writeToFile(File file) {
        if (this.hasBeenModified) {
            try {
                JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(file));
                jsonWriter.setIndent("    ");
                jsonSerializer.toJson((Object)this, AbilityRegistry.class, jsonWriter);
                jsonWriter.close();
                this.hasBeenModified = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadAbilityRegistryFromFile(boolean loadFileOnly) {
        if (abilityDirectory != null) {
            File abilitiesFile = new File(abilityDirectory, "abilities.json");
            if (abilitiesFile.exists()) {
                this.readFromFile(abilitiesFile, loadFileOnly);
            }
        } else {
            abilityDirectory = new File(SerializationHelper.getDataDirectory(), "abilities");
            abilityDirectory.mkdirs();
        }
    }

    private void readFromFile(File file, boolean loadFileOnly) {
        try {
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(file));
            AbilityRegistry abilityRegistry1 = (AbilityRegistry)jsonSerializer.fromJson(jsonReader, AbilityRegistry.class);
            jsonReader.close();
            if (!loadFileOnly) {
                for (WrappedStack wrappedStack : abilityRegistry1.getNotLearnableStacks()) {
                    if (this.notLearnableSet.contains(wrappedStack)) continue;
                    this.notLearnableSet.add(wrappedStack);
                }
                for (WrappedStack wrappedStack : abilityRegistry1.getNotRecoverableSet()) {
                    if (this.notRecoverableSet.contains(wrappedStack)) continue;
                    this.notRecoverableSet.add(wrappedStack);
                }
            } else {
                this.notLearnableSet = abilityRegistry1.notLearnableSet;
                this.notRecoverableSet = abilityRegistry1.notRecoverableSet;
            }
            this.hasBeenModified = true;
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dumpAbilityRegistryToLog() {
        this.dumpAbilityRegistryToLog(AbilityRegistryProxy.Abilities.ALL);
    }

    public void dumpAbilityRegistryToLog(AbilityRegistryProxy.Abilities abilityType) {
        LogHelper.info(String.format("BEGIN DUMPING %s ABILITY OBJECTS", new Object[]{abilityType}));
        if (abilityType == AbilityRegistryProxy.Abilities.NOT_LEARNABLE) {
            if (this.notLearnableSet != null) {
                for (WrappedStack wrappedStack : this.notLearnableSet) {
                    LogHelper.info(String.format("- Object: %s", wrappedStack));
                }
            }
        } else if (abilityType == AbilityRegistryProxy.Abilities.NOT_RECOVERABLE) {
            if (this.notRecoverableSet != null) {
                for (WrappedStack wrappedStack : this.notRecoverableSet) {
                    LogHelper.info(String.format("- Object: %s", wrappedStack));
                }
            }
        } else if (abilityType == AbilityRegistryProxy.Abilities.ALL) {
            if (this.notLearnableSet != null) {
                LogHelper.info("NOT LEARNABLE OBJECTS");
                for (WrappedStack wrappedStack : this.notLearnableSet) {
                    LogHelper.info(String.format("- Object: %s", wrappedStack));
                }
            }
            if (this.notRecoverableSet != null) {
                LogHelper.info("NOT RECOVERABLE OBJECTS");
                for (WrappedStack wrappedStack : this.notRecoverableSet) {
                    LogHelper.info(String.format("- Object: %s", wrappedStack));
                }
            }
        }
        LogHelper.info(String.format("END DUMPING %s ABILITY OBJECTS", new Object[]{abilityType}));
    }
}

