/*
 * Decompiled with CFR 0.152.
 */
package ec3.integration.nei;

import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ec3.api.MagicalAssemblerRecipes;
import ec3.api.ShapedAssemblerRecipe;
import ec3.common.mod.EssentialCraftCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class MagicalAssemblerRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Magical Assembler";
    }

    public String getGuiTexture() {
        return "minecraft:textures/gui/container/crafting_table.png";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        Object obj;
        if (results.length > 0 && (obj = results[0]) instanceof ItemStack) {
            ItemStack stk = (ItemStack)obj;
            List<ShapedAssemblerRecipe> lst = MagicalAssemblerRecipes.findRecipes(stk);
            for (int i = 0; i < lst.size(); ++i) {
                ShapedAssemblerRecipe rec = lst.get(i);
                if (rec == null) continue;
                MagicalAssemblerCraftingPair pair = new MagicalAssemblerCraftingPair(rec);
                this.arecipes.add(pair);
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        Object obj;
        if (ingredients.length > 0 && (obj = ingredients[0]) instanceof ItemStack) {
            ItemStack stk = (ItemStack)obj;
            List<ShapedAssemblerRecipe> lst = MagicalAssemblerRecipes.findUsageRecipes(stk);
            for (int i = 0; i < lst.size(); ++i) {
                ShapedAssemblerRecipe rec = lst.get(i);
                if (rec == null) continue;
                MagicalAssemblerCraftingPair pair = new MagicalAssemblerCraftingPair(rec);
                this.arecipes.add(pair);
            }
        }
    }

    public void drawExtras(int recipe) {
        GL11.glPushMatrix();
        int posX = 0;
        int posY = 0;
        MagicalAssemblerCraftingPair rec = (MagicalAssemblerCraftingPair)((Object)this.arecipes.get(recipe));
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/mruStorage.png");
        MiscUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)18, (int)72, (int)1);
        int percentageScaled = MathUtils.pixelatedTextureSize((int)rec.mruRequired, (int)10000, (int)72);
        IIcon icon = (IIcon)EssentialCraftCore.proxy.getClientIcon("mru");
        MiscUtils.drawTexture((int)1, (int)(-1 + (74 - percentageScaled)), (IIcon)icon, (int)16, (int)(percentageScaled - 2), (float)0.0f);
        MiscUtils.bindTexture((String)"essentialcraft", (String)"textures/gui/slot_common.png");
        posX = 18;
        posY = 54;
        Minecraft.func_71410_x().field_71466_p.func_78261_a(rec.mruRequired + " MRU", posX + 2, posY + 7, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class MagicalAssemblerCraftingPair
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        PositionedStack[] ingred;
        PositionedStack result;
        public int mruRequired;

        public MagicalAssemblerCraftingPair(ShapedAssemblerRecipe recipe) {
            super((TemplateRecipeHandler)MagicalAssemblerRecipeHandler.this);
            this.ingred = new PositionedStack[9];
            Object[] craftMatrix = recipe.getInput();
            for (int t = 0; t < craftMatrix.length; ++t) {
                if (craftMatrix[t] == null) continue;
                this.ingred[t] = new PositionedStack(craftMatrix[t], 25 + t % 3 * 18, 6 + t / 3 * 18);
            }
            this.result = new PositionedStack((Object)recipe.func_77571_b(), 119, 23);
            this.ingredients = new ArrayList();
            this.setIngredients(craftMatrix);
            this.mruRequired = recipe.mruRequired;
        }

        public void setIngredients(Object[] items) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                PositionedStack ps = new PositionedStack(items[i], 25 + i % 3 * 18, 6 + i / 3 * 18);
                ps.setMaxSize(1);
                this.ingredients.add(ps);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

