/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.world.structure;

import DummyCore.Utils.Coord2D;
import cpw.mods.fml.common.eventhandler.Event;
import ec3.common.block.BlocksCore;
import ec3.common.world.ECExplosion;
import ec3.common.world.WorldGenDestroyedHouse;
import ec3.common.world.WorldGenMRUSpreader;
import ec3.common.world.WorldGenMRUTower;
import ec3.utils.cfg.Config;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;

public class StructureTownPieces {
    public static void registerVillagePieces() {
        MapGenStructureIO.func_143031_a(House1.class, (String)"TViBH");
        MapGenStructureIO.func_143031_a(Field1.class, (String)"TViDF");
        MapGenStructureIO.func_143031_a(Torch.class, (String)"TViL");
        MapGenStructureIO.func_143031_a(Hall.class, (String)"TViPH");
        MapGenStructureIO.func_143031_a(House4Garden.class, (String)"TViSH");
        MapGenStructureIO.func_143031_a(WoodHut.class, (String)"TViSmH");
        MapGenStructureIO.func_143031_a(Church.class, (String)"TViST");
        MapGenStructureIO.func_143031_a(House2.class, (String)"TViS");
        MapGenStructureIO.func_143031_a(Start.class, (String)"TViStart");
        MapGenStructureIO.func_143031_a(Path.class, (String)"TViSR");
        MapGenStructureIO.func_143031_a(House3.class, (String)"TViTRH");
        MapGenStructureIO.func_143031_a(Well.class, (String)"TViW");
    }

    public static List getStructureVillageWeightedPieceList(Random p_75084_0_, int p_75084_1_) {
        ArrayList<PieceWeight> arraylist = new ArrayList<PieceWeight>();
        arraylist.add(new PieceWeight(House4Garden.class, 4, 30));
        arraylist.add(new PieceWeight(Church.class, 20, 10));
        arraylist.add(new PieceWeight(House1.class, 20, 30));
        arraylist.add(new PieceWeight(WoodHut.class, 3, 100));
        arraylist.add(new PieceWeight(Hall.class, 15, 60));
        arraylist.add(new PieceWeight(Field1.class, 3, 20));
        arraylist.add(new PieceWeight(House2.class, 15, 30));
        arraylist.add(new PieceWeight(House3.class, 8, 30));
        Iterator iterator = arraylist.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return arraylist;
    }

    private static int func_75079_a(List p_75079_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight pieceweight : p_75079_0_) {
            if (pieceweight.villagePiecesLimit > 0 && pieceweight.villagePiecesSpawned < pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village func_75083_a(Start p_75083_0_, PieceWeight p_75083_1_, List p_75083_2_, Random p_75083_3_, int p_75083_4_, int p_75083_5_, int p_75083_6_, int p_75083_7_, int p_75083_8_) {
        Class oclass = p_75083_1_.villagePieceClass;
        Village object = null;
        if (oclass == House4Garden.class) {
            object = House4Garden.func_74912_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == Church.class) {
            object = Church.func_74919_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == House1.class) {
            object = House1.func_74898_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == WoodHut.class) {
            object = WoodHut.func_74908_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == Hall.class) {
            object = Hall.func_74906_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == Field1.class) {
            object = Field1.func_74900_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == Field2.class) {
            object = Field2.func_74902_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == House2.class) {
            object = House2.func_74915_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        } else if (oclass == House3.class) {
            object = House3.func_74921_a(p_75083_0_, p_75083_2_, p_75083_3_, p_75083_4_, p_75083_5_, p_75083_6_, p_75083_7_, p_75083_8_);
        }
        return object;
    }

    private static Village getNextVillageComponent(Start p_75081_0_, List p_75081_1_, Random p_75081_2_, int p_75081_3_, int p_75081_4_, int p_75081_5_, int p_75081_6_, int p_75081_7_) {
        int j1 = StructureTownPieces.func_75079_a(p_75081_0_.structureVillageWeightedPieceList);
        if (j1 <= 0) {
            return null;
        }
        int k1 = 0;
        block0: while (k1 < 5) {
            ++k1;
            int l1 = p_75081_2_.nextInt(j1);
            for (PieceWeight pieceweight : p_75081_0_.structureVillageWeightedPieceList) {
                if ((l1 -= pieceweight.villagePieceWeight) >= 0) continue;
                if (!pieceweight.canSpawnMoreVillagePiecesOfType(p_75081_7_) || pieceweight == p_75081_0_.structVillagePieceWeight && p_75081_0_.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village village = StructureTownPieces.func_75083_a(p_75081_0_, pieceweight, p_75081_1_, p_75081_2_, p_75081_3_, p_75081_4_, p_75081_5_, p_75081_6_, p_75081_7_);
                if (village == null) continue;
                ++pieceweight.villagePiecesSpawned;
                p_75081_0_.structVillagePieceWeight = pieceweight;
                if (!pieceweight.canSpawnMoreVillagePieces()) {
                    p_75081_0_.structureVillageWeightedPieceList.remove(pieceweight);
                }
                return village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.func_74904_a(p_75081_0_, p_75081_1_, p_75081_2_, p_75081_3_, p_75081_4_, p_75081_5_, p_75081_6_);
        if (structureboundingbox != null) {
            return new Torch(p_75081_0_, p_75081_7_, p_75081_2_, structureboundingbox, p_75081_6_);
        }
        return null;
    }

    private static StructureComponent getNextVillageStructureComponent(Start p_75077_0_, List p_75077_1_, Random p_75077_2_, int p_75077_3_, int p_75077_4_, int p_75077_5_, int p_75077_6_, int p_75077_7_) {
        if (p_75077_7_ > 500) {
            return null;
        }
        if (Math.abs(p_75077_3_ - p_75077_0_.func_74874_b().field_78897_a) <= 600 && Math.abs(p_75077_5_ - p_75077_0_.func_74874_b().field_78896_c) <= 600) {
            Village village = StructureTownPieces.getNextVillageComponent(p_75077_0_, p_75077_1_, p_75077_2_, p_75077_3_, p_75077_4_, p_75077_5_, p_75077_6_, p_75077_7_ + 1);
            if (village != null) {
                p_75077_1_.add(village);
                p_75077_0_.field_74932_i.add(village);
                return village;
            }
            return null;
        }
        return null;
    }

    private static StructureComponent getNextComponentVillagePath(Start p_75080_0_, List p_75080_1_, Random p_75080_2_, int p_75080_3_, int p_75080_4_, int p_75080_5_, int p_75080_6_, int p_75080_7_) {
        if (p_75080_7_ > 50 + p_75080_0_.terrainType) {
            return null;
        }
        if (Math.abs(p_75080_3_ - p_75080_0_.func_74874_b().field_78897_a) <= 600 && Math.abs(p_75080_5_ - p_75080_0_.func_74874_b().field_78896_c) <= 600) {
            StructureBoundingBox structureboundingbox = Path.func_74933_a(p_75080_0_, p_75080_1_, p_75080_2_, p_75080_3_, p_75080_4_, p_75080_5_, p_75080_6_);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                Path path = new Path(p_75080_0_, p_75080_7_, p_75080_2_, structureboundingbox, p_75080_6_);
                path.func_74874_b();
                path.func_74874_b();
                path.func_74874_b();
                path.func_74874_b();
                path.func_74874_b();
                path.func_74874_b();
                path.func_74874_b();
                path.func_74874_b();
                p_75080_1_.add(path);
                p_75080_0_.field_74930_j.add(path);
                return path;
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        public WoodHut() {
        }

        public WoodHut(Start p_i2101_1_, int p_i2101_2_, Random p_i2101_3_, StructureBoundingBox p_i2101_4_, int p_i2101_5_) {
            super(p_i2101_1_, p_i2101_2_);
            this.field_74885_f = p_i2101_5_;
            this.field_74887_e = p_i2101_4_;
            this.isTallHouse = p_i2101_3_.nextBoolean();
            this.tablePosition = p_i2101_3_.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("T", this.tablePosition);
            p_143012_1_.func_74757_a("C", this.isTallHouse);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.tablePosition = p_143011_1_.func_74762_e("T");
            this.isTallHouse = p_143011_1_.func_74767_n("C");
        }

        public static WoodHut func_74908_a(Start p_74908_0_, List p_74908_1_, Random p_74908_2_, int p_74908_3_, int p_74908_4_, int p_74908_5_, int p_74908_6_, int p_74908_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74908_3_, (int)p_74908_4_, (int)p_74908_5_, (int)0, (int)0, (int)0, (int)4, (int)6, (int)5, (int)p_74908_6_);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74908_1_, (StructureBoundingBox)structureboundingbox) == null ? new WoodHut(p_74908_0_, p_74908_7_, p_74908_2_, structureboundingbox, p_74908_6_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                ECExplosion explosion = new ECExplosion(p_74875_1_, null, p_74875_3_.field_78897_a, this.getAverageGroundLevel(p_74875_1_, p_74875_3_) - 3, p_74875_3_.field_78896_c, 15.0f);
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
            return true;
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start p_i2109_1_, int p_i2109_2_, Random p_i2109_3_, int p_i2109_4_, int p_i2109_5_) {
            super(p_i2109_1_, p_i2109_2_);
            this.field_74885_f = p_i2109_3_.nextInt(4);
            switch (this.field_74885_f) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(p_i2109_4_, 64, p_i2109_5_, p_i2109_4_ + 6 - 1, 78, p_i2109_5_ + 6 - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(p_i2109_4_, 64, p_i2109_5_, p_i2109_4_ + 6 - 1, 78, p_i2109_5_ + 6 - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, 1, this.func_74877_c());
            StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, 3, this.func_74877_c());
            StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
            StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 3, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                this.func_151549_a(p_74875_1_, p_74875_3_, 1, 0, 1, 4, 12, 4, Blocks.field_150347_e, (Block)Blocks.field_150358_i, false);
                this.func_151550_a(p_74875_1_, Blocks.field_150350_a, 0, 2, 12, 2, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150350_a, 0, 3, 12, 2, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150350_a, 0, 2, 12, 3, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150350_a, 0, 3, 12, 3, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 1, 13, 1, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 1, 14, 1, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 4, 13, 1, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 4, 14, 1, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 1, 13, 4, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 1, 14, 4, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 4, 13, 4, p_74875_3_);
                this.func_151550_a(p_74875_1_, Blocks.field_150422_aJ, 0, 4, 14, 4, p_74875_3_);
                this.func_151549_a(p_74875_1_, p_74875_3_, 1, 15, 1, 4, 15, 4, Blocks.field_150347_e, Blocks.field_150347_e, false);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                for (int i = 0; i <= 5; ++i) {
                    for (int j = 0; j <= 5; ++j) {
                        if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                        this.func_151550_a(p_74875_1_, Blocks.field_150351_n, 0, j, 11, i, p_74875_3_);
                        this.func_74871_b(p_74875_1_, j, 12, i, p_74875_3_);
                    }
                }
            }
            return true;
        }
    }

    public static abstract class Village
    extends StructureComponent {
        protected int field_143015_k = -1;
        private int villagersSpawned;
        private boolean field_143014_b;
        private Start startPiece;

        public Village() {
        }

        protected Village(Start p_i2107_1_, int p_i2107_2_) {
            super(p_i2107_2_);
            if (p_i2107_1_ != null) {
                this.field_143014_b = p_i2107_1_.inDesert;
                this.startPiece = p_i2107_1_;
            }
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            p_143012_1_.func_74768_a("HPos", this.field_143015_k);
            p_143012_1_.func_74768_a("VCount", this.villagersSpawned);
            p_143012_1_.func_74757_a("Desert", this.field_143014_b);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            this.field_143015_k = p_143011_1_.func_74762_e("HPos");
            this.villagersSpawned = p_143011_1_.func_74762_e("VCount");
            this.field_143014_b = p_143011_1_.func_74767_n("Desert");
        }

        protected StructureComponent getNextComponentNN(Start p_74891_1_, List p_74891_2_, Random p_74891_3_, int p_74891_4_, int p_74891_5_) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, 1, this.func_74877_c());
                }
                case 1: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
                case 2: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c + p_74891_5_, 1, this.func_74877_c());
                }
                case 3: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74891_1_, p_74891_2_, p_74891_3_, this.field_74887_e.field_78897_a + p_74891_5_, this.field_74887_e.field_78895_b + p_74891_4_, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentPP(Start p_74894_1_, List p_74894_2_, Random p_74894_3_, int p_74894_4_, int p_74894_5_) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, 3, this.func_74877_c());
                }
                case 1: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
                case 2: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78896_c + p_74894_5_, 3, this.func_74877_c());
                }
                case 3: {
                    return StructureTownPieces.getNextVillageStructureComponent(p_74894_1_, p_74894_2_, p_74894_3_, this.field_74887_e.field_78897_a + p_74894_5_, this.field_74887_e.field_78895_b + p_74894_4_, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
            }
            return null;
        }

        protected int getAverageGroundLevel(World p_74889_1_, StructureBoundingBox p_74889_2_) {
            int i = 0;
            int j = 0;
            if (this.field_74887_e == null) {
                this.field_74887_e = p_74889_2_;
            }
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    if (!p_74889_2_.func_78890_b(l, 64, k)) continue;
                    i += Math.max(p_74889_1_.func_72825_h(l, k), p_74889_1_.field_73011_w.func_76557_i());
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox p_74895_0_) {
            return p_74895_0_ != null && p_74895_0_.field_78895_b > 10;
        }

        protected void spawnVillagers(World p_74893_1_, StructureBoundingBox p_74893_2_, int p_74893_3_, int p_74893_4_, int p_74893_5_, int p_74893_6_) {
            if (this.villagersSpawned < p_74893_6_) {
                int l1;
                int k1;
                int j1;
                for (int i1 = this.villagersSpawned; i1 < p_74893_6_ && p_74893_2_.func_78890_b(j1 = this.func_74865_a(p_74893_3_ + i1, p_74893_5_), k1 = this.func_74862_a(p_74893_4_), l1 = this.func_74873_b(p_74893_3_ + i1, p_74893_5_)); ++i1) {
                    ++this.villagersSpawned;
                }
            }
        }

        protected int getVillagerType(int p_74888_1_) {
            return 0;
        }

        protected Block func_151558_b(Block p_151558_1_, int p_151558_2_) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, p_151558_1_, p_151558_2_);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.replacement;
            }
            if (this.field_143014_b) {
                if (p_151558_1_ == Blocks.field_150364_r || p_151558_1_ == Blocks.field_150363_s) {
                    return Blocks.field_150322_A;
                }
                if (p_151558_1_ == Blocks.field_150347_e) {
                    return Blocks.field_150322_A;
                }
                if (p_151558_1_ == Blocks.field_150344_f) {
                    return Blocks.field_150322_A;
                }
                if (p_151558_1_ == Blocks.field_150476_ad) {
                    return Blocks.field_150372_bz;
                }
                if (p_151558_1_ == Blocks.field_150446_ar) {
                    return Blocks.field_150372_bz;
                }
                if (p_151558_1_ == Blocks.field_150351_n) {
                    return Blocks.field_150322_A;
                }
            }
            return p_151558_1_;
        }

        protected int func_151557_c(Block p_151557_1_, int p_151557_2_) {
            BiomeEvent.GetVillageBlockMeta event = new BiomeEvent.GetVillageBlockMeta(this.startPiece == null ? null : this.startPiece.biome, p_151557_1_, p_151557_2_);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.replacement;
            }
            if (this.field_143014_b) {
                if (p_151557_1_ == Blocks.field_150364_r || p_151557_1_ == Blocks.field_150363_s) {
                    return 0;
                }
                if (p_151557_1_ == Blocks.field_150347_e) {
                    return 0;
                }
                if (p_151557_1_ == Blocks.field_150344_f) {
                    return 2;
                }
            }
            return p_151557_2_;
        }

        protected void func_151550_a(World p_151550_1_, Block p_151550_2_, int p_151550_3_, int p_151550_4_, int p_151550_5_, int p_151550_6_, StructureBoundingBox p_151550_7_) {
            Block block1 = this.func_151558_b(p_151550_2_, p_151550_3_);
            int i1 = this.func_151557_c(p_151550_2_, p_151550_3_);
            super.func_151550_a(p_151550_1_, block1, i1, p_151550_4_, p_151550_5_, p_151550_6_, p_151550_7_);
        }

        protected void func_151549_a(World p_151549_1_, StructureBoundingBox p_151549_2_, int p_151549_3_, int p_151549_4_, int p_151549_5_, int p_151549_6_, int p_151549_7_, int p_151549_8_, Block p_151549_9_, Block p_151549_10_, boolean p_151549_11_) {
            Block block2 = this.func_151558_b(p_151549_9_, 0);
            int k1 = this.func_151557_c(p_151549_9_, 0);
            Block block3 = this.func_151558_b(p_151549_10_, 0);
            int l1 = this.func_151557_c(p_151549_10_, 0);
            super.func_151556_a(p_151549_1_, p_151549_2_, p_151549_3_, p_151549_4_, p_151549_5_, p_151549_6_, p_151549_7_, p_151549_8_, block2, k1, block3, l1, p_151549_11_);
        }

        protected void func_151554_b(World p_151554_1_, Block p_151554_2_, int p_151554_3_, int p_151554_4_, int p_151554_5_, int p_151554_6_, StructureBoundingBox p_151554_7_) {
            Block block1 = this.func_151558_b(p_151554_2_, p_151554_3_);
            int i1 = this.func_151557_c(p_151554_2_, p_151554_3_);
            super.func_151554_b(p_151554_1_, block1, i1, p_151554_4_, p_151554_5_, p_151554_6_, p_151554_7_);
        }
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start p_i2097_1_, int p_i2097_2_, Random p_i2097_3_, StructureBoundingBox p_i2097_4_, int p_i2097_5_) {
            super(p_i2097_1_, p_i2097_2_);
            this.field_74885_f = p_i2097_5_;
            this.field_74887_e = p_i2097_4_;
        }

        public static StructureBoundingBox func_74904_a(Start p_74904_0_, List p_74904_1_, Random p_74904_2_, int p_74904_3_, int p_74904_4_, int p_74904_5_, int p_74904_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74904_3_, (int)p_74904_4_, (int)p_74904_5_, (int)0, (int)0, (int)0, (int)3, (int)4, (int)2, (int)p_74904_6_);
            return StructureComponent.func_74883_a((List)p_74904_1_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151550_a(p_74875_1_, BlocksCore.fence[0], 0, 1, 0, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, BlocksCore.fence[0], 0, 1, 1, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, BlocksCore.fence[0], 0, 1, 2, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, BlocksCore.voidStone, 15, 1, 3, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, BlocksCore.torch, 0, 0, 3, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, BlocksCore.torch, 0, 1, 3, 1, p_74875_3_);
                this.func_151550_a(p_74875_1_, BlocksCore.torch, 0, 2, 3, 0, p_74875_3_);
                this.func_151550_a(p_74875_1_, BlocksCore.torch, 0, 1, 3, -1, p_74875_3_);
            }
            return true;
        }
    }

    public static class Start
    extends Well {
        public WorldChunkManager worldChunkMngr;
        public boolean inDesert;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List structureVillageWeightedPieceList;
        public List field_74932_i = new ArrayList();
        public List field_74930_j = new ArrayList();
        public BiomeGenBase biome;

        public Start() {
        }

        public Start(WorldChunkManager p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List p_i2104_6_, int p_i2104_7_) {
            super(null, 0, p_i2104_3_, p_i2104_4_, p_i2104_5_);
            this.worldChunkMngr = p_i2104_1_;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            BiomeGenBase biomegenbase = p_i2104_1_.func_76935_a(p_i2104_4_, p_i2104_5_);
            this.inDesert = biomegenbase == BiomeGenBase.field_76769_d || biomegenbase == BiomeGenBase.field_76786_s;
            this.biome = biomegenbase;
        }

        public WorldChunkManager getWorldChunkManager() {
            return this.worldChunkMngr;
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start p_i2108_1_, int p_i2108_2_) {
            super(p_i2108_1_, p_i2108_2_);
        }
    }

    public static class PieceWeight {
        public Class villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int p_75085_1_) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int averageGroundLevel;

        public Path() {
        }

        public Path(Start p_i2105_1_, int p_i2105_2_, Random p_i2105_3_, StructureBoundingBox p_i2105_4_, int p_i2105_5_) {
            super(p_i2105_1_, p_i2105_2_);
            this.field_74885_f = p_i2105_5_;
            this.field_74887_e = p_i2105_4_;
            this.averageGroundLevel = Math.max(p_i2105_4_.func_78883_b(), p_i2105_4_.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("Length", this.averageGroundLevel);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.averageGroundLevel = p_143011_1_.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            StructureComponent structurecomponent1;
            int i;
            boolean flag = false;
            for (i = p_74861_3_.nextInt(18); i < this.averageGroundLevel - 8; i += 2 + p_74861_3_.nextInt(18)) {
                structurecomponent1 = this.getNextComponentNN((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, i);
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            for (i = p_74861_3_.nextInt(18); i < this.averageGroundLevel - 8; i += 2 + p_74861_3_.nextInt(18)) {
                structurecomponent1 = this.getNextComponentPP((Start)p_74861_1_, p_74861_2_, p_74861_3_, 0, i);
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            if (flag && p_74861_3_.nextInt(18) > 0) {
                switch (this.field_74885_f) {
                    case 0: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 1, this.func_74877_c());
                        break;
                    }
                    case 1: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 1, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                    }
                }
            }
            if (flag && p_74861_3_.nextInt(18) > 0) {
                switch (this.field_74885_f) {
                    case 0: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 3, this.func_74877_c());
                        break;
                    }
                    case 1: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 3, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        StructureTownPieces.getNextComponentVillagePath((Start)p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                    }
                }
            }
        }

        public static StructureBoundingBox func_74933_a(Start p_74933_0_, List p_74933_1_, Random p_74933_2_, int p_74933_3_, int p_74933_4_, int p_74933_5_, int p_74933_6_) {
            for (int i1 = 7 * MathHelper.func_76136_a((Random)p_74933_2_, (int)3, (int)5); i1 >= 7; i1 -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74933_3_, (int)p_74933_4_, (int)p_74933_5_, (int)0, (int)0, (int)0, (int)5, (int)5, (int)i1, (int)p_74933_6_);
                if (StructureComponent.func_74883_a((List)p_74933_1_, (StructureBoundingBox)structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            Block block = this.func_151558_b(BlocksCore.concrete, 0);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (!p_74875_3_.func_78890_b(i, 64, j)) continue;
                    int k = p_74875_1_.func_72825_h(i, j) - 1;
                    p_74875_1_.func_147465_d(i, k, j, block, 0, 2);
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean isRoofAccessible;

        public House4Garden() {
        }

        public House4Garden(Start p_i2100_1_, int p_i2100_2_, Random p_i2100_3_, StructureBoundingBox p_i2100_4_, int p_i2100_5_) {
            super(p_i2100_1_, p_i2100_2_);
            this.field_74885_f = p_i2100_5_;
            this.field_74887_e = p_i2100_4_;
            this.isRoofAccessible = p_i2100_3_.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.isRoofAccessible = p_143011_1_.func_74767_n("Terrace");
        }

        public static House4Garden func_74912_a(Start p_74912_0_, List p_74912_1_, Random p_74912_2_, int p_74912_3_, int p_74912_4_, int p_74912_5_, int p_74912_6_, int p_74912_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74912_3_, (int)p_74912_4_, (int)p_74912_5_, (int)0, (int)0, (int)0, (int)5, (int)6, (int)5, (int)p_74912_6_);
            return StructureComponent.func_74883_a((List)p_74912_1_, (StructureBoundingBox)structureboundingbox) != null ? null : new House4Garden(p_74912_0_, p_74912_7_, p_74912_2_, structureboundingbox, p_74912_6_);
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                new WorldGenDestroyedHouse(p_74875_2_.nextInt(3) + 1, 7).func_76484_a(p_74875_1_, p_74875_2_, p_74875_3_.field_78897_a, this.getAverageGroundLevel(p_74875_1_, p_74875_3_), p_74875_3_.field_78896_c);
            }
            return true;
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start p_i2106_1_, int p_i2106_2_, Random p_i2106_3_, StructureBoundingBox p_i2106_4_, int p_i2106_5_) {
            super(p_i2106_1_, p_i2106_2_);
            this.field_74885_f = p_i2106_5_;
            this.field_74887_e = p_i2106_4_;
        }

        public static House3 func_74921_a(Start p_74921_0_, List p_74921_1_, Random p_74921_2_, int p_74921_3_, int p_74921_4_, int p_74921_5_, int p_74921_6_, int p_74921_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74921_3_, (int)p_74921_4_, (int)p_74921_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)12, (int)p_74921_6_);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74921_1_, (StructureBoundingBox)structureboundingbox) == null ? new House3(p_74921_0_, p_74921_7_, p_74921_2_, structureboundingbox, p_74921_6_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                new WorldGenDestroyedHouse(p_74875_2_.nextInt(9) + 1, 3).func_76484_a(p_74875_1_, p_74875_2_, p_74875_3_.field_78897_a, this.getAverageGroundLevel(p_74875_1_, p_74875_3_), p_74875_3_.field_78896_c);
            }
            return true;
        }
    }

    public static class House2
    extends Village {
        public static final WeightedRandomChestContent[] villageBlacksmithChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 3, 3), new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151043_k, 0, 1, 3, 5), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151034_e, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151035_b, 0, 1, 1, 5), new WeightedRandomChestContent(Items.field_151040_l, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151030_Z, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151028_Y, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151165_aa, 0, 1, 1, 5), new WeightedRandomChestContent((Item)Items.field_151167_ab, 0, 1, 1, 5), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150343_Z), 0, 3, 7, 5), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150345_g), 0, 3, 7, 5), new WeightedRandomChestContent(Items.field_151141_av, 0, 1, 1, 3), new WeightedRandomChestContent(Items.field_151138_bX, 0, 1, 1, 1), new WeightedRandomChestContent(Items.field_151136_bY, 0, 1, 1, 1), new WeightedRandomChestContent(Items.field_151125_bZ, 0, 1, 1, 1)};
        private boolean hasMadeChest;

        public House2() {
        }

        public House2(Start p_i2103_1_, int p_i2103_2_, Random p_i2103_3_, StructureBoundingBox p_i2103_4_, int p_i2103_5_) {
            super(p_i2103_1_, p_i2103_2_);
            this.field_74885_f = p_i2103_5_;
            this.field_74887_e = p_i2103_4_;
        }

        public static House2 func_74915_a(Start p_74915_0_, List p_74915_1_, Random p_74915_2_, int p_74915_3_, int p_74915_4_, int p_74915_5_, int p_74915_6_, int p_74915_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74915_3_, (int)p_74915_4_, (int)p_74915_5_, (int)0, (int)0, (int)0, (int)10, (int)6, (int)7, (int)p_74915_6_);
            return House2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74915_1_, (StructureBoundingBox)structureboundingbox) == null ? new House2(p_74915_0_, p_74915_7_, p_74915_2_, structureboundingbox, p_74915_6_) : null;
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.hasMadeChest = p_143011_1_.func_74767_n("Chest");
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                new WorldGenDestroyedHouse(p_74875_2_.nextInt(5) + 1, 4).func_76484_a(p_74875_1_, p_74875_2_, p_74875_3_.field_78897_a, this.getAverageGroundLevel(p_74875_1_, p_74875_3_), p_74875_3_.field_78896_c);
            }
            return true;
        }

        @Override
        protected int getVillagerType(int p_74888_1_) {
            return 3;
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start p_i2094_1_, int p_i2094_2_, Random p_i2094_3_, StructureBoundingBox p_i2094_4_, int p_i2094_5_) {
            super(p_i2094_1_, p_i2094_2_);
            this.field_74885_f = p_i2094_5_;
            this.field_74887_e = p_i2094_4_;
        }

        public static House1 func_74898_a(Start p_74898_0_, List p_74898_1_, Random p_74898_2_, int p_74898_3_, int p_74898_4_, int p_74898_5_, int p_74898_6_, int p_74898_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74898_3_, (int)p_74898_4_, (int)p_74898_5_, (int)0, (int)0, (int)0, (int)9, (int)9, (int)6, (int)p_74898_6_);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74898_1_, (StructureBoundingBox)structureboundingbox) == null ? new House1(p_74898_0_, p_74898_7_, p_74898_2_, structureboundingbox, p_74898_6_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                new WorldGenDestroyedHouse(p_74875_2_.nextInt(2) + 1, 5).func_76484_a(p_74875_1_, p_74875_2_, p_74875_3_.field_78897_a, this.getAverageGroundLevel(p_74875_1_, p_74875_3_), p_74875_3_.field_78896_c);
            }
            return true;
        }

        @Override
        protected int getVillagerType(int p_74888_1_) {
            return 1;
        }
    }

    public static class Hall
    extends Village {
        public Hall() {
        }

        public Hall(Start p_i2099_1_, int p_i2099_2_, Random p_i2099_3_, StructureBoundingBox p_i2099_4_, int p_i2099_5_) {
            super(p_i2099_1_, p_i2099_2_);
            this.field_74885_f = p_i2099_5_;
            this.field_74887_e = p_i2099_4_;
        }

        public static Hall func_74906_a(Start p_74906_0_, List p_74906_1_, Random p_74906_2_, int p_74906_3_, int p_74906_4_, int p_74906_5_, int p_74906_6_, int p_74906_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74906_3_, (int)p_74906_4_, (int)p_74906_5_, (int)0, (int)0, (int)0, (int)9, (int)7, (int)11, (int)p_74906_6_);
            return Hall.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74906_1_, (StructureBoundingBox)structureboundingbox) == null ? new Hall(p_74906_0_, p_74906_7_, p_74906_2_, structureboundingbox, p_74906_6_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                new WorldGenMRUSpreader().func_76484_a(p_74875_1_, p_74875_2_, p_74875_3_.field_78897_a, this.getAverageGroundLevel(p_74875_1_, p_74875_3_), p_74875_3_.field_78896_c);
            }
            return true;
        }

        @Override
        protected int getVillagerType(int p_74888_1_) {
            return p_74888_1_ == 0 ? 4 : 0;
        }
    }

    public static class Field2
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;

        public Field2() {
        }

        public Field2(Start p_i2096_1_, int p_i2096_2_, Random p_i2096_3_, StructureBoundingBox p_i2096_4_, int p_i2096_5_) {
            super(p_i2096_1_, p_i2096_2_);
            this.field_74885_f = p_i2096_5_;
            this.field_74887_e = p_i2096_4_;
            this.cropTypeA = this.func_151560_a(p_i2096_3_);
            this.cropTypeB = this.func_151560_a(p_i2096_3_);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            p_143012_1_.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.cropTypeA = Block.func_149729_e((int)p_143011_1_.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)p_143011_1_.func_74762_e("CB"));
        }

        private Block func_151560_a(Random p_151560_1_) {
            switch (p_151560_1_.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field2 func_74902_a(Start p_74902_0_, List p_74902_1_, Random p_74902_2_, int p_74902_3_, int p_74902_4_, int p_74902_5_, int p_74902_6_, int p_74902_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74902_3_, (int)p_74902_4_, (int)p_74902_5_, (int)0, (int)0, (int)0, (int)7, (int)4, (int)9, (int)p_74902_6_);
            return Field2.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74902_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field2(p_74902_0_, p_74902_7_, p_74902_2_, structureboundingbox, p_74902_6_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;
        public static Coord2D currentStructureCoords;
        public static Coord2D prevStructureCoords;

        public Field1() {
        }

        public Field1(Start p_i2095_1_, int p_i2095_2_, Random p_i2095_3_, StructureBoundingBox p_i2095_4_, int p_i2095_5_) {
            super(p_i2095_1_, p_i2095_2_);
            this.field_74885_f = p_i2095_5_;
            this.field_74887_e = p_i2095_4_;
            this.cropTypeA = this.func_151559_a(p_i2095_3_);
            this.cropTypeB = this.func_151559_a(p_i2095_3_);
            this.cropTypeC = this.func_151559_a(p_i2095_3_);
            this.cropTypeD = this.func_151559_a(p_i2095_3_);
        }

        @Override
        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            super.func_143012_a(p_143012_1_);
            p_143012_1_.func_74768_a("CA", Block.field_149771_c.func_148757_b((Object)this.cropTypeA));
            p_143012_1_.func_74768_a("CB", Block.field_149771_c.func_148757_b((Object)this.cropTypeB));
            p_143012_1_.func_74768_a("CC", Block.field_149771_c.func_148757_b((Object)this.cropTypeC));
            p_143012_1_.func_74768_a("CD", Block.field_149771_c.func_148757_b((Object)this.cropTypeD));
        }

        @Override
        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            this.cropTypeA = Block.func_149729_e((int)p_143011_1_.func_74762_e("CA"));
            this.cropTypeB = Block.func_149729_e((int)p_143011_1_.func_74762_e("CB"));
            this.cropTypeC = Block.func_149729_e((int)p_143011_1_.func_74762_e("CC"));
            this.cropTypeD = Block.func_149729_e((int)p_143011_1_.func_74762_e("CD"));
        }

        private Block func_151559_a(Random p_151559_1_) {
            switch (p_151559_1_.nextInt(5)) {
                case 0: {
                    return Blocks.field_150459_bM;
                }
                case 1: {
                    return Blocks.field_150469_bN;
                }
            }
            return Blocks.field_150464_aj;
        }

        public static Field1 func_74900_a(Start p_74900_0_, List p_74900_1_, Random p_74900_2_, int p_74900_3_, int p_74900_4_, int p_74900_5_, int p_74900_6_, int p_74900_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74900_3_, (int)p_74900_4_, (int)p_74900_5_, (int)0, (int)0, (int)0, (int)13, (int)4, (int)9, (int)p_74900_6_);
            return Field1.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74900_1_, (StructureBoundingBox)structureboundingbox) == null ? new Field1(p_74900_0_, p_74900_7_, p_74900_2_, structureboundingbox, p_74900_6_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        public Church() {
        }

        public Church(Start p_i2102_1_, int p_i2102_2_, Random p_i2102_3_, StructureBoundingBox p_i2102_4_, int p_i2102_5_) {
            super(p_i2102_1_, p_i2102_2_);
            this.field_74885_f = p_i2102_5_;
            this.field_74887_e = p_i2102_4_;
        }

        public static Church func_74919_a(Start p_74919_0_, List p_74919_1_, Random p_74919_2_, int p_74919_3_, int p_74919_4_, int p_74919_5_, int p_74919_6_, int p_74919_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)p_74919_3_, (int)p_74919_4_, (int)p_74919_5_, (int)0, (int)0, (int)0, (int)5, (int)12, (int)9, (int)p_74919_6_);
            return Church.canVillageGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)p_74919_1_, (StructureBoundingBox)structureboundingbox) == null ? new Church(p_74919_0_, p_74919_7_, p_74919_2_, structureboundingbox, p_74919_6_) : null;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.getAverageGroundLevel(p_74875_1_, p_74875_3_);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            if (p_74875_1_.field_73011_w.field_76574_g == Config.dimensionID) {
                new WorldGenMRUTower().func_76484_a(p_74875_1_, p_74875_2_, p_74875_3_.field_78897_a, this.getAverageGroundLevel(p_74875_1_, p_74875_3_), p_74875_3_.field_78896_c);
            }
            return true;
        }

        @Override
        protected int getVillagerType(int p_74888_1_) {
            return 2;
        }
    }
}

