/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.world;

import DummyCore.Utils.MathUtils;
import ec3.common.block.BlocksCore;
import ec3.common.item.ItemBaublesWearable;
import ec3.common.item.ItemsCore;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenOldCatacombs
extends WorldGenerator {
    public static final WeightedRandomChestContent[] generatedItems = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemsCore.titanite, 0, 8, 32, 20), new WeightedRandomChestContent(ItemsCore.twinkling_titanite, 0, 2, 16, 10), new WeightedRandomChestContent(ItemsCore.genericItem, 5, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 6, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 7, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 8, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 9, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 10, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 11, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 20, 1, 12, 10), new WeightedRandomChestContent(ItemsCore.genericItem, 3, 1, 16, 15), new WeightedRandomChestContent(ItemsCore.genericItem, 35, 1, 1, 6), new WeightedRandomChestContent(ItemsCore.genericItem, 36, 1, 1, 6), new WeightedRandomChestContent(ItemsCore.genericItem, 37, 1, 1, 6), new WeightedRandomChestContent(ItemsCore.magicalSlag, 0, 1, 16, 70), new WeightedRandomChestContent(ItemsCore.ember, 0, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.ember, 1, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.ember, 2, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.ember, 3, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.ember, 4, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.ember, 5, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.ember, 7, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.ember, 6, 1, 16, 10), new WeightedRandomChestContent(ItemsCore.bauble, 0, 1, 1, 15)};
    public int maxSizeTries = 100;
    public int corridorMinLength = 32;
    public int corridorMaxLength = 64;
    public float lootRoomChance = 0.003f;
    public float destroyedRoomChance = 0.012f;
    public float greenRoomChance = 0.012f;
    public float weirdRoomChance = 0.003f;
    public float experimentRoomChance = 0.003f;
    public Block blockToGenerateOf;
    public boolean isFirstTry = true;
    public ForgeDirection cameFrom;

    public boolean func_76484_a(World w, Random r, int x, int y, int z) {
        block9: {
            block8: {
                int lengthGenned = r.nextInt(this.corridorMaxLength - this.corridorMinLength) + this.corridorMinLength;
                ForgeDirection[] genTry = new ForgeDirection[4];
                if (this.cameFrom != ForgeDirection.SOUTH) {
                    genTry[0] = ForgeDirection.NORTH;
                }
                if (this.cameFrom != ForgeDirection.NORTH) {
                    genTry[1] = ForgeDirection.SOUTH;
                }
                if (this.cameFrom != ForgeDirection.EAST) {
                    genTry[2] = ForgeDirection.WEST;
                }
                if (this.cameFrom != ForgeDirection.WEST) {
                    genTry[3] = ForgeDirection.EAST;
                }
                if (!this.isFirstTry || this.maxSizeTries <= 0) break block8;
                for (int i = 0; i < 4; ++i) {
                    if (genTry[i] == null || !this.generateCorridor(w, x, y, z, lengthGenned, genTry[i], r.nextFloat() <= this.greenRoomChance)) continue;
                    WorldGenOldCatacombs catacombs = new WorldGenOldCatacombs();
                    catacombs.maxSizeTries = this.maxSizeTries / 4;
                    catacombs.cameFrom = genTry[i];
                    catacombs.func_76484_a(w, r, x + ForgeDirection.values()[i + 2].offsetX * 10, y, z + ForgeDirection.values()[i + 2].offsetZ * 10);
                }
                break block9;
            }
            if (w.field_73012_v.nextFloat() < 0.03f) {
                this.generateWayUp(w, x, y, z);
            }
            if (w.func_147439_a(x, y, z) == Blocks.field_150486_ae) break block9;
            w.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 3);
            w.func_147449_b(x, y - 1, z, BlocksCore.voidStone);
            TileEntityChest chest = (TileEntityChest)w.func_147438_o(x, y, z);
            if (chest != null) {
                WeightedRandomChestContent.func_76293_a((Random)w.field_73012_v, (WeightedRandomChestContent[])generatedItems, (IInventory)chest, (int)(w.field_73012_v.nextInt(12) + 6));
                TileEntityChest inv = chest;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stk = inv.func_70301_a(i);
                    if (stk == null || !(stk.func_77973_b() instanceof ItemBaublesWearable)) continue;
                    ItemBaublesWearable.initRandomTag(stk, w.field_73012_v);
                }
            }
        }
        return false;
    }

    public boolean generateCorridor(World w, int x, int y, int z, int length, ForgeDirection direction, boolean green) {
        int generatedLength = 0;
        Block generateFrom = this.getBlockToGenFrom();
        boolean gen = true;
        while (gen) {
            Block b;
            int dz;
            int dy;
            int dx;
            if (w.field_73012_v.nextFloat() < this.destroyedRoomChance) {
                this.generateBrokenPath(w, x, y, z);
            }
            w.func_147439_a(x, y, z);
            if (direction.offsetX >= 0 && direction.offsetZ >= 0) {
                for (dx = x - direction.offsetZ * 2; dx <= x + direction.offsetZ * 2; ++dx) {
                    for (dy = -2; dy <= 2; ++dy) {
                        for (dz = z - direction.offsetX * 2; dz <= z + direction.offsetX * 2; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root) continue;
                            w.func_147465_d(dx, y + dy, dz, generateFrom, 0, 3);
                        }
                    }
                }
                for (dx = x - direction.offsetZ; dx <= x + direction.offsetZ; ++dx) {
                    for (dy = -1; dy <= 1; ++dy) {
                        for (dz = z - direction.offsetX; dz <= z + direction.offsetX; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root) continue;
                            w.func_147465_d(dx, y + dy, dz, Blocks.field_150350_a, 0, 3);
                        }
                    }
                }
            }
            if (direction.offsetX < 0 && direction.offsetZ >= 0) {
                for (dx = x - direction.offsetZ * 2; dx <= x + direction.offsetZ * 2; ++dx) {
                    for (dy = -2; dy <= 2; ++dy) {
                        for (dz = z + direction.offsetX * 2; dz <= z - direction.offsetX * 2; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root) continue;
                            w.func_147465_d(dx, y + dy, dz, generateFrom, 0, 3);
                        }
                    }
                }
                for (dx = x - direction.offsetZ; dx <= x + direction.offsetZ; ++dx) {
                    for (dy = -1; dy <= 1; ++dy) {
                        for (dz = z + direction.offsetX; dz <= z - direction.offsetX; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root) continue;
                            w.func_147465_d(dx, y + dy, dz, Blocks.field_150350_a, 0, 3);
                        }
                    }
                }
            }
            if (direction.offsetX >= 0 && direction.offsetZ < 0) {
                for (dx = x + direction.offsetZ * 2; dx <= x - direction.offsetZ * 2; ++dx) {
                    for (dy = -2; dy <= 2; ++dy) {
                        for (dz = z - direction.offsetX * 2; dz <= z + direction.offsetX * 2; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root || w.func_147437_c(dx, y + dy, dz)) continue;
                            w.func_147465_d(dx, y + dy, dz, generateFrom, 0, 3);
                        }
                    }
                }
                for (dx = x + direction.offsetZ; dx <= x - direction.offsetZ; ++dx) {
                    for (dy = -1; dy <= 1; ++dy) {
                        for (dz = z - direction.offsetX; dz <= z + direction.offsetX; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root) continue;
                            w.func_147465_d(dx, y + dy, dz, Blocks.field_150350_a, 0, 3);
                        }
                    }
                }
            }
            if (direction.offsetX < 0 && direction.offsetZ < 0) {
                for (dx = x + direction.offsetZ * 2; dx <= x - direction.offsetZ * 2; ++dx) {
                    for (dy = -2; dy <= 2; ++dy) {
                        for (dz = z + direction.offsetX * 2; dz <= z - direction.offsetX * 2; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root || w.func_147437_c(dx, y + dy, dz)) continue;
                            w.func_147465_d(dx, y + dy, dz, generateFrom, 0, 3);
                        }
                    }
                }
                for (dx = x + direction.offsetZ; dx <= x - direction.offsetZ; ++dx) {
                    for (dy = -1; dy <= 1; ++dy) {
                        for (dz = z + direction.offsetX; dz <= z - direction.offsetX; ++dz) {
                            b = w.func_147439_a(dx, y + dy, dz);
                            if (b == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root) continue;
                            w.func_147465_d(dx, y + dy, dz, Blocks.field_150350_a, 0, 3);
                        }
                    }
                }
            }
            if (++generatedLength >= length) {
                gen = false;
                return true;
            }
            x += direction.offsetX;
            z += direction.offsetZ;
            if (!(w.field_73012_v.nextFloat() < this.greenRoomChance)) continue;
            this.generateGrownPath(w, x, y, z);
        }
        return false;
    }

    public Block getBlockToGenFrom() {
        return this.blockToGenerateOf == null ? BlocksCore.fortifiedStone : this.blockToGenerateOf;
    }

    public void generateBrokenPath(World w, int x, int y, int z) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    int tryInt = j + 3;
                    if (w.field_73012_v.nextInt(tryInt) != 0) continue;
                    w.func_147449_b(x + i, y + j, z + k, BlocksCore.concrete);
                }
            }
        }
    }

    public void generateGrownPath(World w, int x, int y, int z) {
        Vec3 rootVec = Vec3.func_72443_a((double)(MathUtils.randomDouble((Random)w.field_73012_v) * 3.0), (double)-6.0, (double)(MathUtils.randomDouble((Random)w.field_73012_v) * 3.0));
        for (int vi = 0; vi <= 6; ++vi) {
            w.func_147449_b((int)((double)x + rootVec.field_72450_a / (double)vi), (int)((double)(y - 2) - rootVec.field_72448_b / (double)vi), (int)((double)z + rootVec.field_72449_c / (double)vi), BlocksCore.root);
        }
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                for (int k = -3; k <= 3; ++k) {
                    Block b;
                    if (w.field_73012_v.nextInt(3) != 0 || (b = w.func_147439_a(x + i, y + j, z + k)) == Blocks.field_150486_ae || b == Blocks.field_150350_a || b instanceof BlockBush || b instanceof BlockVine || b instanceof BlockLeaves || b == BlocksCore.concrete || b == BlocksCore.root) continue;
                    w.func_147449_b(x + i, y + j, z + k, (Block)Blocks.field_150362_t);
                }
            }
        }
    }

    public boolean generateWayUp(World w, int x, int y, int z) {
        int dz;
        int dy;
        int dx;
        int maxY = y;
        while (maxY < 256) {
            ++maxY;
            boolean isAir = true;
            for (int i = 0; i < 10; ++i) {
                if (w.func_147437_c(x, maxY + i, z)) continue;
                isAir = false;
            }
            if (!isAir) continue;
            break;
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dy = y + 3; dy < maxY; ++dy) {
                for (dz = -2; dz <= 2; ++dz) {
                    w.func_147465_d(x + dx, dy, z + dz, this.getBlockToGenFrom(), 0, 3);
                }
            }
        }
        for (dx = -1; dx <= 1; ++dx) {
            for (dy = y + 3; dy < maxY; ++dy) {
                for (dz = -1; dz <= 1; ++dz) {
                    w.func_147465_d(x + dx, dy, z + dz, Blocks.field_150350_a, 0, 3);
                }
            }
        }
        for (int dy2 = y - 3; dy2 < maxY; ++dy2) {
            w.func_147465_d(x - 1, dy2, z, Blocks.field_150468_ap, 5, 3);
        }
        return true;
    }
}

