/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.world;

import ec3.common.block.BlocksCore;
import ec3.utils.cfg.Config;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenElementalDrops
extends WorldGenerator {
    public Block minableReplacable;
    public boolean isEnd;
    public boolean isNether;
    public int generationSteps;
    public Random rnd;
    public int x;
    public int y;
    public int z;
    public World w;

    public WorldGenElementalDrops selectValidAABBGen() {
        int startX = this.x;
        int startZ = this.z;
        if (!this.w.func_72899_e(this.x + this.generationSteps / 2, this.y, this.z)) {
            while (!this.w.func_72899_e(this.x + this.generationSteps / 2 - 1, this.y, this.z) && this.x + this.generationSteps / 2 - 1 >= startX) {
                --this.x;
            }
        }
        if (!this.w.func_72899_e(this.x - this.generationSteps / 2, this.y, this.z)) {
            while (!this.w.func_72899_e(this.x - this.generationSteps / 2 + 1, this.y, this.z) && this.x - this.generationSteps / 2 + 1 <= startX) {
                ++this.x;
            }
        }
        if (!this.w.func_72899_e(this.x, this.y, this.z + this.generationSteps / 2)) {
            while (!this.w.func_72899_e(this.x, this.y, this.z + this.generationSteps / 2 - 1) && this.z + this.generationSteps / 2 - 1 >= startZ) {
                --this.z;
            }
        }
        if (!this.w.func_72899_e(this.x, this.y, this.z - this.generationSteps / 2)) {
            while (!this.w.func_72899_e(this.x, this.y, this.z - this.generationSteps / 2 + 1) && this.z - this.generationSteps / 2 + 1 <= startZ) {
                ++this.z;
            }
        }
        return this;
    }

    public WorldGenElementalDrops(World w, int type, int x, int y, int z) {
        this.rnd = w.field_73012_v;
        if (type == 0) {
            this.isEnd = false;
            this.isNether = false;
            this.minableReplacable = Blocks.field_150348_b;
        }
        if (type == 1) {
            this.isEnd = true;
            this.isNether = false;
            this.minableReplacable = Blocks.field_150377_bs;
        }
        if (type == -1) {
            this.isEnd = false;
            this.isNether = true;
            this.minableReplacable = Blocks.field_150424_aL;
        }
        this.generationSteps = 16;
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public boolean func_76484_a(World w, Random rnd, int x, int y, int z) {
        int meta = 0;
        if (this.isNether) {
            meta += 5;
        }
        if (this.isEnd) {
            meta += 10;
        }
        new WorldGenMinable(BlocksCore.oreDrops, meta, 16, this.minableReplacable).func_76484_a(w, rnd, x, y, z);
        new WorldGenMinable(BlocksCore.oreDrops, meta + 1, 8, this.minableReplacable).func_76484_a(w, rnd, x + rnd.nextInt(6) - rnd.nextInt(6), y + rnd.nextInt(6) - rnd.nextInt(6), z + rnd.nextInt(6) - rnd.nextInt(6));
        new WorldGenMinable(BlocksCore.oreDrops, meta + 2, 8, this.minableReplacable).func_76484_a(w, rnd, x + rnd.nextInt(6) - rnd.nextInt(6), y + rnd.nextInt(6) - rnd.nextInt(6), z + rnd.nextInt(6) - rnd.nextInt(6));
        new WorldGenMinable(BlocksCore.oreDrops, meta + 3, 8, this.minableReplacable).func_76484_a(w, rnd, x + rnd.nextInt(6) - rnd.nextInt(6), y + rnd.nextInt(6) - rnd.nextInt(6), z + rnd.nextInt(6) - rnd.nextInt(6));
        new WorldGenMinable(BlocksCore.oreDrops, meta + 4, 8, this.minableReplacable).func_76484_a(w, rnd, x + rnd.nextInt(6) - rnd.nextInt(6), y + rnd.nextInt(6) - rnd.nextInt(6), z + rnd.nextInt(6) - rnd.nextInt(6));
        return false;
    }

    public static void handleGeneration(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (int i = 0; i < Config.oreGenAttempts; ++i) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(world.func_72800_K());
            int z = chunkZ * 16 + random.nextInt(16);
            int type = world.field_73011_w.func_76569_d() ? 0 : (world.field_73011_w.field_76575_d ? -1 : 1);
            new WorldGenElementalDrops(world, type, x, y, z).selectValidAABBGen().func_76484_a(world, random, x, y, z);
        }
    }
}

