/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import ec3.common.inventory.InventoryCraftingFrame;
import ec3.common.item.ItemCraftingFrame;
import ec3.common.tile.TileMRUGeneric;
import ec3.common.tile.TileNewMIM;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class TileNewMIMCraftingManager
extends TileMRUGeneric {
    public TileNewMIM parent;
    int tickTime;
    public ArrayList<CraftingPattern> allCrafts = new ArrayList();

    @Override
    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        super.func_70299_a(par1, par2ItemStack);
        this.syncTick = 0;
    }

    public TileNewMIMCraftingManager() {
        this.setSlotsNum(54);
    }

    @Override
    public void func_145845_h() {
        if (this.syncTick == 60) {
            this.rebuildRecipes();
        }
        super.func_145845_h();
        if (this.tickTime == 0) {
            this.tickTime = 20;
            if (this.parent != null && !this.parent.isParent(this)) {
                this.parent = null;
            }
        } else {
            --this.tickTime;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    public void rebuildRecipes() {
        this.allCrafts.clear();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is == null) continue;
            CraftingPattern p = new CraftingPattern(is);
            if (p.isValidRecipe()) {
                this.allCrafts.add(p);
                continue;
            }
            Object var3_3 = null;
        }
    }

    public ItemStack findCraftingFrameByRecipe(ItemStack result) {
        for (int i = 0; i < this.allCrafts.size(); ++i) {
            if (!this.allCrafts.get(i).isResultTheSame(result)) continue;
            return this.allCrafts.get((int)i).crafter;
        }
        return null;
    }

    public ItemStack[] findCraftingComponentsByRecipe(ItemStack result) {
        for (int i = 0; i < this.allCrafts.size(); ++i) {
            if (!this.allCrafts.get(i).isResultTheSame(result)) continue;
            return this.allCrafts.get((int)i).input;
        }
        return null;
    }

    public ItemStack findResultByCraftingFrame(ItemStack frame) {
        for (int i = 0; i < this.allCrafts.size(); ++i) {
            if (!ItemStack.func_77989_b((ItemStack)this.allCrafts.get((int)i).crafter, (ItemStack)frame) || !ItemStack.func_77970_a((ItemStack)this.allCrafts.get((int)i).crafter, (ItemStack)frame)) continue;
            return this.allCrafts.get((int)i).result;
        }
        return null;
    }

    public int craft(ItemStack result, int times) {
        ItemStack stk = this.findCraftingFrameByRecipe(result);
        if (stk == null) {
            return 0;
        }
        int crafted = 0;
        for (int i = 0; i < times; ++i) {
            ItemStack[] required = this.findCraftingComponentsByRecipe(result);
            if (!this.canCraft(required, stk) || !this.craft(required, stk)) continue;
            this.parent.addItemStackToSystem(result.func_77946_l());
            ++crafted;
        }
        return crafted;
    }

    public boolean canCraft(ItemStack[] components, ItemStack crafter) {
        if (crafter == null) {
            return false;
        }
        if (!crafter.func_77942_o()) {
            return false;
        }
        for (int i = 0; i < components.length; ++i) {
            if (this.parent.retrieveItemStackFromSystem(components[i], !crafter.func_77978_p().func_74767_n("ignoreOreDict"), false) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean craft(ItemStack[] components, ItemStack crafter) {
        if (crafter == null) {
            return false;
        }
        if (!crafter.func_77942_o()) {
            return false;
        }
        for (int i = 0; i < components.length; ++i) {
            if (this.parent.retrieveItemStackFromSystem(components[i], !crafter.func_77978_p().func_74767_n("ignoreOreDict"), true) <= 0) continue;
            for (int j = 0; j < i; ++j) {
                this.parent.addItemStackToSystem(components[j]);
            }
            return false;
        }
        return true;
    }

    public ArrayList<CraftingPattern> getAllRecipes() {
        return this.allCrafts;
    }

    public ArrayList<ItemStack> getAllResults() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < this.allCrafts.size(); ++i) {
            CraftingPattern par = this.allCrafts.get(i);
            if (!par.isValidRecipe()) continue;
            ret.add(par.result);
        }
        return ret;
    }

    public boolean hasRecipe(ItemStack is) {
        if (is == null) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            InventoryCraftingFrame inv;
            if (this.func_70301_a(i) == null || !(this.func_70301_a(i).func_77973_b() instanceof ItemCraftingFrame) || (inv = new InventoryCraftingFrame(this.func_70301_a(i))) == null || inv.func_70301_a(9) == null || !inv.func_70301_a(9).func_77969_a(is) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)inv.func_70301_a(9))) continue;
            return true;
        }
        return false;
    }

    public static class CraftingPattern {
        public ItemStack result;
        public ItemStack[] input;
        public boolean isOreDict;
        public ItemStack crafter;

        public CraftingPattern(ItemStack par1, ItemStack par2, ItemStack[] par3, boolean par4) {
            this.result = par1;
            this.crafter = par2;
            this.input = par3;
            this.isOreDict = par4;
        }

        public CraftingPattern(ItemStack crafting) {
            InventoryCraftingFrame frame;
            if (crafting != null && crafting.func_77973_b() instanceof ItemCraftingFrame && crafting.func_77942_o() && (frame = new InventoryCraftingFrame(crafting)) != null && frame.func_70301_a(9) != null && (frame.func_70301_a(0) != null || frame.func_70301_a(1) != null || frame.func_70301_a(2) != null || frame.func_70301_a(3) != null || frame.func_70301_a(4) != null || frame.func_70301_a(5) != null || frame.func_70301_a(6) != null || frame.func_70301_a(7) != null || frame.func_70301_a(8) != null)) {
                ItemStack[] is = new ItemStack[]{frame.func_70301_a(0), frame.func_70301_a(1), frame.func_70301_a(2), frame.func_70301_a(3), frame.func_70301_a(4), frame.func_70301_a(5), frame.func_70301_a(6), frame.func_70301_a(7), frame.func_70301_a(8)};
                this.result = frame.func_70301_a(9);
                this.crafter = crafting;
                this.input = is;
                this.isOreDict = !crafting.func_77978_p().func_74767_n("ignoreOreDict");
            }
        }

        public boolean isValidRecipe() {
            return this.result != null && this.crafter != null && this.input.length == 9 && (this.input[0] != null || this.input[1] != null || this.input[2] != null || this.input[3] != null || this.input[4] != null || this.input[5] != null || this.input[6] != null || this.input[7] != null || this.input[8] != null);
        }

        public boolean isResultTheSame(ItemStack is) {
            if (is == null || !this.isValidRecipe()) {
                return false;
            }
            return is.func_77969_a(this.result) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)this.result);
        }
    }
}

