/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import ec3.common.item.ItemsCore;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import ec3.utils.common.EnumOreColoring;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class TileMagmaticSmelter
extends TileMRUGeneric
implements IFluidTank {
    public int progressLevel;
    public int smeltingLevel;
    public FluidTank lavaTank = new FluidTank(8000);
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 2;
    public static int mruUsage = 50;
    public static int smeltMRUUsage = 30;
    public static int oreSmeltingTime = 400;
    public static int alloySmeltingTime = 40;
    public static float quadriplingChance = 0.33f;

    public TileMagmaticSmelter() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(8);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            ItemStack ore;
            if (!this.field_145850_b.field_72995_K && FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.func_70301_a(1)) != null && this.func_70301_a(2) == null) {
                if (this.lavaTank.getFluid() == null) {
                    this.lavaTank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.func_70301_a(1)), true);
                    this.func_70299_a(2, TileMagmaticSmelter.consumeItem(this.func_70301_a(1)));
                    this.func_70298_a(1, 1);
                } else if (this.lavaTank.getFluidAmount() != 8000 && this.lavaTank.getFluid().isFluidEqual(FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.func_70301_a(1)))) {
                    this.lavaTank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.func_70301_a(1)), true);
                    this.func_70299_a(2, TileMagmaticSmelter.consumeItem(this.func_70301_a(1)));
                    this.func_70298_a(1, 1);
                }
            }
            if ((ore = this.func_70301_a(3)) != null && !this.field_145850_b.field_72995_K) {
                int[] oreIds = OreDictionary.getOreIDs((ItemStack)ore);
                String oreName = "Unknown";
                if (oreIds.length > 0) {
                    oreName = OreDictionary.getOreName((int)oreIds[0]);
                }
                int metadata = -1;
                for (int i = 0; i < EnumOreColoring.values().length; ++i) {
                    EnumOreColoring oreColor = EnumOreColoring.values()[i];
                    if (!oreName.equalsIgnoreCase(oreColor.oreName)) continue;
                    metadata = i;
                    break;
                }
                if (metadata != -1) {
                    int suggestedStackSize;
                    if (this.func_70301_a(4) == null) {
                        if (this.getMRU() - mruUsage >= 0 && this.lavaTank != null && this.lavaTank.getFluid() != null && this.lavaTank.getFluid().getFluid() == FluidRegistry.LAVA && this.lavaTank.getFluidAmount() > 0) {
                            this.setMRU(this.getMRU() - mruUsage);
                            if (this.field_145850_b.field_73012_v.nextFloat() <= 0.1f) {
                                this.drain(1, true);
                            }
                            this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                            ++this.progressLevel;
                            if (generatesCorruption) {
                                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                            }
                            if (this.progressLevel >= oreSmeltingTime) {
                                this.func_70298_a(3, 1);
                                suggestedStackSize = EnumOreColoring.values()[metadata].dropAmount;
                                if (this.field_145850_b.field_73012_v.nextFloat() <= 1.0f) {
                                    suggestedStackSize = EnumOreColoring.values()[metadata].dropAmount * 2;
                                }
                                this.func_70299_a(4, new ItemStack(ItemsCore.magicalAlloy, suggestedStackSize, metadata));
                                this.progressLevel = 0;
                                if (this.func_70301_a(7) == null) {
                                    this.func_70299_a(7, new ItemStack(ItemsCore.magicalSlag, 1, 0));
                                } else if (this.func_70301_a(7).func_77973_b() == ItemsCore.magicalSlag && this.func_70301_a((int)7).field_77994_a < 64) {
                                    ItemStack slagIS = this.func_70301_a(7);
                                    ++slagIS.field_77994_a;
                                    this.func_70299_a(7, slagIS);
                                }
                            }
                        }
                    } else if (this.func_70301_a(4).func_77973_b() == ItemsCore.magicalAlloy && this.func_70301_a(4).func_77960_j() == metadata && this.func_70301_a((int)4).field_77994_a + 2 <= this.func_70301_a(4).func_77976_d() && this.func_70301_a((int)4).field_77994_a + 4 <= this.func_70297_j_() && this.getMRU() - mruUsage >= 0 && this.lavaTank != null && this.lavaTank.getFluid() != null && this.lavaTank.getFluid().getFluid() == FluidRegistry.LAVA && this.lavaTank.getFluidAmount() > 0) {
                        this.setMRU(this.getMRU() - mruUsage);
                        if (this.field_145850_b.field_73012_v.nextFloat() <= 0.1f) {
                            this.drain(1, true);
                        }
                        this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                        ++this.progressLevel;
                        if (generatesCorruption) {
                            ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                        }
                        if (this.progressLevel >= oreSmeltingTime) {
                            this.func_70298_a(3, 1);
                            suggestedStackSize = EnumOreColoring.values()[metadata].dropAmount;
                            if (this.field_145850_b.field_73012_v.nextFloat() <= 1.0f) {
                                suggestedStackSize = EnumOreColoring.values()[metadata].dropAmount * 2;
                            }
                            ItemStack is = this.func_70301_a(4);
                            is.field_77994_a += suggestedStackSize;
                            if (is.field_77994_a > is.func_77976_d()) {
                                is.field_77994_a = is.func_77976_d();
                            }
                            this.func_70299_a(4, is);
                            this.progressLevel = 0;
                            if (this.func_70301_a(7) == null) {
                                this.func_70299_a(7, new ItemStack(ItemsCore.magicalSlag, 1, 0));
                            } else if (this.func_70301_a(7).func_77973_b() == ItemsCore.magicalSlag && this.func_70301_a((int)7).field_77994_a < 64) {
                                ItemStack slagIS = this.func_70301_a(7);
                                ++slagIS.field_77994_a;
                                this.func_70299_a(7, slagIS);
                            }
                        }
                    }
                } else {
                    this.progressLevel = 0;
                }
            } else {
                this.progressLevel = 0;
            }
            ItemStack alloy = this.func_70301_a(5);
            if (alloy != null && this.func_70301_a(5).func_77973_b() == ItemsCore.magicalAlloy) {
                EnumOreColoring oreColor = EnumOreColoring.values()[alloy.func_77960_j()];
                String oreName = oreColor.oreName;
                String outputName = oreColor.outputName;
                String suggestedIngotName = outputName.isEmpty() ? "ingot" + oreName.substring(3) : outputName;
                ArrayList oreLst = OreDictionary.getOres((String)suggestedIngotName);
                if (oreLst != null && !oreLst.isEmpty() && !this.field_145850_b.field_72995_K) {
                    ItemStack ingotStk = ((ItemStack)oreLst.get(0)).func_77946_l();
                    if (this.func_70301_a(6) == null) {
                        if (this.getMRU() - smeltMRUUsage >= 0) {
                            this.setMRU(this.getMRU() - smeltMRUUsage);
                            this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                            ++this.smeltingLevel;
                            if (generatesCorruption) {
                                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                            }
                            if (this.smeltingLevel >= alloySmeltingTime) {
                                int suggestedStackSize;
                                this.func_70298_a(5, 1);
                                ingotStk.field_77994_a = suggestedStackSize = 2;
                                this.func_70299_a(6, ingotStk);
                                this.smeltingLevel = 0;
                                if (this.func_70301_a(7) == null) {
                                    this.func_70299_a(7, new ItemStack(ItemsCore.magicalSlag, 1, 0));
                                } else if (this.func_70301_a(7).func_77973_b() == ItemsCore.magicalSlag && this.func_70301_a((int)7).field_77994_a < 64) {
                                    ItemStack slagIS = this.func_70301_a(7);
                                    ++slagIS.field_77994_a;
                                    this.func_70299_a(7, slagIS);
                                }
                            }
                        }
                    } else if (this.func_70301_a(6).func_77969_a(ingotStk) && this.func_70301_a((int)6).field_77994_a + 2 <= this.func_70301_a(6).func_77976_d() && this.func_70301_a((int)6).field_77994_a + 2 <= this.func_70297_j_() && this.getMRU() - smeltMRUUsage >= 0) {
                        this.setMRU(this.getMRU() - smeltMRUUsage);
                        this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, (double)this.field_145848_d, (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 2.2, 0.0, -0.1, 0.0);
                        ++this.smeltingLevel;
                        if (generatesCorruption) {
                            ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                        }
                        if (this.smeltingLevel >= alloySmeltingTime) {
                            this.func_70298_a(5, 1);
                            int suggestedStackSize = 2;
                            ItemStack is = this.func_70301_a(6);
                            is.field_77994_a += suggestedStackSize;
                            if (is.field_77994_a > is.func_77976_d()) {
                                is.field_77994_a = is.func_77976_d();
                            }
                            this.func_70299_a(6, is);
                            this.smeltingLevel = 0;
                            if (this.func_70301_a(7) == null) {
                                this.func_70299_a(7, new ItemStack(ItemsCore.magicalSlag, 1, 0));
                            } else if (this.func_70301_a(7).func_77973_b() == ItemsCore.magicalSlag && this.func_70301_a((int)7).field_77994_a < 64) {
                                ItemStack slagIS = this.func_70301_a(7);
                                ++slagIS.field_77994_a;
                                this.func_70299_a(7, slagIS);
                            }
                        }
                    }
                } else {
                    this.smeltingLevel = 0;
                }
            } else {
                this.smeltingLevel = 0;
            }
        }
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        super.func_145839_a(i);
        this.lavaTank.readFromNBT(i);
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        super.func_145841_b(i);
        this.lavaTank.writeToNBT(i);
    }

    public FluidStack getFluid() {
        return this.lavaTank.getFluid();
    }

    public int getFluidAmount() {
        return this.lavaTank.getFluidAmount();
    }

    public int getCapacity() {
        return this.lavaTank.getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.lavaTank.getInfo();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.lavaTank.fill(resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.lavaTank.drain(maxDrain, doDrain);
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagmaticSmelterySettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage when smelting Ores:50", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):3", "MRU Usage when smelting Alloys:30", "Ticks required to smelt an ore into Alloy:400", "Ticks required to smelt an alloy:40", "A chance to quadriple the outcome:0.33"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            smeltMRUUsage = Integer.parseInt(data[4].fieldValue);
            oreSmeltingTime = Integer.parseInt(data[5].fieldValue);
            alloySmeltingTime = Integer.parseInt(data[6].fieldValue);
            quadriplingChance = Float.parseFloat(data[7].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2, 4, 6, 7};
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        if (side == 0) {
            return this.getOutputSlots();
        }
        return new int[]{1, 3, 5};
    }
}

