/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class TileMagicalRepairer
extends TileMRUGeneric {
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = true;
    public static int genCorruption = 3;
    public static int mruUsage = 70;

    public TileMagicalRepairer() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(2);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.repare();
        }
        this.spawnParticles();
    }

    public void repare() {
        ItemStack repareItem = this.func_70301_a(1);
        if (this.canRepare(repareItem) && this.setMRU(this.getMRU() - mruUsage)) {
            repareItem.func_77964_b(repareItem.func_77960_j() - 1);
            if (generatesCorruption) {
                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
            }
        }
    }

    public boolean canRepare(ItemStack s) {
        return s != null && s.func_77960_j() != 0 && s.func_77973_b().isRepairable() && this.getMRU() >= mruUsage;
    }

    public void spawnParticles() {
        if (this.canRepare(this.func_70301_a(1)) && this.getMRU() > 0) {
            for (int o = 0; o < 10; ++o) {
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.25 + this.field_145850_b.field_73012_v.nextDouble() / 2.2, (double)this.field_145848_d + 0.25 + (double)((float)o / 20.0f), (double)this.field_145849_e + 0.25 + this.field_145850_b.field_73012_v.nextDouble() / 2.2, 1.0, 0.0, 1.0);
            }
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicalRepairerSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage:70", "Can this device actually generate corruption:true", "The amount of corruption generated each tick(do not set to 0!):3"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{1};
    }
}

