/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import ec3.common.item.ItemGenericEC3;
import ec3.common.item.ItemsCore;
import ec3.common.mod.EssentialCraftCore;
import ec3.common.tile.TileMRUGeneric;
import ec3.network.PacketNBT;
import ec3.utils.common.ECUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;

public class TileMagicalQuarry
extends TileMRUGeneric {
    public int progressLevel;
    public int miningX;
    public int miningY;
    public int miningZ;
    public boolean flag;
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = true;
    public static int genCorruption = 2;
    public static boolean ignoreLiquids = true;
    public static float mruUsage = 8.0f;
    public static float efficencyPerUpgrade = 0.5f;
    public static float blockHardnessModifier = 9.0f;
    public static final List<Object> voidList = new ArrayList<Object>();
    public static GameProfile quarryFakePlayerProfile;

    public TileMagicalQuarry() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(4);
    }

    public boolean canGenerateMRU() {
        return false;
    }

    @Override
    public void func_145845_h() {
        if (this.syncTick == 10) {
            this.syncTick = 0;
        }
        super.func_145845_h();
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.mine();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.collectItems();
        }
        ECUtils.manage(this, 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        super.func_145839_a(i);
        this.progressLevel = i.func_74762_e("progressLevel");
        this.miningX = i.func_74762_e("miningX");
        this.miningY = i.func_74762_e("miningY");
        this.miningZ = i.func_74762_e("miningZ");
        this.flag = i.func_74767_n("localFlag");
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        super.func_145841_b(i);
        i.func_74768_a("progressLevel", this.progressLevel);
        i.func_74768_a("miningX", this.miningX);
        i.func_74768_a("miningY", this.miningY);
        i.func_74768_a("miningZ", this.miningZ);
        i.func_74757_a("localFlag", this.flag);
    }

    public boolean hasInventoryUpgrade() {
        ItemStack s = ItemGenericEC3.getStkByName("inventoryUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSmeltingUpgrade() {
        ItemStack s = ItemGenericEC3.getStkByName("blazingUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVoidUpgrade() {
        ItemStack s = ItemGenericEC3.getStkByName("voidUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSilkyUpgrade() {
        if (this.hasSmeltingUpgrade()) {
            return false;
        }
        ItemStack s = ItemGenericEC3.getStkByName("silkyUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFortuneUpgrade() {
        if (this.hasSilkyUpgrade()) {
            return false;
        }
        ItemStack s = ItemGenericEC3.getStkByName("fortuneUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMiningUpgrade() {
        ItemStack s = ItemGenericEC3.getStkByName("diamondUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            return true;
        }
        return false;
    }

    public boolean hasInventory() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (t != null && t instanceof IInventory) {
            return this.hasSpaceInInv((IInventory)t);
        }
        return false;
    }

    public IInventory getInventory() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (t != null && t instanceof IInventory) {
            return (IInventory)t;
        }
        return null;
    }

    public boolean hasSpaceInInv(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null) continue;
            return true;
        }
        return false;
    }

    public float getEfficency() {
        float f = efficencyPerUpgrade + 1.0f;
        ItemStack s = ItemGenericEC3.getStkByName("efficencyUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            f += (float)this.func_70301_a((int)i).field_77994_a * efficencyPerUpgrade;
        }
        return this.hasSmeltingUpgrade() ? f / 2.0f : f;
    }

    public int getMiningRange() {
        int f = 5;
        ItemStack s = ItemGenericEC3.getStkByName("diamondUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            f += this.func_70301_a((int)i).field_77994_a;
        }
        return f;
    }

    public boolean canMineBlock(Block b) {
        if (b == Blocks.field_150357_h) {
            return false;
        }
        return b != Blocks.field_150343_Z || this.hasMiningUpgrade();
    }

    public boolean shouldInstaMine(Block b) {
        return b instanceof BlockLiquid && ignoreLiquids || b == null || b == Blocks.field_150350_a;
    }

    public int determineFortune() {
        int fortune = 0;
        ItemStack s = ItemGenericEC3.getStkByName("fortuneUpgrade");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || !this.func_70301_a(i).func_77969_a(s)) continue;
            fortune += this.func_70301_a((int)i).field_77994_a;
        }
        if (fortune <= 128) {
            fortune = 5;
        }
        if (fortune <= 64) {
            fortune = 4;
        }
        if (fortune <= 32) {
            fortune = 3;
        }
        if (fortune <= 16) {
            fortune = 2;
        }
        if (fortune <= 8) {
            fortune = 1;
        }
        return fortune;
    }

    public boolean mineBlock(Block b) {
        if (this.canMineBlock(b)) {
            NBTTagCompound currentMinedCoords = new NBTTagCompound();
            currentMinedCoords.func_74768_a("x", this.field_145851_c);
            currentMinedCoords.func_74768_a("y", this.field_145848_d);
            currentMinedCoords.func_74768_a("z", this.field_145849_e);
            currentMinedCoords.func_74768_a("mx", this.miningX);
            currentMinedCoords.func_74768_a("my", this.miningY);
            currentMinedCoords.func_74768_a("mz", this.miningZ);
            PacketNBT packet = new PacketNBT(currentMinedCoords).setID(4);
            EssentialCraftCore.network.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(16 + this.getMiningRange())));
            if (this.shouldInstaMine(b)) {
                this.field_145850_b.func_147465_d(this.miningX, this.miningY, this.miningZ, Blocks.field_150350_a, 0, 3);
                return true;
            }
            float required = b.func_149712_f(this.field_145850_b, this.miningX, this.miningY, this.miningZ) * blockHardnessModifier;
            if (this.setMRU((int)((float)this.getMRU() - mruUsage / 4.0f * this.getEfficency()))) {
                this.progressLevel = (int)((float)this.progressLevel + this.getEfficency());
            }
            if ((float)this.progressLevel >= required) {
                FakePlayer quarryFakePlayer = new FakePlayer((WorldServer)this.field_145850_b, quarryFakePlayerProfile);
                this.progressLevel = 0;
                if (this.hasMiningUpgrade()) {
                    quarryFakePlayer.func_70062_b(0, new ItemStack(ItemsCore.wind_elemental_pick));
                } else {
                    quarryFakePlayer.func_70062_b(0, new ItemStack(ItemsCore.weak_elemental_pick));
                }
                if (this.hasFortuneUpgrade()) {
                    quarryFakePlayer.func_71045_bC().func_77966_a(Enchantment.field_77346_s, this.determineFortune());
                }
                if (this.hasSilkyUpgrade()) {
                    quarryFakePlayer.func_71045_bC().func_77966_a(Enchantment.field_77348_q, 1);
                }
                b.func_149636_a(this.func_145831_w(), (EntityPlayer)quarryFakePlayer, this.miningX, this.miningY, this.miningZ, this.field_145850_b.func_72805_g(this.miningX, this.miningY, this.miningZ));
                this.field_145850_b.func_147465_d(this.miningX, this.miningY, this.miningZ, Blocks.field_150350_a, 0, 3);
                if (generatesCorruption) {
                    ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                }
                quarryFakePlayer = null;
            }
        }
        return false;
    }

    public boolean isMainColomnMined() {
        int r = this.field_145848_d - 2;
        while (--r >= 0) {
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, r, this.field_145849_e);
            if (b == null || b.func_149712_f(this.field_145850_b, this.field_145851_c, r, this.field_145849_e) == -1.0f || b == Blocks.field_150350_a || b instanceof BlockLiquid && ignoreLiquids || !this.canMineBlock(b) || !this.canMineBlock(b)) continue;
            return false;
        }
        return true;
    }

    public int genMiningColomnY(int current) {
        int r = this.field_145848_d - 2;
        while (--r >= 0) {
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, r, this.field_145849_e);
            if (b == null || b.func_149712_f(this.field_145850_b, this.field_145851_c, r, this.field_145849_e) == -1.0f || b == Blocks.field_150350_a || b instanceof BlockLiquid && ignoreLiquids || !this.canMineBlock(b) || !this.canMineBlock(b)) continue;
            return r;
        }
        return current;
    }

    public boolean isRowMined() {
        int rad = this.getMiningRange();
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c + x, this.miningY, this.field_145849_e + z);
                if (b == null || b.func_149712_f(this.field_145850_b, this.field_145851_c + x, this.miningY, this.field_145849_e + z) == -1.0f || b == Blocks.field_150350_a || b instanceof BlockLiquid && ignoreLiquids || !this.canMineBlock(b)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canWork() {
        return this.getEfficency() > 0.0f && (float)this.getMRU() > mruUsage;
    }

    public void mine() {
        block12: {
            if (this.canWork() && !this.field_145850_b.field_72995_K) {
                if (this.isMainColomnMined()) {
                    if (!this.flag) {
                        this.flag = true;
                        this.miningY = this.field_145848_d - 3;
                    }
                    this.flag = this.isMainColomnMined();
                    if (this.isRowMined()) {
                        --this.miningY;
                    } else {
                        int rad = this.getMiningRange();
                        for (int x = -rad; x <= rad; ++x) {
                            for (int z = -rad; z <= rad; ++z) {
                                if (!this.field_145850_b.func_72904_c(this.field_145851_c + x - 1, this.miningY - 1, this.field_145849_e + z - 1, this.field_145851_c + x + 1, this.miningY + 1, this.field_145849_e + z + 1) || !this.field_145850_b.func_72899_e(this.field_145851_c + x, this.miningY, this.field_145849_e + z) || this.field_145850_b.func_147439_a(this.field_145851_c + x, this.miningY, this.field_145849_e + z) == null || this.field_145850_b.func_147439_a(this.field_145851_c + x, this.miningY, this.field_145849_e + z).func_149712_f(this.field_145850_b, this.field_145851_c + x, this.miningY, this.field_145849_e + z) == -1.0f || this.field_145850_b.func_147439_a(this.field_145851_c + x, this.miningY, this.field_145849_e + z) == Blocks.field_150350_a || this.field_145850_b.func_147439_a(this.field_145851_c + x, this.miningY, this.field_145849_e + z) instanceof BlockLiquid) continue;
                                this.miningX = this.field_145851_c + x;
                                this.miningZ = this.field_145849_e + z;
                                this.mineBlock(this.field_145850_b.func_147439_a(this.field_145851_c + x, this.miningY, this.field_145849_e + z));
                                break block12;
                            }
                        }
                    }
                } else {
                    this.flag = false;
                    this.miningY = this.genMiningColomnY(this.miningY);
                    this.miningX = this.field_145851_c;
                    this.miningZ = this.field_145849_e;
                    if (this.field_145850_b.func_72904_c(this.miningX - 1, this.miningY - 1, this.miningZ - 1, this.miningX + 1, this.miningY + 1, this.miningZ + 1) && this.field_145850_b.func_72899_e(this.miningX, this.miningY, this.miningZ)) {
                        if (this.field_145850_b.func_147439_a(this.miningX, this.miningY, this.miningZ) != null && this.field_145850_b.func_147439_a(this.miningX, this.miningY, this.miningZ) != Blocks.field_150350_a && !(this.field_145850_b.func_147439_a(this.miningX, this.miningY, this.miningZ) instanceof BlockLiquid)) {
                            if (this.mineBlock(this.field_145850_b.func_147439_a(this.miningX, this.miningY, this.miningZ))) {
                                --this.miningY;
                            }
                        } else {
                            --this.miningY;
                        }
                    }
                }
            }
        }
    }

    public void collectItems() {
        List l = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.miningX, (double)this.miningY, (double)this.miningZ, (double)(this.miningX + 1), (double)(this.miningY + 1), (double)(this.miningZ + 1)).func_72314_b(4.0, 2.0, 4.0));
        if (!l.isEmpty()) {
            for (int i = 0; i < l.size(); ++i) {
                ItemStack forged;
                EntityItem item = (EntityItem)l.get(i);
                ItemStack s = item.func_92059_d();
                if (this.hasSmeltingUpgrade() && s != null && (forged = FurnaceRecipes.func_77602_a().func_151395_a(s)) != null) {
                    ItemStack copy = forged.func_77946_l();
                    copy.field_77994_a *= s.field_77994_a;
                    if (this.hasFortuneUpgrade()) {
                        int fortune = this.determineFortune();
                        for (int i1 = 0; i1 < s.field_77994_a; ++i1) {
                            copy.field_77994_a += this.field_145850_b.field_73012_v.nextInt(fortune);
                        }
                    }
                    s = copy;
                    item.func_92058_a(copy);
                }
                if (this.hasVoidUpgrade() && this.voidItemStack(s)) {
                    item.func_70080_a(0.0, 0.0, 0.0, 0.0f, 0.0f);
                    item.func_70106_y();
                    return;
                }
                item.func_70080_a(0.0, 0.0, 0.0, 0.0f, 0.0f);
                item.func_70106_y();
                if (this.hasInventoryUpgrade() && this.hasInventory()) {
                    this.insertItem(s);
                    continue;
                }
                this.splitItem(s);
            }
        }
    }

    public boolean voidItemStack(ItemStack s) {
        return s == null || voidList.contains(s.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)s.func_77973_b()) : s.func_77973_b());
    }

    public void splitItem(ItemStack s) {
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, s);
        item.func_70080_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)item);
    }

    public void insertItem(ItemStack s) {
        if (s == null) {
            return;
        }
        if (this.hasSpaceInInv(this.getInventory())) {
            ItemStack stk;
            int i;
            for (i = 0; i < this.getInventory().func_70302_i_(); ++i) {
                stk = this.getInventory().func_70301_a(i);
                if (stk == null || !stk.func_77969_a(s) || stk.field_77994_a + s.field_77994_a > stk.func_77976_d()) continue;
                stk.field_77994_a += s.field_77994_a;
                return;
            }
            for (i = 0; i < this.getInventory().func_70302_i_(); ++i) {
                stk = this.getInventory().func_70301_a(i);
                if (stk != null) continue;
                this.getInventory().func_70299_a(i, s);
                return;
            }
            this.splitItem(s);
        } else {
            this.splitItem(s);
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicalQuarrySettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage:8", "Should not mine liquids:true", "Can this device actually generate corruption:true", "The amount of corruption generated each tick(do not set to 0!):2", "Efficency added to the device per upgrade:0.5", "Block hardness modifier:9.0"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            ignoreLiquids = Boolean.parseBoolean(data[2].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[3].fieldValue);
            genCorruption = Integer.parseInt(data[4].fieldValue);
            efficencyPerUpgrade = Float.parseFloat(data[5].fieldValue);
            blockHardnessModifier = Float.parseFloat(data[6].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0};
    }

    static {
        voidList.add(Blocks.field_150347_e);
        voidList.add(Blocks.field_150346_d);
        voidList.add(Blocks.field_150349_c);
        voidList.add(Blocks.field_150348_b);
        voidList.add(Blocks.field_150354_m);
        voidList.add(Blocks.field_150322_A);
        voidList.add(Blocks.field_150329_H);
        voidList.add(Blocks.field_150328_O);
        voidList.add(Blocks.field_150327_N);
        voidList.add(Blocks.field_150338_P);
        voidList.add(Blocks.field_150337_Q);
        voidList.add(Blocks.field_150362_t);
        voidList.add(Blocks.field_150361_u);
        voidList.add(Items.field_151014_N);
        quarryFakePlayerProfile = new GameProfile(UUID.fromString("5cd89d0b-e9ba-0000-89f4-badbb05963dd"), "[EC3]Quarry");
    }
}

