/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import DummyCore.Utils.UnformedItemStack;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import ec3.common.tile.TileMRUGeneric;
import ec3.common.tile.TileMagicalAssembler;
import ec3.utils.common.ECUtils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class TileMagicalMirror
extends TileMRUGeneric {
    public Coord3D inventoryPos;
    public int transferTime = 0;
    public static float cfgMaxMRU = 5000.0f;
    public static float cfgMaxDistance = 8.0f;
    public ItemStack transferingStack;
    public boolean pulsing;

    public TileMagicalMirror() {
        this.setMaxMRU(cfgMaxMRU);
    }

    public void begin(TileMagicalAssembler assembler) {
        this.pulsing = true;
    }

    public void end(TileMagicalAssembler assembler) {
        this.pulsing = false;
        this.transferingStack = null;
        this.transferTime = 0;
    }

    public void pulse(TileMagicalAssembler assembler) {
        block10: {
            TileEntity tile;
            block11: {
                int[] slots;
                this.pulsing = true;
                if (!this.pulsing) break block10;
                tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                if (tile == null || !(tile instanceof ISidedInventory) || !(tile instanceof IInventory)) break block11;
                IInventory inv = (IInventory)tile;
                for (int i : slots = ((ISidedInventory)tile).func_94128_d(1)) {
                    int slot;
                    ItemStack is = inv.func_70301_a(i);
                    if (is == null || (slot = this.findAssemblerSlotForIS(assembler, is)) == -1) continue;
                    if (this.transferingStack == null) {
                        this.transferingStack = is;
                    }
                    if (this.transferTime < 60) {
                        ++this.transferTime;
                    }
                    double sX = (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double sY = (double)this.field_145848_d + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double sZ = (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double dX = (double)assembler.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double dY = (double)assembler.field_145848_d + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double dZ = (double)assembler.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    if (this.transferTime < 20) {
                        dX = sX;
                        dY = sY;
                        dZ = sZ;
                        sY -= 1.0;
                    }
                    if (this.field_145850_b.func_72820_D() % 5L == 0L) {
                        ECUtils.spawnItemFX(sX, sY, sZ, dX, dY, dZ);
                    }
                    if (this.transferTime < 60) break block10;
                    ItemStack set = is.func_77946_l();
                    set.field_77994_a = 1;
                    assembler.func_70299_a(slot, set);
                    inv.func_70298_a(i, 1);
                    this.transferingStack = null;
                    this.transferTime = 0;
                    break block10;
                }
                break block10;
            }
            if (tile == null || !(tile instanceof IInventory)) break block10;
            IInventory inv = (IInventory)tile;
            int slots = inv.func_70302_i_();
            for (int i = 0; i < slots; ++i) {
                int slot;
                ItemStack is = inv.func_70301_a(i);
                if (is == null || (slot = this.findAssemblerSlotForIS(assembler, is)) == -1) continue;
                if (this.transferingStack == null) {
                    this.transferingStack = is;
                }
                if (this.transferTime < 60) {
                    ++this.transferTime;
                }
                double sX = (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                double sY = (double)this.field_145848_d + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                double sZ = (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                double dX = (double)assembler.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                double dY = (double)assembler.field_145848_d + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                double dZ = (double)assembler.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                if (this.transferTime < 20) {
                    dX = sX;
                    dY = sY;
                    dZ = sZ;
                    sY -= 1.0;
                }
                if (this.field_145850_b.func_72820_D() % 5L == 0L) {
                    ECUtils.spawnItemFX(sX, sY, sZ, dX, dY, dZ);
                }
                if (this.transferTime < 60) break;
                ItemStack set = is.func_77946_l();
                set.field_77994_a = 1;
                assembler.func_70299_a(slot, set);
                inv.func_70298_a(i, 1);
                this.transferingStack = null;
                this.transferTime = 0;
                break;
            }
        }
    }

    public int findAssemblerSlotForIS(TileMagicalAssembler assembler, ItemStack is) {
        UnformedItemStack uis;
        int j;
        ItemStack stk;
        int i;
        ArrayList<UnformedItemStack> lst = new ArrayList<UnformedItemStack>();
        lst.addAll(assembler.requiredItemsToCraft);
        block0: for (i = 2; i < 17; ++i) {
            stk = assembler.func_70301_a(i);
            if (stk == null) continue;
            for (j = 0; j < lst.size(); ++j) {
                uis = (UnformedItemStack)lst.get(j);
                if (!uis.itemStackMatches(stk)) continue;
                lst.remove(j);
                continue block0;
            }
        }
        for (i = 2; i < 17; ++i) {
            stk = assembler.func_70301_a(i);
            if (stk != null) continue;
            for (j = 0; j < lst.size(); ++j) {
                uis = (UnformedItemStack)lst.get(j);
                if (uis == null || !uis.itemStackMatches(is)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void func_145845_h() {
        block21: {
            IInventory assembler;
            TileEntity tile;
            block22: {
                if (this.field_145850_b.field_72995_K && this.pulsing && this.transferTime < 60) {
                    ++this.transferTime;
                }
                super.func_145845_h();
                if (this.inventoryPos != null) {
                    tile = this.field_145850_b.func_147438_o(MathHelper.func_76128_c((double)this.inventoryPos.x), MathHelper.func_76128_c((double)this.inventoryPos.y), MathHelper.func_76128_c((double)this.inventoryPos.z));
                    if (tile != null && tile instanceof TileMagicalAssembler) {
                        TileMagicalAssembler a = (TileMagicalAssembler)tile;
                        if (!a.mirrorsTiles.contains(this)) {
                            a.mirrors.add(new Coord3D((float)this.field_145851_c, (float)this.field_145848_d, (float)this.field_145849_e));
                            a.mirrorsTiles.add(this);
                        }
                    } else {
                        this.pulsing = false;
                    }
                }
                if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) == null || !(tile instanceof TileMagicalAssembler) || this.inventoryPos == null) break block22;
                assembler = (TileMagicalAssembler)tile;
                TileEntity tile1 = this.field_145850_b.func_147438_o(MathHelper.func_76128_c((double)this.inventoryPos.x), MathHelper.func_76128_c((double)this.inventoryPos.y), MathHelper.func_76128_c((double)this.inventoryPos.z));
                if (tile1 == null || !(tile1 instanceof IInventory) || tile1 instanceof TileMagicalAssembler) break block21;
                IInventory inv = (IInventory)tile1;
                if (assembler.func_70301_a(17) == null) break block21;
                ItemStack is = assembler.func_70301_a(17);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack is1 = inv.func_70301_a(i);
                    if (is1 != null && (!is1.func_77969_a(is) || is1.field_77994_a + 1 >= is1.func_77976_d() + 1)) continue;
                    this.pulsing = true;
                    if (!this.field_145850_b.field_72995_K && this.transferTime <= 60) {
                        ++this.transferTime;
                    }
                    this.transferingStack = assembler.func_70301_a(17);
                    double sX = (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double sY = (double)this.field_145848_d + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double sZ = (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double dX = (double)this.inventoryPos.x + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double dY = (double)this.inventoryPos.y + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    double dZ = (double)this.inventoryPos.z + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                    if (this.transferTime < 20) {
                        dX = sX;
                        dY = sY;
                        dZ = sZ;
                        sY -= 1.0;
                    }
                    if (this.field_145850_b.func_72820_D() % 5L == 0L) {
                        ECUtils.spawnItemFX(sX, sY, sZ, dX, dY, dZ);
                    }
                    if (this.transferTime < 60) break block21;
                    ItemStack set = is.func_77946_l();
                    set.field_77994_a = 1;
                    if (inv.func_70301_a(i) == null) {
                        inv.func_70299_a(i, set);
                    } else {
                        ++inv.func_70301_a((int)i).field_77994_a;
                    }
                    assembler.func_70298_a(17, 1);
                    this.transferingStack = null;
                    this.transferTime = 0;
                    this.pulsing = false;
                    break block21;
                }
                break block21;
            }
            if (tile instanceof IInventory) {
                assembler = (IInventory)tile;
                if (this.inventoryPos != null) {
                    TileEntity tile1 = this.field_145850_b.func_147438_o(MathHelper.func_76128_c((double)this.inventoryPos.x), MathHelper.func_76128_c((double)this.inventoryPos.y), MathHelper.func_76128_c((double)this.inventoryPos.z));
                    if (assembler != null && tile1 != null && tile1 instanceof IInventory && !(tile1 instanceof TileMagicalAssembler)) {
                        IInventory inv = (IInventory)tile1;
                        for (int w = 0; w < assembler.func_70302_i_(); ++w) {
                            if (assembler.func_70301_a(w) == null) continue;
                            ItemStack is = assembler.func_70301_a(w);
                            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                                ItemStack is1 = inv.func_70301_a(i);
                                if (is1 != null && (!is1.func_77969_a(is) || is1.field_77994_a + 1 >= is1.func_77976_d() + 1)) continue;
                                this.pulsing = true;
                                this.syncTick = 0;
                                if (!this.field_145850_b.field_72995_K && this.transferTime <= 60) {
                                    ++this.transferTime;
                                }
                                this.transferingStack = assembler.func_70301_a(w);
                                double sX = (double)this.field_145851_c + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                                double sY = (double)this.field_145848_d + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                                double sZ = (double)this.field_145849_e + 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                                double dX = (double)this.inventoryPos.x + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                                double dY = (double)this.inventoryPos.y + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                                double dZ = (double)this.inventoryPos.z + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) / 6.0;
                                if (this.transferTime < 20) {
                                    dX = sX;
                                    dY = sY;
                                    dZ = sZ;
                                    sY -= 1.0;
                                }
                                if (this.field_145850_b.func_72820_D() % 5L == 0L) {
                                    ECUtils.spawnItemFX(sX, sY, sZ, dX, dY, dZ);
                                }
                                if (this.transferTime < 60) break block21;
                                ItemStack set = is.func_77946_l();
                                set.field_77994_a = 1;
                                if (inv.func_70301_a(i) == null) {
                                    inv.func_70299_a(i, set);
                                } else {
                                    ++inv.func_70301_a((int)i).field_77994_a;
                                }
                                assembler.func_70298_a(w, 1);
                                this.transferingStack = null;
                                this.transferTime = 0;
                                this.pulsing = false;
                                break block21;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        if (i.func_74764_b("coord")) {
            DummyData[] coordData = DataStorage.parseData((String)i.func_74779_i("coord"));
            this.inventoryPos = new Coord3D(Double.parseDouble(coordData[0].fieldValue), Double.parseDouble(coordData[1].fieldValue), Double.parseDouble(coordData[2].fieldValue));
        } else {
            this.inventoryPos = null;
        }
        this.transferTime = i.func_74762_e("transferTime");
        this.pulsing = i.func_74767_n("pulse");
        if (i.func_74764_b("transferingStack")) {
            NBTTagCompound tag = i.func_74775_l("transferingStack");
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                is.field_77994_a = 1;
            }
            this.transferingStack = is;
        } else {
            this.transferingStack = null;
        }
        super.func_145839_a(i);
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        if (this.inventoryPos != null) {
            i.func_74778_a("coord", this.inventoryPos.toString());
        }
        i.func_74768_a("transferTime", this.transferTime);
        i.func_74757_a("pulse", this.pulsing);
        if (this.transferingStack != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.transferingStack.func_77955_b(tag);
            i.func_74782_a("transferingStack", (NBTBase)tag);
        }
        super.func_145841_b(i);
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicalMirrorSettings", "tileentities", new String[]{"Max MRU:5000.0", "Max range of item transfering:8.0"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            cfgMaxDistance = Float.parseFloat(data[1].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }
}

