/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import ec3.common.inventory.InventoryMagicFilter;
import ec3.common.item.ItemFilter;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMagicalHopper
extends TileMRUGeneric {
    public static int itemHopRadius = 3;
    public static int itemDelay = 20;
    public int delay = 0;

    public ForgeDirection getRotation() {
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (metadata > 5) {
            metadata -= 6;
        }
        return ForgeDirection.getOrientation((int)metadata);
    }

    public TileMagicalHopper() {
        this.setSlotsNum(1);
        this.setMaxMRU(0.0f);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.delay <= 0 && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            ForgeDirection r = this.getRotation();
            AxisAlignedBB teleportBB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c + r.offsetX), (double)(this.field_145848_d + r.offsetY), (double)(this.field_145849_e + r.offsetZ), (double)(this.field_145851_c + 1 + r.offsetX), (double)(this.field_145848_d + 1 + r.offsetY), (double)(this.field_145849_e + 1 + r.offsetZ));
            this.delay = itemDelay;
            List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)itemHopRadius, (double)itemHopRadius, (double)itemHopRadius));
            List doNotTouch = this.field_145850_b.func_72872_a(EntityItem.class, teleportBB);
            for (int i = 0; i < items.size(); ++i) {
                EntityItem item = (EntityItem)items.get(i);
                if (!this.canTeleport(item) || doNotTouch.contains(item)) continue;
                item.func_70080_a((double)this.field_145851_c + 0.5 + (double)r.offsetX, (double)this.field_145848_d + 0.5 + (double)r.offsetY, (double)this.field_145849_e + 0.5 + (double)r.offsetZ, 0.0f, 0.0f);
            }
        } else {
            --this.delay;
        }
    }

    public boolean canTeleport(EntityItem item) {
        if (item.func_92059_d() == null) {
            return false;
        }
        if (this.func_70301_a(0) == null || !(this.func_70301_a(0).func_77973_b() instanceof ItemFilter)) {
            return true;
        }
        return ECUtils.canFilterAcceptItem(new InventoryMagicFilter(this.func_70301_a(0)), item.func_92059_d(), this.func_70301_a(0));
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicalHopperSettings", "tileentities", new String[]{"Radius in which the hopper will detect items(int):3", "Delay between item detection in ticks:20"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            itemHopRadius = Integer.parseInt(data[0].fieldValue);
            itemDelay = Integer.parseInt(data[1].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0};
    }
}

