/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.config.Configuration;

public class TileMagicalEnchanter
extends TileMRUGeneric {
    List<EnchantmentData> enchants;
    public int progressLevel = -1;
    public int field_145926_a;
    public float field_145933_i;
    public float field_145931_j;
    public float field_145932_k;
    public float field_145929_l;
    public float field_145930_m;
    public float field_145927_n;
    public float field_145928_o;
    public float field_145925_p;
    public float field_145924_q;
    private static Random field_145923_r = new Random();
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 2;
    public static int mruUsage = 100;
    public static int maxEnchantmentLevel = 60;

    public TileMagicalEnchanter() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(3);
    }

    @Override
    public void func_145845_h() {
        float f2;
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.tryEnchant();
        }
        this.field_145927_n = this.field_145930_m;
        this.field_145925_p = this.field_145928_o;
        EntityPlayer entityplayer = this.field_145850_b.func_72977_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), 3.0);
        if (entityplayer != null) {
            double d0 = entityplayer.field_70165_t - (double)((float)this.field_145851_c + 0.5f);
            double d1 = entityplayer.field_70161_v - (double)((float)this.field_145849_e + 0.5f);
            this.field_145924_q = (float)Math.atan2(d1, d0);
            this.field_145930_m += 0.1f;
            if (this.field_145930_m < 0.5f || field_145923_r.nextInt(40) == 0) {
                float f1 = this.field_145932_k;
                do {
                    this.field_145932_k += (float)(field_145923_r.nextInt(4) - field_145923_r.nextInt(4));
                } while (f1 == this.field_145932_k);
            }
        } else {
            this.field_145924_q += 0.02f;
            this.field_145930_m -= 0.1f;
        }
        while (this.field_145928_o >= (float)Math.PI) {
            this.field_145928_o -= (float)Math.PI * 2;
        }
        while (this.field_145928_o < (float)(-Math.PI)) {
            this.field_145928_o += (float)Math.PI * 2;
        }
        while (this.field_145924_q >= (float)Math.PI) {
            this.field_145924_q -= (float)Math.PI * 2;
        }
        while (this.field_145924_q < (float)(-Math.PI)) {
            this.field_145924_q += (float)Math.PI * 2;
        }
        for (f2 = this.field_145924_q - this.field_145928_o; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.field_145928_o += f2 * 0.4f;
        if (this.field_145930_m < 0.0f) {
            this.field_145930_m = 0.0f;
        }
        if (this.field_145930_m > 1.0f) {
            this.field_145930_m = 1.0f;
        }
        ++this.field_145926_a;
        this.field_145931_j = this.field_145933_i;
        float f = (this.field_145932_k - this.field_145933_i) * 0.4f;
        float f3 = 0.2f;
        if (f < -f3) {
            f = -f3;
        }
        if (f > f3) {
            f = f3;
        }
        this.field_145929_l += (f - this.field_145929_l) * 0.9f;
        this.field_145933_i += this.field_145929_l;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        this.progressLevel = i.func_74762_e("work");
        super.func_145839_a(i);
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        i.func_74768_a("work", this.progressLevel);
        super.func_145841_b(i);
    }

    public void tryEnchant() {
        if (this.canItemBeEnchanted() && !this.field_145850_b.field_72995_K && this.setMRU(this.getMRU() - mruUsage)) {
            if (generatesCorruption) {
                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
            }
            ++this.progressLevel;
            if (this.progressLevel >= this.getRequiredTimeToAct()) {
                this.enchant();
                this.progressLevel = -1;
            }
        }
        if (!this.canItemBeEnchanted()) {
            this.progressLevel = -1;
            this.enchants = null;
        }
    }

    public void enchant() {
        List<EnchantmentData> enchants = this.getEnchantmentsForStack(this.func_70301_a(1));
        ItemStack enchanted = this.func_70301_a(1).func_77946_l();
        enchanted.field_77994_a = 1;
        this.func_70298_a(1, 1);
        for (int m = 0; m < enchants.size(); ++m) {
            EnchantmentData d = enchants.get(m);
            if (d == null) continue;
            if (enchanted.func_77973_b() == Items.field_151122_aG) {
                enchanted = new ItemStack((Item)Items.field_151134_bR, 1, 0);
            }
            enchanted.func_77966_a(d.field_76302_b, d.field_76303_c);
        }
        this.func_70299_a(2, enchanted);
        this.enchants = null;
    }

    public List<EnchantmentData> getEnchantmentsForStack(ItemStack stack) {
        if (this.enchants == null) {
            this.enchants = EnchantmentHelper.func_77513_b((Random)this.field_145850_b.field_73012_v, (ItemStack)stack, (int)this.getMaxPower());
        }
        return this.enchants;
    }

    public int getRequiredTimeToAct() {
        return this.getMaxPower() * 10;
    }

    public int getRequiredMRU() {
        return this.getMaxPower() * 1000;
    }

    public int getMaxPower() {
        int l = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    l = (int)((float)l + ForgeHooks.getEnchantPower((World)this.field_145850_b, (int)(this.field_145851_c + x), (int)(this.field_145848_d + y), (int)(this.field_145849_e + z)));
                }
            }
        }
        if (l > maxEnchantmentLevel) {
            l = maxEnchantmentLevel;
        }
        return l;
    }

    public boolean canItemBeEnchanted() {
        try {
            ItemStack s = this.func_70301_a(1);
            return s != null && this.getMaxPower() > 0 && this.getMRU() > mruUsage && this.func_70301_a(2) == null && s.func_77956_u() && this.getEnchantmentsForStack(s) != null && !this.getEnchantmentsForStack(s).isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicalEnchanterSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage:100", "Max level of enchantment:60", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):2"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            maxEnchantmentLevel = Integer.parseInt(data[2].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[3].fieldValue);
            genCorruption = Integer.parseInt(data[4].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2};
    }
}

