/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.Lightning;
import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ec3.api.EnumStructureType;
import ec3.api.IMRUPressence;
import ec3.common.block.BlocksCore;
import ec3.common.item.ItemPlayerList;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;

public class TileMRUCoil
extends TileMRUGeneric {
    public float rad = 1.0f;
    public Lightning localLightning;
    public Lightning monsterLightning;
    public int height;
    public int ticksBeforeStructureCheck;
    public int lightningTicks;
    public boolean isStructureCorrect;
    public static float cfgMaxMRU = 50000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 50;
    public static int mruUsage = 200;
    public static boolean hurtPlayers = true;
    public static boolean hurtPassive = true;
    public static float damage = 18.0f;
    public static float radiusModifier = 1.0f;

    public TileMRUCoil() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(2);
    }

    public boolean isStructureCorrect() {
        return this.isStructureCorrect && this.getMRU() > mruUsage;
    }

    public void initStructure() {
        this.height = 0;
        this.rad = 0.0f;
        this.isStructureCorrect = false;
        int dy = this.field_145848_d - 1;
        while (this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e) == BlocksCore.mruCoilHardener) {
            --dy;
            ++this.height;
        }
        List<Block> allowed = ECUtils.allowedBlocks.get((Object)EnumStructureType.MRUCoil);
        Block b_0 = this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e);
        Block b_1 = this.field_145850_b.func_147439_a(this.field_145851_c + 1, dy, this.field_145849_e);
        Block b_2 = this.field_145850_b.func_147439_a(this.field_145851_c - 1, dy, this.field_145849_e);
        Block b_3 = this.field_145850_b.func_147439_a(this.field_145851_c + 1, dy, this.field_145849_e + 1);
        Block b_4 = this.field_145850_b.func_147439_a(this.field_145851_c - 1, dy, this.field_145849_e + 1);
        Block b_5 = this.field_145850_b.func_147439_a(this.field_145851_c + 1, dy, this.field_145849_e - 1);
        Block b_6 = this.field_145850_b.func_147439_a(this.field_145851_c - 1, dy, this.field_145849_e - 1);
        Block b_7 = this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e + 1);
        Block b_8 = this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e - 1);
        Block b_0_0 = this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e - 2);
        Block b_0_1 = this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e + 2);
        Block b_0_2 = this.field_145850_b.func_147439_a(this.field_145851_c + 2, dy, this.field_145849_e);
        Block b_0_3 = this.field_145850_b.func_147439_a(this.field_145851_c - 2, dy, this.field_145849_e);
        Block b_1_0 = this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e - 3);
        Block b_1_1 = this.field_145850_b.func_147439_a(this.field_145851_c + 1, dy, this.field_145849_e - 3);
        Block b_1_2 = this.field_145850_b.func_147439_a(this.field_145851_c - 1, dy, this.field_145849_e - 3);
        Block b_1_3 = this.field_145850_b.func_147439_a(this.field_145851_c, dy, this.field_145849_e + 3);
        Block b_1_4 = this.field_145850_b.func_147439_a(this.field_145851_c + 1, dy, this.field_145849_e + 3);
        Block b_1_5 = this.field_145850_b.func_147439_a(this.field_145851_c - 1, dy, this.field_145849_e + 3);
        Block b_1_6 = this.field_145850_b.func_147439_a(this.field_145851_c + 3, dy, this.field_145849_e);
        Block b_1_7 = this.field_145850_b.func_147439_a(this.field_145851_c + 3, dy, this.field_145849_e - 1);
        Block b_1_8 = this.field_145850_b.func_147439_a(this.field_145851_c + 3, dy, this.field_145849_e + 1);
        Block b_1_9 = this.field_145850_b.func_147439_a(this.field_145851_c - 3, dy, this.field_145849_e);
        Block b_1_10 = this.field_145850_b.func_147439_a(this.field_145851_c - 3, dy, this.field_145849_e - 1);
        Block b_1_11 = this.field_145850_b.func_147439_a(this.field_145851_c - 3, dy, this.field_145849_e + 1);
        ArrayList<Block> cBl = new ArrayList<Block>();
        cBl.add(b_0);
        cBl.add(b_1);
        cBl.add(b_2);
        cBl.add(b_3);
        cBl.add(b_4);
        cBl.add(b_5);
        cBl.add(b_6);
        cBl.add(b_7);
        cBl.add(b_8);
        cBl.add(b_0_0);
        cBl.add(b_0_1);
        cBl.add(b_0_2);
        cBl.add(b_0_3);
        cBl.add(b_1_0);
        cBl.add(b_1_1);
        cBl.add(b_1_2);
        cBl.add(b_1_3);
        cBl.add(b_1_4);
        cBl.add(b_1_5);
        cBl.add(b_1_6);
        cBl.add(b_1_7);
        cBl.add(b_1_8);
        cBl.add(b_1_9);
        cBl.add(b_1_10);
        cBl.add(b_1_11);
        if (allowed.containsAll(cBl)) {
            this.isStructureCorrect = true;
            this.rad = this.height + 3;
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            List entities;
            if (this.field_145850_b.field_72995_K) {
                if (this.isStructureCorrect()) {
                    if (this.localLightning == null) {
                        this.localLightning = new Lightning(this.field_145850_b.field_73012_v, new Coord3D(0.5f, 0.9f, 0.5f), new Coord3D(0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v), (double)0.9f + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v), 0.5 + MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v)), 0.1f, new float[]{1.0f, 0.2f, 1.0f});
                    } else if (this.localLightning.renderTicksExisted >= 20.0f) {
                        this.localLightning = null;
                    }
                } else {
                    this.localLightning = null;
                }
            }
            if (this.monsterLightning != null) {
                if (!this.field_145850_b.field_72995_K) {
                    ++this.lightningTicks;
                }
                if (this.monsterLightning.renderTicksExisted >= 20.0f && this.field_145850_b.field_72995_K) {
                    this.monsterLightning = null;
                }
                if (this.lightningTicks >= 20 && !this.field_145850_b.field_72995_K) {
                    this.lightningTicks = 0;
                    this.monsterLightning = null;
                }
            }
            if (this.isStructureCorrect && (entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)(this.rad * radiusModifier), (double)(this.rad * radiusModifier), (double)(this.rad * radiusModifier)))) != null && !entities.isEmpty() && this.monsterLightning == null) {
                block0: for (EntityLivingBase b : entities) {
                    if (b instanceof EntityPlayer) {
                        if (((EntityPlayer)b).field_71075_bZ.field_75098_d || !hurtPlayers) continue;
                        ItemStack is = this.func_70301_a(1);
                        if (is != null && is.func_77973_b() instanceof ItemPlayerList) {
                            NBTTagCompound itemTag = MiscUtils.getStackTag((ItemStack)is);
                            if (!itemTag.func_74764_b("usernames")) {
                                itemTag.func_74778_a("usernames", "||username:null");
                            }
                            String str = itemTag.func_74779_i("usernames");
                            DummyData[] dt = DataStorage.parseData((String)str);
                            for (int i = 0; i < dt.length; ++i) {
                                String username = dt[i].fieldValue;
                                String playerName = b.func_70005_c_();
                                if (username.equals(playerName)) continue block0;
                            }
                            this.attack(b);
                            continue;
                        }
                        this.attack(b);
                        continue;
                    }
                    if (!(b instanceof IMob) && !hurtPassive || b instanceof IMRUPressence) continue;
                    this.attack(b);
                    break;
                }
            }
            if (this.ticksBeforeStructureCheck <= 0) {
                this.ticksBeforeStructureCheck = 20;
                this.initStructure();
            } else {
                --this.ticksBeforeStructureCheck;
            }
        }
        super.func_145845_h();
        ECUtils.manage(this, 0);
    }

    public void attack(EntityLivingBase b) {
        if (this.getMRU() > mruUsage && !b.field_70128_L && b.field_70737_aN <= 0 && b.field_70172_ad <= 0) {
            if (generatesCorruption) {
                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
            }
            b.func_70097_a(DamageSource.field_76376_m, damage);
            if (this.field_145850_b.field_72995_K && this.monsterLightning == null) {
                this.field_145850_b.func_72980_b((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "essentialcraft:sound.lightning_hit", 2.0f, 2.0f, false);
            }
            this.monsterLightning = new Lightning(this.field_145850_b.field_73012_v, new Coord3D(0.5f, 0.8f, 0.5f), new Coord3D(b.field_70165_t - (double)this.field_145851_c + 0.5, b.field_70163_u - (double)this.field_145848_d + 0.8, b.field_70161_v - (double)this.field_145849_e + 0.5), 0.1f, new float[]{1.0f, 0.0f, 0.7f});
            if (!this.field_145850_b.field_72995_K) {
                this.setMRU(this.getMRU() - mruUsage);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MRUCoilSettings", "tileentities", new String[]{"Max MRU:50000.0", "MRU Usage per hit:1000", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):20", "Can the coil attack players, and, therefore, requires a Whitelist:true", "Can the coil attack passive entities, like sheep:true", "Damage per hit:18.0", "Radius multiplier:1.0"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            hurtPlayers = Boolean.parseBoolean(data[4].fieldValue);
            hurtPassive = Boolean.parseBoolean(data[5].fieldValue);
            damage = Float.parseFloat(data[6].fieldValue);
            radiusModifier = Float.parseFloat(data[7].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }
}

