/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import ec3.common.block.BlockCorruption_Light;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public class TileCorruptionCleaner
extends TileMRUGeneric {
    public Coord3D cleared;
    public int clearTime = 0;
    public static int maxRadius = 8;
    public static boolean removeBlock = false;
    public static int mruUsage = 20;
    public static int ticksRequired = 200;
    public static float cfgMaxMRU = 5000.0f;

    public TileCorruptionCleaner() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(1);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.cleared == null) {
                int offsetZ;
                int offsetY;
                int offsetX;
                Block b;
                if (!this.field_145850_b.field_72995_K && (b = this.field_145850_b.func_147439_a(this.field_145851_c + (offsetX = (int)(MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) * (double)maxRadius)), this.field_145848_d + (offsetY = (int)(MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) * (double)maxRadius)), this.field_145849_e + (offsetZ = (int)(MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) * (double)maxRadius)))) instanceof BlockCorruption_Light) {
                    this.cleared = new Coord3D((float)(this.field_145851_c + offsetX), (float)(this.field_145848_d + offsetY), (float)(this.field_145849_e + offsetZ));
                    this.clearTime = ticksRequired;
                }
            } else if (!this.field_145850_b.field_72995_K) {
                Block b = this.field_145850_b.func_147439_a((int)this.cleared.x, (int)this.cleared.y, (int)this.cleared.z);
                if (!(b instanceof BlockCorruption_Light)) {
                    this.cleared = null;
                    this.clearTime = 0;
                    return;
                }
                if (this.getMRU() - mruUsage > 0) {
                    --this.clearTime;
                    this.setMRU(this.getMRU() - mruUsage);
                    if (this.clearTime <= 0) {
                        int metadata = this.field_145850_b.func_72805_g((int)this.cleared.x, (int)this.cleared.y, (int)this.cleared.z);
                        if (metadata == 0 || removeBlock) {
                            this.field_145850_b.func_147468_f((int)this.cleared.x, (int)this.cleared.y, (int)this.cleared.z);
                        } else {
                            this.field_145850_b.func_72921_c((int)this.cleared.x, (int)this.cleared.y, (int)this.cleared.z, metadata - 1, 3);
                        }
                        this.cleared = null;
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        if (i.func_74764_b("coord")) {
            String str = i.func_74779_i("coord");
            if (!str.equals("null")) {
                DummyData[] coordData = DataStorage.parseData((String)i.func_74779_i("coord"));
                this.cleared = new Coord3D(Double.parseDouble(coordData[0].fieldValue), Double.parseDouble(coordData[1].fieldValue), Double.parseDouble(coordData[2].fieldValue));
            } else {
                this.cleared = null;
            }
        }
        this.clearTime = i.func_74762_e("clear");
        super.func_145839_a(i);
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        if (this.cleared != null) {
            i.func_74778_a("coord", this.cleared.toString());
        } else {
            i.func_74778_a("coord", "null");
        }
        i.func_74768_a("clear", this.clearTime);
        super.func_145841_b(i);
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("CorruptionCleanerSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage per Tick:20", "Required time to destroy corruption:200", "Should remove corruption blocks instead of reducing their growth:false", "A radius in which the device will detect corruption blocks:8"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            maxRadius = Integer.parseInt(data[4].fieldValue);
            removeBlock = Boolean.parseBoolean(data[3].fieldValue);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            ticksRequired = Integer.parseInt(data[2].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0};
    }
}

