/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MiscUtils;
import ec3.common.block.BlocksCore;
import ec3.common.registry.BiomeRegistry;
import ec3.common.registry.PotionRegistry;
import ec3.utils.common.ECUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCorruption
extends TileEntity {
    public static boolean canChangeBiome = true;
    public static boolean canDestroyBlocks = true;

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (net.func_150729_e() instanceof INetHandlerPlayClient && pkt.func_148853_f() == -11) {
            NBTTagCompound packetTag = pkt.func_148857_g();
            int biomeID = packetTag.func_74762_e("biomeID");
            MiscUtils.changeBiome((World)this.field_145850_b, (BiomeGenBase)BiomeGenBase.func_150565_n()[biomeID], (int)this.field_145851_c, (int)this.field_145849_e);
        }
    }

    public void changeBiomeAtPos(int biomeID) {
        if (canChangeBiome) {
            MiscUtils.changeBiome((World)this.field_145850_b, (BiomeGenBase)BiomeGenBase.func_150565_n()[biomeID], (int)this.field_145851_c, (int)this.field_145849_e);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("biomeID", biomeID);
            S35PacketUpdateTileEntity pkt = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -11, nbttagcompound);
            MiscUtils.sendPacketToAllAround((World)this.field_145850_b, (Packet)pkt, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)this.field_145850_b.field_73011_w.field_76574_g, (double)32.0);
        }
    }

    public void addPotionEffectAtEntity(EntityLivingBase e, PotionEffect p) {
        if (!e.func_82165_m(p.func_76456_a())) {
            e.func_70690_d(p);
        }
    }

    public void func_145845_h() {
        try {
            int metadata;
            super.func_145845_h();
            Potion potionToAdd = PotionRegistry.mruCorruptionPotion;
            Block blk = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (blk == BlocksCore.lightCorruption[0]) {
                potionToAdd = PotionRegistry.chaosInfluence;
            }
            if (blk == BlocksCore.lightCorruption[1]) {
                potionToAdd = PotionRegistry.frozenMind;
            }
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)));
            for (int i = 0; i < players.size(); ++i) {
                if (this.field_145850_b.field_72995_K) continue;
                float increasement = 5.0f;
                ECUtils.calculateAndAddPE((EntityPlayer)players.get(i), potionToAdd, 2000, (int)(increasement *= ECUtils.getGenResistance(1, (EntityPlayer)players.get(i))));
            }
            if (this.field_145850_b.field_73012_v.nextFloat() <= 1.0E-4f) {
                int biomeId = 0;
                if (blk == BlocksCore.lightCorruption[0]) {
                    biomeId = BiomeRegistry.chaosCorruption.field_76756_M;
                }
                if (blk == BlocksCore.lightCorruption[1]) {
                    biomeId = BiomeRegistry.frozenCorruption.field_76756_M;
                }
                if (blk == BlocksCore.lightCorruption[2]) {
                    biomeId = BiomeRegistry.shadowCorruption.field_76756_M;
                }
                if (blk == BlocksCore.lightCorruption[3]) {
                    biomeId = BiomeRegistry.magicCorruption.field_76756_M;
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.changeBiomeAtPos(biomeId);
                }
            }
            if ((metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) >= 7 && canDestroyBlocks) {
                for (int i = 0; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                    if (this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) != null || !this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ).func_149747_d((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir.getOpposite().ordinal())) continue;
                    this.field_145850_b.func_147465_d(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, blk, 0, 3);
                }
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a, 0, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("CorruptionSettings", "tileentities", new String[]{"Change Biome:true", "Destroy Blocks if grown:true"}, "Settings of the given Device.");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            canChangeBiome = Boolean.parseBoolean(data[0].fieldValue);
            canDestroyBlocks = Boolean.parseBoolean(data[1].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }
}

