/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.item;

import DummyCore.Utils.MiscUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ec3.api.IItemRequiresMRU;
import ec3.common.item.ItemsCore;
import ec3.utils.common.ECUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemElementalSword
extends ItemSword
implements IItemRequiresMRU {
    int maxMRU = 5000;
    static Random rand = new Random(8192L);
    public static IIcon[] icon = new IIcon[8];

    public Item setMaxMRU(int max) {
        this.maxMRU = max;
        return this;
    }

    public ItemElementalSword() {
        super(ItemsCore.elemental);
        this.setMaxMRU(5000);
        this.field_77777_bU = 1;
        this.field_77789_bW = true;
        this.func_77656_e(0);
    }

    @Override
    public boolean setMRU(ItemStack stack, int amount) {
        if (MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru") + amount >= 0 && MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru") + amount <= MiscUtils.getStackTag((ItemStack)stack).func_74762_e("maxMRU")) {
            MiscUtils.getStackTag((ItemStack)stack).func_74768_a("mru", MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru") + amount);
            return true;
        }
        return false;
    }

    @Override
    public int getMRU(ItemStack stack) {
        return MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru");
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        String attrib = ItemElementalSword.getPrimaryAttribute(par1ItemStack);
        if (attrib.contains("Fire") && (ECUtils.tryToDecreaseMRUInStorage((EntityPlayer)par3EntityLivingBase, -50) || this.setMRU(par1ItemStack, -50))) {
            par2EntityLivingBase.func_70015_d(5);
        }
        if (attrib.contains("Water") && (ECUtils.tryToDecreaseMRUInStorage((EntityPlayer)par3EntityLivingBase, -50) || this.setMRU(par1ItemStack, -50))) {
            par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 40, 0));
            par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 40, 0));
        }
        if (attrib.contains("Earth") && (ECUtils.tryToDecreaseMRUInStorage((EntityPlayer)par3EntityLivingBase, -50) || this.setMRU(par1ItemStack, -50))) {
            par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 10, 0));
        }
        if (attrib.contains("Air") && (ECUtils.tryToDecreaseMRUInStorage((EntityPlayer)par3EntityLivingBase, -50) || this.setMRU(par1ItemStack, -50))) {
            par3EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 50, 0));
            par3EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 50, 0));
        }
        List<String> embers = ItemElementalSword.getEmberEffects(par1ItemStack);
        if (ECUtils.tryToDecreaseMRUInStorage((EntityPlayer)par3EntityLivingBase, -50) || this.setMRU(par1ItemStack, -50)) {
            for (int i = 0; i < 11; ++i) {
                if (!embers.contains("Damage +" + i)) continue;
            }
            if (embers.contains("Slowness")) {
                par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 0));
            }
            if (embers.contains("Greater Slowness")) {
                par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 60, 1));
            }
            if (embers.contains("Poison")) {
                par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 0));
            }
            if (embers.contains("Greater Poison")) {
                par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 1));
            }
            if (embers.contains("Damage Self")) {
                par3EntityLivingBase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)par3EntityLivingBase), 2.0f);
            }
            if (embers.contains("Lightning")) {
                EntityLightningBolt bold = new EntityLightningBolt(par2EntityLivingBase.field_70170_p, par2EntityLivingBase.field_70165_t, par2EntityLivingBase.field_70163_u, par2EntityLivingBase.field_70161_v);
                par2EntityLivingBase.field_70170_p.func_72942_c((Entity)bold);
                if (!par2EntityLivingBase.field_70170_p.field_72995_K) {
                    par2EntityLivingBase.field_70170_p.func_72838_d((Entity)bold);
                }
                par3EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 60, 1));
            }
            if (embers.contains("Lifesteal")) {
                par3EntityLivingBase.func_70691_i(1.0f);
            }
            if (embers.contains("Greater Lifesteal")) {
                par3EntityLivingBase.func_70691_i(3.0f);
            }
            if (embers.contains("Weakness")) {
                par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60, 0));
            }
            if (embers.contains("Greater Weakness")) {
                par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60, 1));
            }
            if (embers.contains("Greater Damage Boost")) {
                par3EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 60, 1));
            }
            if (embers.contains("Damage Boost")) {
                par3EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 60, 0));
            }
            if (embers.contains("Greater Speed Boost")) {
                par3EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
            }
            if (embers.contains("Speed Boost")) {
                par3EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 0));
            }
            if (embers.contains("Greater Hunger")) {
                par2EntityLivingBase.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 60, 1));
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int indexInInventory, boolean isCurrentItem) {
        ECUtils.initMRUTag(itemStack, this.maxMRU);
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        String attrib = ItemElementalSword.getPrimaryAttribute(stack);
        int damage = 0;
        if (attrib.contains("Fire")) {
            damage += 7;
        }
        if (attrib.contains("Water")) {
            damage += 3;
        }
        if (attrib.contains("Earth")) {
            damage += 8;
        }
        if (attrib.contains("Air")) {
            damage += 8;
        }
        List<String> embers = ItemElementalSword.getEmberEffects(stack);
        for (int i = 0; i < 11; ++i) {
            if (!embers.contains("Damage +" + i)) continue;
            damage += i;
        }
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, 0));
        return multimap;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        if (par1ItemStack.func_77978_p() != null && par1ItemStack.func_77978_p().func_74764_b("ember_0")) {
            List<String> l = ItemElementalSword.getEmberEffects(par1ItemStack);
            par3List.addAll(l);
            par3List.add("Primal Attribute: " + par1ItemStack.func_77978_p().func_74779_i("primary"));
            par3List.add("Second Attribute: " + par1ItemStack.func_77978_p().func_74779_i("secondary"));
        }
        par3List.add(ECUtils.getStackTag(par1ItemStack).func_74762_e("mru") + "/" + ECUtils.getStackTag(par1ItemStack).func_74762_e("maxMRU") + " MRU");
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 1; ++var4) {
            ItemStack min = new ItemStack(par1, 1, 0);
            ECUtils.initMRUTag(min, this.maxMRU);
            ItemStack max = new ItemStack(par1, 1, 0);
            ECUtils.initMRUTag(max, this.maxMRU);
            ECUtils.getStackTag(max).func_74768_a("mru", ECUtils.getStackTag(max).func_74762_e("maxMRU"));
            par3List.add(min);
            par3List.add(max);
        }
    }

    @Override
    public int getMaxMRU(ItemStack stack) {
        return this.maxMRU;
    }

    public static void setPrimaryAttribute(ItemStack s) {
        NBTTagCompound tag = s.func_77978_p();
        if (tag.func_74764_b("primary")) {
            return;
        }
        if (tag.func_74764_b("focus_0")) {
            String s_0 = tag.func_74779_i("focus_0");
            String s_1 = tag.func_74779_i("focus_1");
            String s_2 = tag.func_74779_i("focus_2");
            String s_3 = tag.func_74779_i("focus_3");
            s_0 = s_0.toLowerCase();
            s_1 = s_1.toLowerCase();
            s_2 = s_2.toLowerCase();
            s_3 = s_3.toLowerCase();
            int fire = 0;
            int water = 0;
            int earth = 0;
            int air = 0;
            if (s_0.toLowerCase().contains("ffocus")) {
                ++fire;
            }
            if (s_1.toLowerCase().contains("ffocus")) {
                ++fire;
            }
            if (s_2.toLowerCase().contains("ffocus")) {
                ++fire;
            }
            if (s_3.toLowerCase().contains("ffocus")) {
                ++fire;
            }
            if (s_0.toLowerCase().contains("wfocus")) {
                ++water;
            }
            if (s_1.toLowerCase().contains("wfocus")) {
                ++water;
            }
            if (s_2.toLowerCase().contains("wfocus")) {
                ++water;
            }
            if (s_3.toLowerCase().contains("wfocus")) {
                ++water;
            }
            if (s_0.toLowerCase().contains("efocus")) {
                ++earth;
            }
            if (s_1.toLowerCase().contains("efocus")) {
                ++earth;
            }
            if (s_2.toLowerCase().contains("efocus")) {
                ++earth;
            }
            if (s_3.toLowerCase().contains("efocus")) {
                ++earth;
            }
            if (s_0.toLowerCase().contains("afocus")) {
                ++air;
            }
            if (s_1.toLowerCase().contains("afocus")) {
                ++air;
            }
            if (s_2.toLowerCase().contains("afocus")) {
                ++air;
            }
            if (s_3.toLowerCase().contains("afocus")) {
                ++air;
            }
            if (fire > water && fire > earth && fire > air) {
                tag.func_74778_a("primary", "Fire");
            } else if (water > fire && water > earth && water > air) {
                tag.func_74778_a("primary", "Water");
            } else if (earth > water && earth > fire && earth > air) {
                tag.func_74778_a("primary", "Earth");
            } else if (air > water && air > earth && air > fire) {
                tag.func_74778_a("primary", "Air");
            } else {
                tag.func_74778_a("primary", "Combined");
            }
            ArrayList<String> secondaryAttribs = new ArrayList<String>();
            if (fire != 0) {
                secondaryAttribs.add("Fire");
            }
            if (water != 0) {
                secondaryAttribs.add("Water");
            }
            if (earth != 0) {
                secondaryAttribs.add("Earth");
            }
            if (air != 0) {
                secondaryAttribs.add("Air");
            }
            if (!secondaryAttribs.isEmpty()) {
                tag.func_74778_a("secondary", (String)secondaryAttribs.get(rand.nextInt(secondaryAttribs.size())));
            } else {
                tag.func_74778_a("secondary", ItemElementalSword.getPrimaryAttribute(s));
            }
        } else {
            return;
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        int ret = ItemElementalSword.getA(stack, pass);
        if (ret == -1) {
            return this.field_77791_bV;
        }
        return icon[ret + pass * 4];
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public static String getPrimaryAttribute(ItemStack s) {
        if (s.func_77942_o()) {
            return s.func_77978_p().func_74779_i("primary");
        }
        return "combined";
    }

    public static String getSecondaryAttribute(ItemStack s) {
        if (s.func_77942_o()) {
            return s.func_77978_p().func_74779_i("secondary");
        }
        return "combined";
    }

    public static int getA(ItemStack s, int pass) {
        String a = "";
        a = pass == 0 ? ItemElementalSword.getPrimaryAttribute(s) : ItemElementalSword.getSecondaryAttribute(s);
        if (a.contains("Fire")) {
            return 0;
        }
        if (a.contains("Water")) {
            return 1;
        }
        if (a.contains("Earth")) {
            return 2;
        }
        if (a.contains("Air")) {
            return 3;
        }
        return -1;
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        ItemElementalSword.icon[0] = par1IconRegister.func_94245_a("essentialcraft:modular/pa_Fire");
        ItemElementalSword.icon[1] = par1IconRegister.func_94245_a("essentialcraft:modular/pa_Water");
        ItemElementalSword.icon[2] = par1IconRegister.func_94245_a("essentialcraft:modular/pa_Earth");
        ItemElementalSword.icon[3] = par1IconRegister.func_94245_a("essentialcraft:modular/pa_Air");
        ItemElementalSword.icon[4] = par1IconRegister.func_94245_a("essentialcraft:modular/sa_Fire");
        ItemElementalSword.icon[5] = par1IconRegister.func_94245_a("essentialcraft:modular/sa_Water");
        ItemElementalSword.icon[6] = par1IconRegister.func_94245_a("essentialcraft:modular/sa_Earth");
        ItemElementalSword.icon[7] = par1IconRegister.func_94245_a("essentialcraft:modular/sa_Air");
        super.func_94581_a(par1IconRegister);
    }

    public static List<String> getEmberEffects(ItemStack par1ItemStack) {
        ArrayList<String> ret = new ArrayList<String>();
        String allEmbers = par1ItemStack.func_77978_p().func_74779_i("ember_0") + " " + par1ItemStack.func_77978_p().func_74779_i("ember_1") + " " + par1ItemStack.func_77978_p().func_74779_i("ember_2") + " " + par1ItemStack.func_77978_p().func_74779_i("ember_3");
        if ((allEmbers = allEmbers.toLowerCase()).contains("acid") && allEmbers.contains("chaos")) {
            ret.add("Damage +4");
        }
        if (allEmbers.contains("acid") && allEmbers.contains("common")) {
            ret.add("Damage +2");
        }
        if (allEmbers.contains("acid") && allEmbers.contains("corruption")) {
            ret.add("Slowness");
        }
        if (allEmbers.contains("acid") && allEmbers.contains("crystal")) {
            ret.add("Damage +6");
        }
        if (allEmbers.contains("acid") && allEmbers.contains("divine")) {
            ret.add("Poison");
        }
        if (allEmbers.contains("acid") && allEmbers.contains("magic")) {
            ret.add("Greater Poison");
        }
        if (allEmbers.contains("acid") && allEmbers.contains("flame")) {
            ret.add("Damage +8");
        }
        if (allEmbers.contains("chaos") && allEmbers.contains("common")) {
            ret.add("Damage Self");
            ret.add("Damage +7");
        }
        if (allEmbers.contains("chaos") && allEmbers.contains("corruption")) {
            ret.add("Greater Slow");
        }
        if (allEmbers.contains("chaos") && allEmbers.contains("crystal")) {
            ret.add("Damage +5");
        }
        if (allEmbers.contains("chaos") && allEmbers.contains("divine")) {
            ret.add("Lightning");
        }
        if (allEmbers.contains("chaos") && allEmbers.contains("magic")) {
            ret.add("Damage +6");
        }
        if (allEmbers.contains("chaos") && allEmbers.contains("flame")) {
            ret.add("Damage +4");
        }
        if (allEmbers.contains("common") && allEmbers.contains("corruption")) {
            ret.add("Weakness");
        }
        if (allEmbers.contains("common") && allEmbers.contains("crystal")) {
            ret.add("Damage +3");
        }
        if (allEmbers.contains("common") && allEmbers.contains("divine")) {
            ret.add("Damage Boost");
        }
        if (allEmbers.contains("common") && allEmbers.contains("magic")) {
            ret.add("Speed Boost");
        }
        if (allEmbers.contains("common") && allEmbers.contains("flame")) {
            ret.add("Damage +11");
        }
        if (allEmbers.contains("corruption") && allEmbers.contains("crystal")) {
            ret.add("Lifesteal");
        }
        if (allEmbers.contains("corruption") && allEmbers.contains("divine")) {
            ret.add("Damage Self");
            ret.add("Greater Hunger");
        }
        if (allEmbers.contains("corruption") && allEmbers.contains("magic")) {
            ret.add("Greater Lifesteal");
        }
        if (allEmbers.contains("corruption") && allEmbers.contains("flame")) {
            ret.add("Damage +5");
        }
        if (allEmbers.contains("crystal") && allEmbers.contains("divine")) {
            ret.add("Damage +9");
        }
        if (allEmbers.contains("crystal") && allEmbers.contains("magic")) {
            ret.add("Damage +7");
        }
        if (allEmbers.contains("crystal") && allEmbers.contains("flame")) {
            ret.add("Greater Speed Boost");
        }
        if (allEmbers.contains("magic") && allEmbers.contains("flame")) {
            ret.add("Damage +6");
        }
        return ret;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        String attrib = ItemElementalSword.getSecondaryAttribute(par1ItemStack);
        if (attrib.contains("Fire") && (ECUtils.tryToDecreaseMRUInStorage(par3EntityPlayer, -50) || this.setMRU(par1ItemStack, -50))) {
            par3EntityPlayer.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 50, 0));
            List l = par2World.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(par3EntityPlayer.field_70165_t - 2.0), (double)(par3EntityPlayer.field_70163_u - 1.0), (double)(par3EntityPlayer.field_70161_v - 2.0), (double)(par3EntityPlayer.field_70165_t + 2.0), (double)(par3EntityPlayer.field_70163_u + 3.0), (double)(par3EntityPlayer.field_70161_v + 2.0)));
            if (!l.isEmpty()) {
                for (int i = 0; i < l.size(); ++i) {
                    EntityLivingBase b = (EntityLivingBase)l.get(i);
                    b.func_70015_d(2);
                }
            }
        }
        if (attrib.contains("Water") && (ECUtils.tryToDecreaseMRUInStorage(par3EntityPlayer, -50) || this.setMRU(par1ItemStack, -50))) {
            par3EntityPlayer.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 40, 0));
        }
        if (attrib.contains("Earth") && (ECUtils.tryToDecreaseMRUInStorage(par3EntityPlayer, -50) || this.setMRU(par1ItemStack, -50))) {
            par3EntityPlayer.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 40, 0));
        }
        if (attrib.contains("Air") && (ECUtils.tryToDecreaseMRUInStorage(par3EntityPlayer, -50) || this.setMRU(par1ItemStack, -50))) {
            par3EntityPlayer.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 30, 0));
            par3EntityPlayer.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 30, 0));
        }
        return par1ItemStack;
    }
}

