/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.item;

import DummyCore.Utils.DCASMCheck;
import DummyCore.Utils.ExistanceCheck;
import DummyCore.Utils.MiscUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ec3.api.IItemRequiresMRU;
import ec3.common.item.ItemsCore;
import ec3.common.mod.EssentialCraftCore;
import ec3.utils.common.ECUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;

@DCASMCheck
@ExistanceCheck(classPath={"thaumcraft.api.IRepairable", "thaumcraft.api.IVisDiscountGear", "thaumcraft.api.nodes.IRevealer", "thaumcraft.api.IGoggles"})
public class ItemComputerArmor
extends ItemArmor
implements IRepairable,
IVisDiscountGear,
IRevealer,
IGoggles,
ISpecialArmor,
IItemRequiresMRU {
    public static int[] discount = new int[]{18, 25, 12, 15};
    public ItemArmor.ArmorMaterial mat;

    public ItemComputerArmor(ItemArmor.ArmorMaterial material, int armorType, int texture) {
        super(material, armorType, texture);
        this.mat = material;
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        switch (slot) {
            case 2: {
                return "essentialcraft:textures/special/armor/computer_layer_2.png";
            }
        }
        return "essentialcraft:textures/special/armor/computer_layer_1.png";
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap mods = HashMultimap.create();
        if (this == ItemsCore.computer_chestplate) {
            mods.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("1bca943c-3cf5-42cc-a3df-2ed994ae0000"), "hp", 40.0, 0));
        }
        if (this == ItemsCore.computer_leggings) {
            mods.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("1bca943c-3cf5-42cc-a3df-2ed994ae0001"), "movespeed", 0.15, 0));
        }
        return mods;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (EssentialCraftCore.clazzExists("thaumcraft.api.IVisDiscountGear")) {
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"tc.visdiscount") + ": " + this.getVisDiscount(stack, player, null) + "%");
        }
        list.add(this.getMRU(stack) + "/" + this.getMaxMRU(stack) + " MRU");
        switch (this.field_77881_a) {
            case 0: {
                list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"ec3.txt.computer_helmet.props"));
                break;
            }
            case 1: {
                list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"ec3.txt.computer_chestplate.props"));
                break;
            }
            case 2: {
                list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"ec3.txt.computer_legs.props"));
                break;
            }
            case 3: {
                list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"ec3.txt.computer_boots.props"));
            }
        }
        list.add(" ");
        list.add((this.hasFullset(player) ? EnumChatFormatting.GREEN : EnumChatFormatting.RESET) + StatCollector.func_74838_a((String)"ec3.txt.fullset"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"ec3.txt.fullset.computer.props"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"ec3.txt.fullset.computer.props_2"));
    }

    public boolean hasFullset(EntityPlayer p) {
        if (p == null) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (p.field_71071_by.field_70460_b[i] != null && p.field_71071_by.field_70460_b[i].func_77973_b() instanceof ItemComputerArmor) continue;
            return false;
        }
        return true;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 1; ++var4) {
            ItemStack min = new ItemStack(par1, 1, 0);
            ECUtils.initMRUTag(min, 1000000);
            ItemStack max = new ItemStack(par1, 1, 0);
            ECUtils.initMRUTag(max, 1000000);
            ECUtils.getStackTag(max).func_74768_a("mru", 1000000);
            par3List.add(min);
            par3List.add(max);
        }
    }

    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        int type = ((ItemArmor)itemstack.func_77973_b()).field_77881_a;
        return type == 0;
    }

    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        int type = ((ItemArmor)itemstack.func_77973_b()).field_77881_a;
        return type == 0;
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        int type = ((ItemArmor)stack.func_77973_b()).field_77881_a;
        return discount[type];
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int mru;
        if (armor.func_77973_b() == ItemsCore.computer_chestplate && player instanceof EntityPlayer) {
            boolean hasFullSet = true;
            EntityPlayer p = (EntityPlayer)player;
            for (int i = 0; i < 4; ++i) {
                if (p.field_71071_by.field_70460_b[i] != null && p.field_71071_by.field_70460_b[i].func_77973_b() instanceof ItemComputerArmor) continue;
                hasFullSet = false;
                break;
            }
            if (source.func_76364_f() != null && hasFullSet) {
                float newDamage = (float)(damage / 2.0);
                if ((double)newDamage < 0.5) {
                    newDamage = 0.0f;
                }
                ECUtils.playSoundToAllNearby(player.field_70165_t, player.field_70163_u, player.field_70161_v, "essentialcraft:sound.lightning_hit", 0.2f, 1.0f, 8.0, player.field_71093_bK);
                source.func_76364_f().func_70097_a(DamageSource.func_92087_a((Entity)player), newDamage);
            }
        }
        if ((mru = this.getMRU(armor)) > 0) {
            ItemArmor aarmor = (ItemArmor)armor.func_77973_b();
            return new ISpecialArmor.ArmorProperties(0, (double)aarmor.field_77879_b / 10.0, Integer.MAX_VALUE);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 1);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.mat.func_78044_b(this.field_77881_a);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        EntityPlayer p;
        if (!(entity instanceof EntityPlayer) || ECUtils.tryToDecreaseMRUInStorage(p = (EntityPlayer)entity, -damage * 250) || this.setMRU(stack, -damage * 250)) {
            // empty if block
        }
    }

    @Override
    public boolean setMRU(ItemStack stack, int amount) {
        if (this.getMRU(stack) + amount >= 0 && this.getMRU(stack) + amount <= this.getMaxMRU(stack)) {
            MiscUtils.getStackTag((ItemStack)stack).func_74768_a("mru", MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru") + amount);
            return true;
        }
        return false;
    }

    @Override
    public int getMRU(ItemStack stack) {
        return MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru");
    }

    @Override
    public int getMaxMRU(ItemStack stack) {
        return 1000000;
    }
}

