/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import ec3.common.item.ItemStoresMRUInNBT;
import ec3.utils.common.ECUtils;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;

public class ItemCharm
extends ItemStoresMRUInNBT
implements IBauble {
    public IIcon[] icon = new IIcon[10];
    public String[] name = new String[]{"Fire", "Water", "Earth", "Air", "Steam", "Magma", "Lightning", "Life", "Rain", "Dust"};

    public ItemCharm() {
        this.setMaxMRU(5000);
        this.func_77656_e(0);
        this.field_77777_bU = 1;
        this.field_77789_bW = false;
        this.func_77627_a(true);
    }

    public void onWornTick(ItemStack s, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer e = (EntityPlayer)entity;
            int dam = s.func_77960_j();
            switch (dam) {
                case 0: {
                    this.updateFire(e, s);
                    break;
                }
                case 1: {
                    this.updateWater(e, s);
                    break;
                }
                case 2: {
                    this.updateEarth(e, s);
                    break;
                }
                case 3: {
                    this.updateAir(e, s);
                    break;
                }
                case 4: {
                    this.updateSteam(e, s);
                    break;
                }
                case 5: {
                    this.updateMagma(e, s);
                    break;
                }
                case 6: {
                    this.updateLightning(e, s);
                    break;
                }
                case 7: {
                    this.updateLife(e, s);
                    break;
                }
                case 8: {
                    this.updateRain(e, s);
                    break;
                }
                case 9: {
                    this.updateDust(e, s);
                }
            }
        }
    }

    public IIcon func_77617_a(int par1) {
        return this.icon[par1];
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        for (int i = 0; i < 10; ++i) {
            this.icon[i] = par1IconRegister.func_94245_a("essentialcraft:tools/charm" + this.name[i]);
        }
    }

    @Override
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 10; ++var4) {
            ItemStack min = new ItemStack(par1, 1, var4);
            ECUtils.initMRUTag(min, this.maxMRU);
            ItemStack max = new ItemStack(par1, 1, var4);
            ECUtils.initMRUTag(max, this.maxMRU);
            ECUtils.getStackTag(max).func_74768_a("mru", ECUtils.getStackTag(max).func_74762_e("maxMRU"));
            par3List.add(min);
            par3List.add(max);
        }
    }

    public void updateFire(EntityPlayer e, ItemStack s) {
        if (e.func_70027_ad() && !e.func_82165_m(Potion.field_76426_n.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -50) || this.setMRU(s, -50))) {
            e.func_70066_B();
            e.field_70170_p.func_72956_a((Entity)e, "random.fizz", 1.0f, 1.0f);
        }
    }

    public void updateWater(EntityPlayer e, ItemStack s) {
        if (e.func_70086_ai() < 10 && e.func_70090_H() && (ECUtils.tryToDecreaseMRUInStorage(e, -100) || this.setMRU(s, -100))) {
            e.func_70050_g(100);
            e.field_70170_p.func_72956_a((Entity)e, "random.breath", 1.0f, 1.0f);
        }
    }

    public void updateEarth(EntityPlayer e, ItemStack s) {
        if (e.field_70737_aN > 0 && !e.func_82165_m(Potion.field_76429_m.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -200) || this.setMRU(s, -200))) {
            e.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 100, 0));
        }
    }

    public void updateAir(EntityPlayer e, ItemStack s) {
        if (e.func_70051_ag() && !e.func_82165_m(Potion.field_76424_c.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -10) || this.setMRU(s, -10))) {
            e.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 20, 1));
            e.field_70170_p.func_72956_a((Entity)e, "random.breath", 1.0f, 0.01f);
        }
    }

    public void updateSteam(EntityPlayer e, ItemStack s) {
        if (e.func_110143_aJ() < 5.0f && !e.func_82165_m(Potion.field_76424_c.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -200) || this.setMRU(s, -200))) {
            e.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 100, 5));
            e.field_70170_p.func_72956_a((Entity)e, "random.breath", 1.0f, 0.01f);
            e.field_70170_p.func_72956_a((Entity)e, "random.fizz", 1.0f, 0.01f);
        }
    }

    public void updateMagma(EntityPlayer e, ItemStack s) {
        Material m = e.field_70170_p.func_147439_a((int)e.field_70165_t - 1, (int)e.field_70163_u - 1, (int)e.field_70161_v).func_149688_o();
        Material m1 = e.field_70170_p.func_147439_a((int)e.field_70165_t - 1, (int)e.field_70163_u, (int)e.field_70161_v).func_149688_o();
        if (!(m != Material.field_151587_i && m1 != Material.field_151587_i || e.func_82165_m(Potion.field_76426_n.field_76415_H) || !ECUtils.tryToDecreaseMRUInStorage(e, -100) && !this.setMRU(s, -100))) {
            e.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 100, 0));
            e.field_70170_p.func_72956_a((Entity)e, "liquid.lava", 1.0f, 10.0f);
        }
    }

    public void updateLightning(EntityPlayer e, ItemStack s) {
        if (e.field_70170_p.func_72911_I() && !e.func_82165_m(Potion.field_76420_g.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -100) || this.setMRU(s, -100))) {
            e.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 100, 0));
            e.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 600, 0));
            e.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 100, 0));
            e.field_70170_p.func_72956_a((Entity)e, "ambient.weather.thunder1", 1.0f, 1.0f);
        }
    }

    public void updateLife(EntityPlayer e, ItemStack s) {
        if (e.func_110143_aJ() < 5.0f && !e.func_82165_m(Potion.field_76428_l.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -200) || this.setMRU(s, -200))) {
            e.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 50, 1));
            e.field_70170_p.func_72956_a((Entity)e, "random.orb", 1.0f, 10.0f);
        }
        if (e.func_110143_aJ() < 20.0f && !e.func_82165_m(Potion.field_76428_l.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -50) || this.setMRU(s, -50))) {
            e.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 50, 0));
            e.field_70170_p.func_72956_a((Entity)e, "random.orb", 1.0f, 10.0f);
        }
    }

    public void updateRain(EntityPlayer e, ItemStack s) {
        if (e.field_70170_p.func_72896_J() && !e.func_82165_m(Potion.field_76422_e.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -50) || this.setMRU(s, -50))) {
            e.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 100, 0));
            e.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 100, 2));
            e.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 100, 0));
            e.field_70170_p.func_72956_a((Entity)e, "liquid.splash", 1.0f, 1.0f);
        }
    }

    public void updateDust(EntityPlayer e, ItemStack s) {
        Material m = e.field_70170_p.func_147439_a((int)e.field_70165_t - 1, (int)e.field_70163_u - 1, (int)e.field_70161_v).func_149688_o();
        if (m == Material.field_151595_p && !e.func_82165_m(Potion.field_76429_m.field_76415_H) && (ECUtils.tryToDecreaseMRUInStorage(e, -100) || this.setMRU(s, -100))) {
            e.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 100, 0));
            e.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 0));
        }
    }

    public String getItemDisplayName(ItemStack par1ItemStack) {
        return "Charm Of " + this.name[par1ItemStack.func_77960_j()];
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

