/*
 * Decompiled with CFR 0.152.
 */
package ec3.api;

import ec3.api.ApiCore;
import ec3.api.PageEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DiscoveryEntry {
    public List<PageEntry> pages = new ArrayList<PageEntry>();
    public String id;
    public ItemStack displayStack;
    public List<ItemStack> referalItemStackLst = new ArrayList<ItemStack>();
    public String name;
    public String shortDescription;
    public ResourceLocation displayTexture;
    public boolean isNew = false;

    public DiscoveryEntry(String i) {
        this.id = i;
    }

    public DiscoveryEntry setName(String s) {
        this.name = s;
        return this;
    }

    public DiscoveryEntry setNew() {
        this.isNew = true;
        return this;
    }

    public DiscoveryEntry setDisplayStack(Object obj) {
        if (obj instanceof ItemStack) {
            this.displayStack = (ItemStack)obj;
        }
        if (obj instanceof Block) {
            this.displayStack = new ItemStack((Block)obj, 1, 0);
        }
        if (obj instanceof Item) {
            this.displayStack = new ItemStack((Item)obj, 1, 0);
        }
        if (obj instanceof ResourceLocation) {
            this.displayTexture = (ResourceLocation)obj;
        }
        return this;
    }

    public DiscoveryEntry setDesc(String s) {
        this.shortDescription = s;
        return this;
    }

    public DiscoveryEntry apendPage(PageEntry page) {
        this.pages.add(page);
        return this;
    }

    public DiscoveryEntry setReferal(ItemStack ... stk) {
        this.referalItemStackLst.addAll(Arrays.asList(stk));
        for (int i = 0; i < stk.length; ++i) {
            ItemStack is = stk[i];
            is.field_77994_a = 0;
            ApiCore.discoveriesByIS.put(is.toString(), this);
        }
        return this;
    }
}

