/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft.client;

import com.mia.craftstudio.minecraft.CraftStudioModelWrapper;
import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class CSClientModelWrapperVBO
extends CraftStudioModelWrapper {
    public Set<CraftStudioRendererVBO> topRenderers = new HashSet<CraftStudioRendererVBO>();
    protected Set<CraftStudioRendererVBO> renderers1st = new HashSet<CraftStudioRendererVBO>();
    protected Set<CraftStudioRendererVBO> renderers2nd = new HashSet<CraftStudioRendererVBO>();
    protected RenderingObject roDefault;
    protected int glTextureId = -1;
    protected boolean isPrecomputed = false;
    protected static final int nVertices = 30;
    protected static final int sizeStride = 8;
    protected static final int sizeFloat = 4;

    public CSClientModelWrapperVBO(ModelMetadata metadata) {
        super(metadata);
    }

    public int getGlTextureId() {
        if (this.glTextureId == -1) {
            this.glTextureId = TextureUtil.func_110996_a();
        }
        return this.glTextureId;
    }

    public void deleteGlTexture() {
        if (this.glTextureId != -1) {
            TextureUtil.func_147942_a((int)this.glTextureId);
            this.glTextureId = -1;
        }
    }

    public void bindGlTexture() {
        GL11.glBindTexture((int)3553, (int)this.getGlTextureId());
    }

    public void addRenderer(CraftStudioRendererVBO renderer) {
        this.topRenderers.add(renderer);
    }

    public void renderPlacement(EntityPlayer player, float partialTicks, boolean canPlace, int tx, int ty, int tz, int playerOrientation) {
        double px = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double py = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double pz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)tx - (float)px + 0.5f), (float)((float)ty - (float)py), (float)((float)tz - (float)pz + 0.5f));
        this.startOutlineRendering(3.0f, 1.0f, canPlace ? 1.0f : 0.0f, canPlace ? 1.0f : 0.0f, 0.5f);
        this.renderOutlineVBO(this.roDefault, 0.0625f, playerOrientation);
        this.stopOutlineRendering();
        GL11.glPopMatrix();
    }

    protected void renderOutline(RenderingObject obj, TileEntity tileentity, MovingObjectPosition target, float scale, int rot, double x, double y, double z, float f) {
        if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && target.field_72311_b == tileentity.field_145851_c && target.field_72312_c == tileentity.field_145848_d && target.field_72309_d == tileentity.field_145849_e) {
            GL11.glPushMatrix();
            this.startOutlineRendering(1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            this.renderOutlineVBO(obj, scale, rot);
            this.stopOutlineRendering();
            GL11.glPopMatrix();
        }
    }

    protected void activateTransparency() {
        GL11.glEnable((int)2977);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    protected void desactivateTransparency() {
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2977);
    }

    public void render(TileEntity tileentity, float scale, int rot, double x, double y, double z, float f) {
        if (!this.isPrecomputed) {
            for (CraftStudioRendererVBO renderer : this.topRenderers) {
                renderer.collectRenderers(tileentity, this.renderers1st, this.renderers2nd);
            }
            this.roDefault = new RenderingObject(this.generateVBOs(this.renderers1st, this.renderers2nd), new int[]{this.renderers1st.size(), this.renderers2nd.size()});
            this.isPrecomputed = true;
        }
        MovingObjectPosition target = Minecraft.func_71410_x().field_71476_x;
        if (tileentity != null && target != null && CSLibMod.displayOutline) {
            this.renderOutline(this.roDefault, tileentity, target, scale, rot, x, y, z, f);
        }
        this.renderWithVBO(this.roDefault, tileentity, scale, rot);
    }

    protected int[] generateVBOs(Set<CraftStudioRendererVBO> nodes1st, Set<CraftStudioRendererVBO> nodes2nd) {
        FloatBuffer qBuffer1st = BufferUtils.createFloatBuffer((int)(240 * nodes1st.size()));
        FloatBuffer qBuffer2nd = BufferUtils.createFloatBuffer((int)(240 * nodes2nd.size()));
        FloatBuffer outlineBuffer = BufferUtils.createFloatBuffer((int)(60 * (nodes1st.size() + nodes2nd.size())));
        for (CraftStudioRendererVBO renderer : nodes1st) {
            renderer.generateVBOTriangleStripInterleaved(qBuffer1st, 0);
            renderer.generateVBOLineStrip(outlineBuffer, 0);
        }
        for (CraftStudioRendererVBO renderer : nodes2nd) {
            renderer.generateVBOTriangleStripInterleaved(qBuffer2nd, 0);
            renderer.generateVBOLineStrip(outlineBuffer, 0);
        }
        qBuffer1st.flip();
        qBuffer2nd.flip();
        outlineBuffer.flip();
        int VBO1st = GL15.glGenBuffers();
        int VBO2nd = GL15.glGenBuffers();
        int VBOOutline = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)VBO1st);
        GL15.glBufferData((int)34962, (FloatBuffer)qBuffer1st, (int)35044);
        GL15.glBindBuffer((int)34962, (int)VBO2nd);
        GL15.glBufferData((int)34962, (FloatBuffer)qBuffer2nd, (int)35044);
        GL15.glBindBuffer((int)34962, (int)VBOOutline);
        GL15.glBufferData((int)34962, (FloatBuffer)outlineBuffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        return new int[]{VBO1st, VBO2nd, VBOOutline};
    }

    protected void renderWithVBO(RenderingObject obj, TileEntity entity, float scale, int rot) {
        this.bindGlTexture();
        GL11.glPushMatrix();
        float rotation = (float)(rot * 360) / 16.0f;
        GL11.glRotatef((float)rotation, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        int[] vbos = obj.getVBOs();
        int[] sizes = obj.getSizes();
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32885);
        GL15.glBindBuffer((int)34962, (int)vbos[0]);
        GL11.glVertexPointer((int)3, (int)5126, (int)32, (long)0L);
        GL11.glNormalPointer((int)5126, (int)32, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)24L);
        GL11.glDrawArrays((int)5, (int)0, (int)(30 * sizes[0]));
        if (sizes[1] > 0) {
            this.activateTransparency();
            GL15.glBindBuffer((int)34962, (int)vbos[1]);
            GL11.glVertexPointer((int)3, (int)5126, (int)32, (long)0L);
            GL11.glNormalPointer((int)5126, (int)32, (long)12L);
            GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)24L);
            GL11.glDrawArrays((int)5, (int)0, (int)(30 * sizes[1]));
            this.desactivateTransparency();
        }
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glDisableClientState((int)32885);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32884);
        GL11.glPopMatrix();
    }

    protected void renderOutlineVBO(RenderingObject obj, float scale, int rot) {
        float rotation = (float)(rot * 360) / 16.0f;
        GL11.glRotatef((float)rotation, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL15.glBindBuffer((int)34962, (int)obj.getVBOOut());
        GL11.glVertexPointer((int)3, (int)5126, (int)0, (long)0L);
        for (int i = 0; i < obj.getSizeOut() * 4; ++i) {
            GL11.glDrawArrays((int)3, (int)(i * 5), (int)5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void startOutlineRendering(float width, float r, float g, float b, float a) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)width);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glDisable((int)3553);
        GL11.glEnableClientState((int)32884);
    }

    @SideOnly(value=Side.CLIENT)
    protected void stopOutlineRendering() {
        GL11.glDisableClientState((int)32884);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    protected class RenderingObject {
        private final int[] vbos;
        private final int[] elems;

        public RenderingObject(int[] vbos, int[] sizes) {
            this.vbos = vbos;
            this.elems = sizes;
        }

        public int[] getVBOs() {
            return this.vbos;
        }

        public int getVBO1st() {
            return this.vbos[0];
        }

        public int getVBO2nd() {
            return this.vbos[1];
        }

        public int getVBOOut() {
            return this.vbos[2];
        }

        public int[] getSizes() {
            return this.elems;
        }

        public int getSize1st() {
            return this.elems[0];
        }

        public int getSize2nd() {
            return this.elems[1];
        }

        public int getSizeOut() {
            return this.elems[0] + this.elems[1];
        }
    }
}

