/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.tileentity.turrets;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmodularturrets.entity.projectiles.TurretProjectile;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.tileentity.turretbase.TurretBase;
import openmodularturrets.util.TurretHeadUtil;

public abstract class TurretHead
extends TileEntity {
    public int ticks;
    public int targetingTicks;
    public float rotationXY;
    public float rotationXZ;
    public float baseFitRotationX;
    public float baseFitRotationZ;
    public int turretTier;
    public TurretBase base;
    public boolean hasSetSide = false;
    public Entity target = null;
    public float rotationAnimation = 0.0f;
    public boolean shouldConceal = false;
    public boolean playedDeploy = false;
    public int ticksWithoutTarget;

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound var1 = pkt.func_148857_g();
        this.func_145839_a(var1);
    }

    public void func_145841_b(NBTTagCompound par1) {
        par1.func_74776_a("rotationXY", this.rotationXY);
        par1.func_74776_a("rotationXZ", this.rotationXZ);
        par1.func_74768_a("ticksBeforeFire", this.ticks);
        par1.func_74757_a("shouldConceal", this.shouldConceal);
        super.func_145841_b(par1);
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.rotationXY = par1.func_74760_g("rotationXY");
        this.rotationXZ = par1.func_74760_g("rotationXZ");
        this.shouldConceal = par1.func_74767_n("shouldConceal");
    }

    public void setSide() {
        if (this.hasSetSide) {
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 1.565f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 4.705f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 3.145f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 0.0f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TurretBase) {
            this.baseFitRotationX = 3.145f;
            this.baseFitRotationZ = 0.0f;
            this.hasSetSide = true;
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TurretBase) {
            this.baseFitRotationX = 0.0f;
            this.baseFitRotationZ = 0.0f;
            this.hasSetSide = true;
        }
    }

    public Entity getTargetWithMinRange() {
        return TurretHeadUtil.getTargetWithMinimumRange(this.base, this.field_145850_b, this.base.getyAxisDetect(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this);
    }

    public Entity getTargetWithoutEffect() {
        return TurretHeadUtil.getTargetWithoutSlowEffect(this.base, this.field_145850_b, this.base.getyAxisDetect(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this);
    }

    public Entity getTarget() {
        return TurretHeadUtil.getTarget(this.base, this.field_145850_b, this.base.getyAxisDetect(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(this.base), this);
    }

    public abstract int getTurretRange();

    public TurretBase getBase() {
        return TurretHeadUtil.getTurretBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public float getRotationXY() {
        return this.rotationXY;
    }

    public void setRotationXY(float rotationXY) {
        this.rotationXY = rotationXY;
    }

    public float getRotationXZ() {
        return this.rotationXZ;
    }

    public void setRotationXZ(float rotationXZ) {
        this.rotationXZ = rotationXZ;
    }

    public float getDistanceToEntity(Entity p_70032_1_) {
        float f = (float)((double)this.field_145851_c - p_70032_1_.field_70165_t);
        float f1 = (float)((double)this.field_145848_d - p_70032_1_.field_70163_u);
        float f2 = (float)((double)this.field_145849_e - p_70032_1_.field_70161_v);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public abstract int getTurretPowerUsage();

    public abstract int getTurretFireRate();

    public abstract double getTurretAccuracy();

    public abstract boolean requiresAmmo();

    public abstract boolean requiresSpecificAmmo();

    public abstract Item getAmmo();

    public abstract TurretProjectile createProjectile(World var1, Entity var2, ItemStack var3);

    public abstract String getLaunchSoundEffect();

    public boolean chebyshevDistance(Entity target, TurretBase base) {
        return MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(target.field_70165_t - (double)this.field_145851_c), (double)(target.field_70163_u - (double)this.field_145848_d)), (double)(target.field_70161_v - (double)this.field_145849_e)) > (double)(this.getTurretRange() + TurretHeadUtil.getRangeUpgrades(base));
    }

    public void func_145845_h() {
        this.setSide();
        this.base = this.getBase();
        if (this.field_145850_b.field_72995_K) {
            if (this.rotationAnimation >= 360.0f) {
                this.rotationAnimation = 0.0f;
            }
            this.rotationAnimation += 0.03f;
            return;
        }
        if (this.ticks % 5 == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        ++this.ticks;
        if (this.base == null || this.base.getBaseTier() < this.turretTier) {
            this.func_145831_w().func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
        } else {
            int i;
            EntityPlayerMP entity;
            if (this.base.isAttacksPlayers()) {
                TurretHeadUtil.warnPlayers(this.base, this.base.func_145831_w(), this.base.getyAxisDetect(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTurretRange());
            }
            TurretHeadUtil.updateSolarPanelAddon(this.base);
            this.concealmentChecks();
            if (this.target == null && this.targetingTicks < ConfigHandler.getTurretTargetSearchTicks()) {
                ++this.targetingTicks;
                return;
            }
            this.targetingTicks = 0;
            int power_required = Math.round((float)this.getTurretPowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
            if (this.base.getEnergyStored(ForgeDirection.UNKNOWN) < power_required || !this.base.isActive()) {
                return;
            }
            if (this.target == null || this.target.field_70128_L || this.func_145831_w().func_73045_a(this.target.func_145782_y()) == null || ((EntityLivingBase)this.target).func_110143_aJ() <= 0.0f) {
                this.target = this.getTarget();
            }
            if (this.target == null) {
                return;
            }
            this.rotationXZ = TurretHeadUtil.getAimYaw(this.target, this.field_145851_c, this.field_145848_d, this.field_145849_e) + 3.2f;
            this.rotationXY = TurretHeadUtil.getAimPitch(this.target, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if ((float)this.ticks < (float)this.getTurretFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base))) {
                return;
            }
            if (this.target != null && !TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target)) {
                this.target = null;
                return;
            }
            if (this.target != null && this.target instanceof EntityPlayerMP && (TurretHeadUtil.isTrustedPlayer((entity = (EntityPlayerMP)this.target).func_110124_au(), this.base) || entity.field_71075_bZ.field_75098_d || !this.base.isAttacksPlayers())) {
                this.target = null;
                return;
            }
            if (this.target != null && this.chebyshevDistance(this.target, this.base)) {
                this.target = null;
                return;
            }
            ItemStack ammo = null;
            if (this.requiresAmmo()) {
                if (this.requiresSpecificAmmo()) {
                    for (i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                        ammo = TurretHeadUtil.useSpecificItemStackItemFromBase(this.base, this.getAmmo());
                        if (ammo != null) continue;
                        ammo = TurretHeadUtil.getSpecificItemFromInvExpanders(this.field_145850_b, new ItemStack(this.getAmmo()), this.base);
                    }
                } else {
                    ammo = TurretHeadUtil.useAnyItemStackFromBase(this.base);
                    if (ammo == null) {
                        ammo = TurretHeadUtil.getAnyItemFromInvExpanders(this.field_145850_b, this.base);
                    }
                }
                if (ammo == null) {
                    return;
                }
            }
            this.base.setEnergyStored(this.base.getEnergyStored(ForgeDirection.UNKNOWN) - power_required);
            for (i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                TurretProjectile projectile = this.createProjectile(this.func_145831_w(), this.target, ammo);
                projectile.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                Random random = new Random();
                projectile.amp_level = TurretHeadUtil.getAmpLevel(this.base);
                if (projectile.amp_level != 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "openmodularturrets:amped", ConfigHandler.getTurretSoundVolume(), random.nextFloat() + 0.5f);
                    projectile.isAmped = true;
                }
                double d0 = this.target.field_70165_t - projectile.field_70165_t;
                double d1 = this.target.field_70163_u + (double)this.target.func_70047_e() - projectile.field_70163_u;
                double d2 = this.target.field_70161_v - projectile.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f1 = (float)dist * (0.2f * (this.getDistanceToEntity(this.target) * 0.04f));
                double accuraccy = this.getTurretAccuracy() * (double)(1.0f - TurretHeadUtil.getAccuraccyUpgrades(this.base)) * (double)(1 + TurretHeadUtil.getScattershotUpgrades(this.base));
                double time = dist / (projectile.gravity == 0.0f ? 3.0 : 1.6);
                if (projectile.gravity == 0.0f) {
                    projectile.func_70186_c(d0 + this.target.field_70159_w * time, d1 + this.target.field_70181_x, d2 + this.target.field_70179_y * time, 3.0f, (float)accuraccy);
                } else {
                    projectile.func_70186_c(d0 + this.target.field_70159_w * time, d1 + (double)f1 + this.target.field_70181_x, d2 + this.target.field_70179_y * time, 1.6f, (float)accuraccy);
                }
                this.func_145831_w().func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "openmodularturrets:" + this.getLaunchSoundEffect(), ConfigHandler.getTurretSoundVolume(), random.nextFloat() + 0.5f);
                this.func_145831_w().func_72838_d((Entity)projectile);
            }
            this.ticks = 0;
        }
    }

    public void concealmentChecks() {
        if (this.base != null && this.base.shouldConcealTurrets) {
            if (!this.shouldConceal && this.target == null && this.ticksWithoutTarget >= 40) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = true;
                this.playedDeploy = false;
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "openmodularturrets:turretRetract", ConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
                this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                ++this.ticksWithoutTarget;
            }
            if (this.base != null && this.target != null) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = false;
                if (!this.playedDeploy) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "openmodularturrets:turretDeploy", ConfigHandler.getTurretSoundVolume(), new Random().nextFloat() + 0.5f);
                    this.playedDeploy = true;
                    this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
                }
            }
        } else {
            this.shouldConceal = false;
            this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 1.0f, 0.8f);
        }
    }
}

