/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.tileentity.turrets;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmodularturrets.blocks.turretheads.BlockTeleporterTurret;
import openmodularturrets.entity.projectiles.TurretProjectile;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.tileentity.turrets.TurretHead;
import openmodularturrets.util.TurretHeadUtil;

public class TeleporterTurretTileEntity
extends TurretHead {
    public TeleporterTurretTileEntity() {
        this.turretTier = 4;
    }

    @Override
    public void func_145845_h() {
        this.setSide();
        this.base = this.getBase();
        if (this.field_145850_b.field_72995_K) {
            if (this.rotationAnimation >= 360.0f) {
                this.rotationAnimation = 0.0f;
            }
            this.rotationAnimation += 0.03f;
            return;
        }
        if (this.ticks % 5 == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        ++this.ticks;
        if (this.base == null || this.base.getBaseTier() < this.turretTier) {
            this.func_145831_w().func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
        } else {
            EntityPlayerMP entity;
            this.concealmentChecks();
            TurretHeadUtil.updateSolarPanelAddon(this.base);
            if (this.target == null && this.targetingTicks < ConfigHandler.getTurretTargetSearchTicks()) {
                ++this.targetingTicks;
                return;
            }
            this.targetingTicks = 0;
            int power_required = Math.round((float)this.getTurretPowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
            if (this.base.getEnergyStored(ForgeDirection.UNKNOWN) < power_required || !this.base.isActive()) {
                return;
            }
            if (this.target == null || this.target.field_70128_L || this.func_145831_w().func_73045_a(this.target.func_145782_y()) == null || ((EntityLivingBase)this.target).func_110143_aJ() <= 0.0f) {
                this.target = this.getTargetWithMinRange();
            }
            if (this.target == null) {
                return;
            }
            this.rotationXZ = TurretHeadUtil.getAimYaw(this.target, this.field_145851_c, this.field_145848_d, this.field_145849_e) + 3.2f;
            this.rotationXY = TurretHeadUtil.getAimPitch(this.target, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if ((float)this.ticks < (float)this.getTurretFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(this.base))) {
                return;
            }
            if (this.target != null && !TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target)) {
                this.target = null;
                return;
            }
            if (this.target != null && this.target instanceof EntityPlayerMP && TurretHeadUtil.isTrustedPlayer((entity = (EntityPlayerMP)this.target).func_110124_au(), this.base)) {
                this.target = null;
                return;
            }
            if (this.target != null && this.chebyshevDistance(this.target, this.base)) {
                this.target = null;
                return;
            }
            ItemStack ammo = null;
            if (this.requiresAmmo()) {
                if (this.requiresSpecificAmmo()) {
                    for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                        ammo = TurretHeadUtil.useSpecificItemStackItemFromBase(this.base, this.getAmmo());
                    }
                } else {
                    ammo = TurretHeadUtil.useAnyItemStackFromBase(this.base);
                }
                if (ammo == null) {
                    return;
                }
            }
            this.base.setEnergyStored(this.base.getEnergyStored(ForgeDirection.UNKNOWN) - power_required);
            EntityLivingBase base = (EntityLivingBase)this.target;
            base.func_70634_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.0f), (double)((float)this.field_145849_e + 0.5f));
            ((BlockTeleporterTurret)this.field_145850_b.func_147439_a((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)).shouldAnimate = true;
            this.target = null;
        }
        this.func_145831_w().func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "openmodularturrets:" + this.getLaunchSoundEffect(), 0.6f, 1.0f);
        this.ticks = 0;
    }

    @Override
    public int getTurretRange() {
        return ConfigHandler.getTeleporter_turret().getRange();
    }

    @Override
    public int getTurretPowerUsage() {
        return ConfigHandler.getTeleporter_turret().getPowerUsage();
    }

    @Override
    public int getTurretFireRate() {
        return ConfigHandler.getTeleporter_turret().getFireRate();
    }

    @Override
    public double getTurretAccuracy() {
        return ConfigHandler.getTeleporter_turret().getAccuracy();
    }

    @Override
    public boolean requiresAmmo() {
        return false;
    }

    @Override
    public boolean requiresSpecificAmmo() {
        return false;
    }

    @Override
    public Item getAmmo() {
        return null;
    }

    @Override
    public TurretProjectile createProjectile(World world, Entity target, ItemStack ammo) {
        return null;
    }

    @Override
    public String getLaunchSoundEffect() {
        return "teleport";
    }
}

