/*
 * Decompiled with CFR 0.152.
 */
package latmod.xpt;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import latmod.xpt.ItemXPT;
import latmod.xpt.Teleporter;
import latmod.xpt.XPT;
import latmod.xpt.XPTConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;

public class TileXPT
extends TileEntity {
    public int linkedX;
    public int linkedY;
    public int linkedZ;
    public int linkedDim;
    public int cooldown;
    public int maxCooldown;
    public String name = "";
    private boolean created = false;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Link") && tag.func_74764_b("Timer")) {
            int[] link = tag.func_74759_k("Link");
            int[] cd = tag.func_74759_k("Timer");
            this.linkedX = link[0];
            this.linkedY = link[1];
            this.linkedZ = link[2];
            this.linkedDim = link[3];
            this.cooldown = cd[0];
            this.maxCooldown = cd[1];
        } else {
            this.linkedX = tag.func_74762_e("LinkX");
            this.linkedY = tag.func_74762_e("LinkY");
            this.linkedZ = tag.func_74762_e("LinkZ");
            this.linkedDim = tag.func_74762_e("LinkDim");
            this.cooldown = tag.func_74762_e("Cooldown");
            this.maxCooldown = tag.func_74762_e("MaxCooldown");
        }
        this.name = tag.func_74779_i("Name");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74783_a("Link", new int[]{this.linkedX, this.linkedY, this.linkedZ, this.linkedDim});
        tag.func_74783_a("Timer", new int[]{this.cooldown, this.maxCooldown});
        tag.func_74778_a("Name", this.name);
    }

    public final Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("D", new int[]{this.linkedX, this.linkedY, this.linkedZ, this.linkedDim, this.cooldown, this.maxCooldown});
        tag.func_74778_a("N", this.name);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        int[] data = tag.func_74759_k("D");
        this.linkedX = data[0];
        this.linkedY = data[1];
        this.linkedZ = data[2];
        this.linkedDim = data[3];
        this.cooldown = data[4];
        this.maxCooldown = data[5];
        this.name = tag.func_74779_i("N");
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getDim() {
        return this.field_145850_b == null ? 0 : this.field_145850_b.field_73011_w.field_76574_g;
    }

    public int getIconID() {
        if (this.field_145850_b != null && this.linkedY > 0) {
            return this.linkedDim == this.getDim() ? 1 : 2;
        }
        return 0;
    }

    public void func_70296_d() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isServer() {
        return !this.field_145850_b.field_72995_K;
    }

    public void func_145845_h() {
        if (this.cooldown < 0) {
            this.cooldown = 0;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            if (this.cooldown == 0 && this.isServer()) {
                this.func_70296_d();
            }
        }
        if (!this.created && this.isServer()) {
            this.created = true;
            this.func_70296_d();
        }
    }

    public void onRightClick(EntityPlayer ep, ItemStack is) {
        if (this.field_145850_b.field_72995_K || is == null) {
            return;
        }
        if (is.func_77973_b() == Items.field_151057_cb) {
            if (!is.func_82837_s()) {
                return;
            }
            this.name = is.func_82833_r();
            if (!ep.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
            this.func_70296_d();
            return;
        }
        if (is.func_77973_b() != XPT.item) {
            return;
        }
        if (ItemXPT.hasData(is)) {
            int[] pos = is.func_77978_p().func_74759_k("Coords");
            int levels = 0;
            if (XPTConfig.only_linking_uses_xp) {
                boolean crossdim;
                boolean bl = crossdim = pos[3] != this.getDim();
                if (crossdim) {
                    levels = XPTConfig.levels_for_crossdim;
                } else {
                    double dist = Math.sqrt(this.func_145835_a((double)pos[0] + 0.5, (double)pos[1] + 0.5, (double)pos[2] + 0.5));
                    int n = levels = XPTConfig.levels_for_1000_blocks > 0 ? MathHelper.func_76143_f((double)((double)XPTConfig.levels_for_1000_blocks * dist / 1000.0)) : 0;
                }
                if (!ep.field_71075_bZ.field_75098_d && this.canTeleport(ep, levels)) {
                    ep.func_145747_a((IChatComponent)new ChatComponentText("You need level " + levels + " to link teleporters"));
                    return;
                }
            }
            if (this.createLink(pos[0], pos[1], pos[2], pos[3], true)) {
                --is.field_77994_a;
                this.consumeLevels(ep, levels);
                ep.func_145747_a((IChatComponent)new ChatComponentText((this.linkedDim == this.getDim() ? "Intra" : "Extra") + "-dimensional link created!"));
            } else {
                ep.func_145747_a((IChatComponent)new ChatComponentText("Can't create a link!"));
            }
        } else if (this.field_145848_d > 0) {
            if (is.field_77994_a > 1) {
                if (!ep.field_71075_bZ.field_75098_d) {
                    --is.field_77994_a;
                }
                ItemStack is1 = new ItemStack((Item)XPT.item);
                is1.func_77982_d(new NBTTagCompound());
                is1.func_77978_p().func_74783_a("Coords", new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g});
                if (ep.field_71071_by.func_70441_a(is1)) {
                    ep.field_71070_bA.func_75142_b();
                } else {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, is1));
                }
            } else {
                is.func_77982_d(new NBTTagCompound());
                is.func_77978_p().func_74783_a("Coords", new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g});
            }
        }
    }

    public boolean createLink(int x, int y, int z, int dim, boolean updateLink) {
        if (!this.isServer()) {
            return false;
        }
        if (x == this.linkedX && y == this.linkedY && z == this.linkedZ && dim == this.linkedDim) {
            return false;
        }
        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e && dim == this.getDim()) {
            return false;
        }
        TileXPT t = this.getLinkedTile();
        if (t != null) {
            t.linkedY = 0;
            t.func_70296_d();
        }
        this.linkedX = x;
        this.linkedY = y;
        this.linkedZ = z;
        this.linkedDim = dim;
        if (updateLink && (t = this.getLinkedTile()) != null) {
            t.createLink(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getDim(), false);
        }
        this.func_70296_d();
        return true;
    }

    public TileXPT getLinkedTile() {
        TileEntity te;
        WorldServer w = DimensionManager.getWorld((int)this.linkedDim);
        if (w != null && (te = w.func_147438_o(this.linkedX, this.linkedY, this.linkedZ)) != null && !te.func_145837_r() && te instanceof TileXPT) {
            return (TileXPT)te;
        }
        return null;
    }

    public void onPlayerCollided(EntityPlayer ep) {
        if (this.isServer() && this.cooldown <= 0 && ep.func_70093_af() && ep instanceof EntityPlayerMP && !(ep instanceof FakePlayer)) {
            ep.func_70095_a(false);
            TileXPT t = this.getLinkedTile();
            if (t != null && (t.linkedY <= 0 || this.equals((Object)t.getLinkedTile()))) {
                if (t.linkedY <= 0) {
                    t.createLink(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getDim(), false);
                }
                boolean crossdim = this.linkedDim != this.getDim();
                double dist = crossdim ? 0.0 : Math.sqrt(this.func_145835_a((double)t.field_145851_c + 0.5, (double)t.field_145848_d + 0.5, (double)t.field_145849_e + 0.5));
                int levels = 0;
                if (!XPTConfig.only_linking_uses_xp) {
                    levels = XPTConfig.levels_for_crossdim;
                    if (!crossdim) {
                        int n = levels = XPTConfig.levels_for_1000_blocks > 0 ? MathHelper.func_76143_f((double)((double)XPTConfig.levels_for_1000_blocks * dist / 1000.0)) : 0;
                    }
                }
                if (!ep.field_71075_bZ.field_75098_d && !this.canTeleport(ep, levels)) {
                    ep.func_145747_a((IChatComponent)new ChatComponentText("You need level " + levels + " to teleport"));
                    return;
                }
                if (Teleporter.travelEntity((Entity)ep, (double)this.linkedX + 0.5, (double)this.linkedY + 0.3, (double)this.linkedZ + 0.5, this.linkedDim)) {
                    if (levels > 0 && !ep.field_71075_bZ.field_75098_d) {
                        this.consumeLevels(ep, levels);
                    }
                    t.cooldown = t.maxCooldown = XPTConfig.cooldown_seconds * 20;
                    this.maxCooldown = t.maxCooldown;
                    this.cooldown = t.maxCooldown;
                    ep.field_70181_x = 0.05;
                    ep.func_145747_a((IChatComponent)new ChatComponentText("Used teleport '" + (this.name.isEmpty() ? this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + " @ " + this.field_145850_b.field_73011_w.func_80007_l() : this.name) + "'"));
                    this.func_70296_d();
                    t.func_70296_d();
                }
            } else {
                ep.func_145747_a((IChatComponent)new ChatComponentText("Link broken!"));
                if (t != null) {
                    this.linkedY = 0;
                    this.func_70296_d();
                }
            }
        }
    }

    private boolean canTeleport(EntityPlayer ep, int levels) {
        if (levels <= 0) {
            return true;
        }
        if (XPTConfig.use_food_levels == 0) {
            return ep.field_71068_ca >= levels;
        }
        int foodLevels = ep.func_71024_bL().func_75116_a();
        return foodLevels > 0 && (XPTConfig.use_food_levels == 1 || foodLevels >= Math.min(levels, 20));
    }

    private void consumeLevels(EntityPlayer ep, int levels) {
        if (levels <= 0) {
            return;
        }
        if (XPTConfig.use_food_levels == 0) {
            ep.func_82242_a(-levels);
        } else {
            ep.func_71024_bL().func_75122_a(-Math.min(ep.func_71024_bL().func_75116_a(), Math.min(20, levels)), 0.0f);
        }
    }

    public void onPlacedBy(EntityPlayer el, ItemStack is) {
        if (is.func_82837_s()) {
            this.name = is.func_82833_r();
        }
        this.func_70296_d();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != TileXPT.class) {
            return false;
        }
        TileXPT t = (TileXPT)((Object)o);
        if (t.field_145851_c != this.field_145851_c) {
            return false;
        }
        if (t.field_145848_d != this.field_145848_d) {
            return false;
        }
        if (t.field_145849_e != this.field_145849_e) {
            return false;
        }
        return t.getDim() == this.getDim();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        double d = 0.5;
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - d), (double)this.field_145848_d, (double)((double)this.field_145849_e - d), (double)((double)this.field_145851_c + 1.0 + d), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.0 + d));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 64.0;
    }

    public void onBroken() {
        if (XPTConfig.unlink_broken) {
            this.createLink(0, 0, 0, 0, true);
        }
    }
}

