/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.inventory.IDrawerInventory;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockCoord;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntitySlave
extends TileEntity
implements IDrawerGroup,
ISidedInventory {
    private BlockCoord controllerCoord;
    private BlockCoord selfCoord;
    private int[] inventorySlots = new int[]{0};

    public void ensureInitialized() {
        if (this.selfCoord == null) {
            this.selfCoord = new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.selfCoord = new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (tag.func_150297_b("Controller", 10)) {
            NBTTagCompound ctag = tag.func_74775_l("Controller");
            this.controllerCoord = new BlockCoord(ctag.func_74762_e("x"), ctag.func_74762_e("y"), ctag.func_74762_e("z"));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.controllerCoord != null) {
            NBTTagCompound ctag = new NBTTagCompound();
            ctag.func_74768_a("x", this.controllerCoord.x());
            ctag.func_74768_a("y", this.controllerCoord.y());
            ctag.func_74768_a("z", this.controllerCoord.z());
            tag.func_74782_a("Controller", (NBTBase)ctag);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void bindController(int x, int y, int z) {
        if (this.controllerCoord != null && this.controllerCoord.x() == x && this.controllerCoord.y() == y && this.controllerCoord.z() == z) {
            return;
        }
        this.controllerCoord = new BlockCoord(x, y, z);
        this.func_70296_d();
    }

    public TileEntityController getController() {
        if (this.controllerCoord == null) {
            return null;
        }
        this.ensureInitialized();
        TileEntity te = this.field_145850_b.func_147438_o(this.controllerCoord.x(), this.controllerCoord.y(), this.controllerCoord.z());
        if (!(te instanceof TileEntityController)) {
            this.controllerCoord = null;
            this.func_70296_d();
            return null;
        }
        return (TileEntityController)te;
    }

    public int[] func_94128_d(int side) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return this.inventorySlots;
        }
        return controller.func_94128_d(0);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.func_102007_a(slot, stack, 0);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.func_102008_b(slot, stack, side);
    }

    public int func_70302_i_() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return 1;
        }
        return controller.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.func_70298_a(slot, count);
    }

    public ItemStack func_70304_b(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return;
        }
        controller.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return "storageDrawers.container.unboundSlave";
        }
        return controller.func_145825_b();
    }

    public boolean func_145818_k_() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.func_145818_k_();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.func_94041_b(slot, stack);
    }

    @Override
    public int getDrawerCount() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return 0;
        }
        return controller.getDrawerCount();
    }

    @Override
    public IDrawer getDrawer(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.getDrawer(slot);
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return false;
        }
        return controller.isDrawerEnabled(slot);
    }

    @Override
    public IDrawerInventory getDrawerInventory() {
        TileEntityController controller = this.getController();
        if (controller == null || !controller.isValidSlave(this.selfCoord)) {
            return null;
        }
        return controller.getDrawerInventory();
    }

    public void func_70296_d() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.selfCoord)) {
            controller.func_70296_d();
        }
        super.func_70296_d();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        TileEntityController controller = this.getController();
        if (controller != null && controller.isValidSlave(this.selfCoord)) {
            return controller.markDirtyIfNeeded();
        }
        return false;
    }
}

