/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import com.jaquadro.minecraft.storagedrawers.network.BlockClickMessage;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockWood;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Level;

public class BlockDrawers
extends BlockContainer
implements IExtendedBlockClickHandler,
INetworked {
    private static final ResourceLocation blockConfig = new ResourceLocation("StorageDrawers:textures/blocks/block_config.mcmeta");
    public final boolean halfDepth;
    public final int drawerCount;
    public float trimWidth = 0.0625f;
    public float trimDepth = 0.0625f;
    public float indStart = 0.0f;
    public float indEnd = 0.0f;
    public int indSteps = 0;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSide;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSideV;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSideH;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront1;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront2;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront4;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconTrim;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlay;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayV;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayH;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayTrim;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator2;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator4;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconLock;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconVoid;

    public BlockDrawers(String blockName, int drawerCount, boolean halfDepth) {
        this(Material.field_151575_d, blockName, drawerCount, halfDepth);
    }

    protected BlockDrawers(Material material, String blockName, int drawerCount, boolean halfDepth) {
        super(material);
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.field_149783_u = true;
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
        this.func_149713_g(255);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return StorageDrawers.proxy.drawersRenderID;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityDrawers tile = this.getTileEntity(blockAccess, x, y, z);
        if (tile == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        float depth = this.halfDepth ? 0.5f : 1.0f;
        switch (tile.getDirection()) {
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 1.0f - depth, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, depth);
                break;
            }
            case 4: {
                this.func_149676_a(1.0f - depth, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, depth, 1.0f, 1.0f);
            }
        }
    }

    public void func_149683_g() {
        if (this.halfDepth) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityDrawers tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.getDirection() > 1) {
            return;
        }
        int quadrant = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                tile.setDirection(2);
                break;
            }
            case 1: {
                tile.setDirection(5);
                break;
            }
            case 2: {
                tile.setDirection(3);
                break;
            }
            case 3: {
                tile.setDirection(4);
            }
        }
        if (itemStack.func_82837_s()) {
            tile.setInventoryName(itemStack.func_82833_r());
        }
        if (world.field_72995_K) {
            tile.func_145843_s();
            world.func_147471_g(x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"BlockDrawers.onBlockActivated", (Object[])new Object[0]);
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item.toString()), (Object[])new Object[0]);
        }
        if (item != null && item.func_77973_b() != null) {
            if (item.func_77973_b() == ModItems.upgrade || item.func_77973_b() == ModItems.upgradeStatus || item.func_77973_b() == ModItems.upgradeVoid) {
                if (!tileDrawers.addUpgrade(item)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("storagedrawers.msg.maxUpgrades", new Object[0]));
                    return false;
                }
                world.func_147471_g(x, y, z);
                if (player != null && !player.field_71075_bZ.field_75098_d && --item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.upgradeLock) {
                boolean locked = tileDrawers.isLocked(LockAttribute.LOCK_POPULATED);
                tileDrawers.setLocked(LockAttribute.LOCK_POPULATED, !locked);
                tileDrawers.setLocked(LockAttribute.LOCK_EMPTY, !locked);
                return true;
            }
            if (item.func_77973_b() == ModItems.shroudKey) {
                tileDrawers.setIsShrouded(!tileDrawers.isShrouded());
                return true;
            }
        } else if (item == null && player.func_70093_af() && StorageDrawers.config.cache.enableDrawerUI) {
            player.openGui((Object)StorageDrawers.instance, GuiHandler.drawersGuiID, world, x, y, z);
            return true;
        }
        if (tileDrawers.getDirection() != side) {
            return false;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        int countAdded = tileDrawers.interactPutItemsIntoSlot(slot, player);
        if (countAdded > 0) {
            world.func_147471_g(x, y, z);
        }
        return true;
    }

    protected int getDrawerSlot(int side, float hitX, float hitY, float hitZ) {
        if (this.drawerCount == 1) {
            return 0;
        }
        if (this.drawerCount == 2) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        return this.hitTop(hitY) ? 2 : 3;
    }

    protected boolean hitTop(float hitY) {
        return (double)hitY > 0.5;
    }

    protected boolean hitLeft(int side, float hitX, float hitZ) {
        switch (side) {
            case 2: {
                return (double)hitX > 0.5;
            }
            case 3: {
                return (double)hitX < 0.5;
            }
            case 4: {
                return (double)hitZ < 0.5;
            }
            case 5: {
                return (double)hitZ > 0.5;
            }
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            float hitX = (float)(posn.field_72307_f.field_72450_a - (double)posn.field_72311_b);
            float hitY = (float)(posn.field_72307_f.field_72448_b - (double)posn.field_72312_c);
            float hitZ = (float)(posn.field_72307_f.field_72449_c - (double)posn.field_72309_d);
            StorageDrawers.network.sendToServer((IMessage)new BlockClickMessage(x, y, z, posn.field_72310_e, hitX, hitY, hitZ, StorageDrawers.config.cache.invertShift));
            if (StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("BlockDrawers.onBlockClicked with " + posn.toString()), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ, boolean invertShift) {
        PlayerInteractEvent event;
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"IExtendedBlockClickHandler.onBlockClicked", (Object[])new Object[0]);
        }
        if (!player.field_71075_bZ.field_75098_d && (event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)world)).isCanceled()) {
            return;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        if (tileDrawers.getDirection() != side) {
            return;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        ItemStack item = null;
        item = player.func_70093_af() != invertShift ? tileDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : tileDrawers.takeItemsFromSlot(slot, 1);
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item.toString()), (Object[])new Object[0]);
        }
        if (item != null && item.field_77994_a > 0) {
            this.dropItemStack(world, x, y, z, player, item);
            world.func_147471_g(x, y, z);
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block blockUnder;
        if (this.halfDepth) {
            return false;
        }
        if (side == ForgeDirection.DOWN && ((blockUnder = world.func_147439_a(x, y - 1, z)) instanceof BlockChest || blockUnder instanceof BlockEnderChest)) {
            return false;
        }
        if (this.getTileEntity(world, x, y, z) == null) {
            return true;
        }
        return side.ordinal() != this.getTileEntity(world, x, y, z).getDirection();
    }

    private void dropItemStack(World world, int x, int y, int z, EntityPlayer player, ItemStack stack) {
        EntityItem entity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
        world.func_72838_d((Entity)entity);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K && player.field_71075_bZ.field_75098_d) {
            TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, x, y, z);
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            if (tile.getDirection() == posn.field_72310_e) {
                this.func_149699_a(world, x, y, z, player);
                return false;
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null) {
            int i;
            for (i = 0; i < tile.getUpgradeSlotCount(); ++i) {
                ItemStack stack = tile.getUpgrade(i);
                if (stack == null) continue;
                this.func_149642_a(world, x, y, z, stack);
            }
            for (i = 0; i < tile.getDrawerCount(); ++i) {
                ItemStack stack;
                if (!tile.isDrawerEnabled(i)) continue;
                IDrawer drawer = tile.getDrawer(i);
                while (drawer.getStoredItemCount() > 0 && (stack = tile.takeItemsFromSlot(i, drawer.getStoredItemStackSize())) != null && stack.field_77994_a != 0) {
                    this.dropStackInBatches(world, x, y, z, stack);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    private void dropStackInBatches(World world, int x, int y, int z, ItemStack stack) {
        Random rand = world.field_73012_v;
        float ex = rand.nextFloat() * 0.8f + 0.1f;
        float ey = rand.nextFloat() * 0.8f + 0.1f;
        float ez = rand.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int stackPartSize = rand.nextInt(21) + 10;
            if (stackPartSize > stack.field_77994_a) {
                stackPartSize = stack.field_77994_a;
            }
            stack.field_77994_a -= stackPartSize;
            EntityItem entity = new EntityItem(world, (double)((float)x + ex), (double)((float)y + ey), (double)((float)z + ez), new ItemStack(stack.func_77973_b(), stackPartSize, stack.func_77960_j()));
            float motionUnit = 0.05f;
            entity.field_70159_w = rand.nextGaussian() * (double)motionUnit;
            entity.field_70181_x = rand.nextGaussian() * (double)motionUnit + (double)0.2f;
            entity.field_70179_y = rand.nextGaussian() * (double)motionUnit;
            if (stack.func_77942_o()) {
                entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entity);
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileEntityDrawersStandard();
    }

    public TileEntityDrawers getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        return tile instanceof TileEntityDrawers ? (TileEntityDrawers)tile : null;
    }

    public TileEntityDrawers getTileEntitySafe(World world, int x, int y, int z) {
        TileEntityDrawers tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            tile = this.createNewTileEntity(world, world.func_72805_g(x, y, z));
            world.func_147455_a(x, y, z, (TileEntity)tile);
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntity tile = worldObj.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (tile instanceof TileEntityDrawers && ((TileEntityDrawers)tile).getDirection() == target.field_72310_e) {
            return true;
        }
        return super.addHitEffects(worldObj, target, effectRenderer);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        if (StorageDrawers.config.cache.creativeTabVanillaWoods) {
            for (int i = 1; i < BlockWood.field_150096_a.length; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        return this.iconTrim[meta %= this.iconTrim.length];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        meta %= this.iconSide.length;
        switch (side) {
            case 0: 
            case 1: {
                return this.halfDepth ? this.iconSideH[meta] : this.iconSide[meta];
            }
            case 2: 
            case 3: {
                return this.halfDepth ? this.iconSideV[meta] : this.iconSide[meta];
            }
            case 4: {
                switch (this.drawerCount) {
                    case 1: {
                        return this.iconFront1[meta];
                    }
                    case 2: {
                        return this.iconFront2[meta];
                    }
                    case 4: {
                        return this.iconFront4[meta];
                    }
                }
                return null;
            }
            case 5: {
                return this.iconSide[meta];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.getIcon(blockAccess, x, y, z, side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        if (level == 0) {
            return null;
        }
        return this.getIcon(blockAccess, x, y, z, side, level);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIconTrim(int level) {
        if (level == 0) {
            return null;
        }
        return this.iconOverlayTrim[level];
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        int meta = blockAccess.func_72805_g(x, y, z) % this.iconSide.length;
        TileEntityDrawers tile = this.getTileEntity(blockAccess, x, y, z);
        if (tile == null || side == tile.getDirection()) {
            if (this.drawerCount == 1) {
                return this.iconFront1[meta];
            }
            if (this.drawerCount == 2) {
                return this.iconFront2[meta];
            }
            return this.iconFront4[meta];
        }
        switch (side) {
            case 0: 
            case 1: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlayH[level] : this.iconSideH[meta];
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: {
                        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
                    }
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: {
                        return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
                    }
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
                    }
                }
            }
        }
        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIndicatorIcon(int drawerCount, boolean on) {
        int onIndex = on ? 1 : 0;
        switch (drawerCount) {
            case 1: {
                return this.iconIndicator1[onIndex];
            }
            case 2: {
                return this.iconIndicator2[onIndex];
            }
            case 4: {
                return this.iconIndicator4[onIndex];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getLockIcon() {
        return this.iconLock;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getVoidIcon() {
        return this.iconVoid;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String[] subtex = BlockWood.field_150096_a;
        this.iconSide = new IIcon[subtex.length];
        this.iconSideH = new IIcon[subtex.length];
        this.iconSideV = new IIcon[subtex.length];
        this.iconFront1 = new IIcon[subtex.length];
        this.iconFront2 = new IIcon[subtex.length];
        this.iconFront4 = new IIcon[subtex.length];
        this.iconTrim = new IIcon[subtex.length];
        for (int i = 0; i < subtex.length; ++i) {
            this.iconFront1[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_1");
            this.iconFront2[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_2");
            this.iconFront4[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_4");
            this.iconSide[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side");
            this.iconSideV[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side_v");
            this.iconSideH[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side_h");
            this.iconTrim[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_trim");
        }
        String[] overlays = new String[]{null, null, "iron", "gold", "obsidian", "diamond", "emerald"};
        this.iconOverlay = new IIcon[overlays.length];
        this.iconOverlayH = new IIcon[overlays.length];
        this.iconOverlayV = new IIcon[overlays.length];
        this.iconOverlayTrim = new IIcon[overlays.length];
        for (int i = 2; i < overlays.length; ++i) {
            this.iconOverlay[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i]);
            this.iconOverlayV[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_v");
            this.iconOverlayH[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_h");
            this.iconOverlayTrim[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_trim");
        }
        this.iconIndicator1 = new IIcon[2];
        this.iconIndicator2 = new IIcon[2];
        this.iconIndicator4 = new IIcon[2];
        this.iconIndicator1[0] = register.func_94245_a("StorageDrawers:indicator/indicator_1_off");
        this.iconIndicator1[1] = register.func_94245_a("StorageDrawers:indicator/indicator_1_on");
        this.iconIndicator2[0] = register.func_94245_a("StorageDrawers:indicator/indicator_2_off");
        this.iconIndicator2[1] = register.func_94245_a("StorageDrawers:indicator/indicator_2_on");
        this.iconIndicator4[0] = register.func_94245_a("StorageDrawers:indicator/indicator_4_off");
        this.iconIndicator4[1] = register.func_94245_a("StorageDrawers:indicator/indicator_4_on");
        this.iconLock = register.func_94245_a("StorageDrawers:indicator/lock_icon");
        this.iconVoid = register.func_94245_a("StorageDrawers:indicator/void_icon");
        this.loadBlockConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void loadBlockConfig() {
        try {
            BufferedReader reader;
            block8: {
                IResource configResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(blockConfig);
                reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(configResource.func_110527_b()));
                    JsonObject root = new JsonParser().parse((Reader)reader).getAsJsonObject();
                    JsonObject entry = root.getAsJsonObject(this.func_149739_a().substring(5));
                    if (entry == null) break block8;
                    if (entry.has("trimWidth")) {
                        this.trimWidth = entry.get("trimWidth").getAsFloat();
                    }
                    if (entry.has("trimDepth")) {
                        this.trimDepth = entry.get("trimDepth").getAsFloat();
                    }
                    if (entry.has("indStart")) {
                        this.indStart = entry.get("indStart").getAsFloat();
                    }
                    if (entry.has("indEnd")) {
                        this.indEnd = entry.get("indEnd").getAsFloat();
                    }
                    if (!entry.has("indSteps")) break block8;
                    this.indSteps = entry.get("indSteps").getAsInt();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

