/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.BluePower;
import com.bluepowermod.container.ContainerProjectTable;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.tile.TileBase;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileProjectTable
extends TileBase
implements IInventory,
IGuiButtonSensitive {
    private ItemStack[] inventory = new ItemStack[18];
    protected ItemStack[] craftingGrid = new ItemStack[9];
    public final IInventory craftResult = new InventoryCraftResult();
    private static Field stackListFieldInventoryCrafting;

    public InventoryCrafting getCraftingGrid(Container listener) {
        InventoryCrafting inventoryCrafting = new InventoryCrafting(listener, 3, 3){

            public void func_70299_a(int slot, ItemStack stack) {
                super.func_70299_a(slot, stack);
                TileProjectTable.this.updateCraftingGrid();
            }

            public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
                ItemStack stack = super.func_70298_a(p_70298_1_, p_70298_2_);
                TileProjectTable.this.updateCraftingGrid();
                return stack;
            }
        };
        if (stackListFieldInventoryCrafting == null) {
            stackListFieldInventoryCrafting = ReflectionHelper.findField(InventoryCrafting.class, (String[])new String[]{"field_70466_a", "stackList"});
        }
        try {
            stackListFieldInventoryCrafting.set(inventoryCrafting, this.craftingGrid);
            return inventoryCrafting;
        }
        catch (Exception e) {
            BluePower.log.error("This is about to go wrong, Project Table getCraftingGrid:");
            e.printStackTrace();
            return null;
        }
    }

    public InventoryCrafting getCraftingGrid() {
        return this.getCraftingGrid(new Container(){

            public boolean func_75145_c(EntityPlayer p_75145_1_) {
                return false;
            }
        });
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            drops.add(stack);
        }
        for (ItemStack stack : this.craftingGrid) {
            if (stack == null) continue;
            drops.add(stack);
        }
        return drops;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        NBTTagCompound tagCompound;
        int currentIndex;
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        tagList = new NBTTagList();
        for (currentIndex = 0; currentIndex < this.craftingGrid.length; ++currentIndex) {
            if (this.craftingGrid[currentIndex] == null) continue;
            tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.craftingGrid[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("CraftingGrid", (NBTBase)tagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        byte slot;
        NBTTagCompound tagCompound;
        int i;
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[18];
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            tagCompound = tagList.func_150305_b(i);
            slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        tagList = tag.func_150295_c("CraftingGrid", 10);
        this.craftingGrid = new ItemStack[9];
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            tagCompound = tagList.func_150305_b(i);
            slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.craftingGrid.length) continue;
            this.craftingGrid[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return i < this.inventory.length ? this.inventory[i] : this.craftResult.func_70301_a(0);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            this.func_70299_a(i, null);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        if (i < this.inventory.length) {
            this.inventory[i] = itemStack;
        } else {
            this.craftResult.func_70299_a(0, itemStack);
            this.craft();
        }
        this.updateCraftingGrid();
    }

    public String func_145825_b() {
        return BPBlocks.project_table.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        Container container = player.field_71070_bA;
        if (container instanceof ContainerProjectTable) {
            ((ContainerProjectTable)container).clearCraftingGrid();
        }
    }

    private void updateCraftingGrid() {
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.getCraftingGrid(), this.func_145831_w()));
    }

    private void craft() {
        for (int i = 0; i < this.craftingGrid.length; ++i) {
            ItemStack remainder;
            ItemStack itemstack2;
            ItemStack itemstack1 = this.craftingGrid[i];
            if (itemstack1 == null) continue;
            boolean pulledFromInventory = false;
            if (this.craftingGrid[i].field_77994_a == 1) {
                ItemStack stackFromTable = ContainerProjectTable.extractStackFromTable(this, this.craftingGrid[i], false);
                boolean bl = pulledFromInventory = stackFromTable != null;
            }
            if (!pulledFromInventory) {
                --this.craftingGrid[i].field_77994_a;
                if (this.craftingGrid[i].field_77994_a <= 0) {
                    this.craftingGrid[i] = null;
                }
            }
            if (!itemstack1.func_77973_b().hasContainerItem(itemstack1) || (itemstack2 = itemstack1.func_77973_b().getContainerItem(itemstack1)) != null && itemstack2.func_77984_f() && itemstack2.func_77960_j() > itemstack2.func_77958_k() || itemstack1.func_77973_b().func_77630_h(itemstack1) || (remainder = IOHelper.insert(this, itemstack2, 0, false)) == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, remainder));
        }
    }
}

