/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.tube;

import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.part.tube.MagTube;
import com.bluepowermod.part.tube.PartPlacementAccelerator;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.tube.TubeLogic;
import com.bluepowermod.part.tube.TubeStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartCustomPlacement;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class Accelerator
extends PneumaticTube
implements IPartCustomPlacement {
    private ForgeDirection rotation = ForgeDirection.UP;

    @Override
    public String getType() {
        return "accelerator";
    }

    @Override
    public String getUnlocalizedName() {
        return this.getType();
    }

    public void setRotation(ForgeDirection rotation) {
        this.rotation = rotation;
    }

    @Override
    public List<Vec3dCube> getOcclusionBoxes() {
        ArrayList<Vec3dCube> aabbs = new ArrayList<Vec3dCube>();
        if (this.rotation == ForgeDirection.DOWN || this.rotation == ForgeDirection.UP) {
            aabbs.add(new Vec3dCube(0.0, 0.25, 0.0, 1.0, 0.75, 1.0));
        } else if (this.rotation == ForgeDirection.NORTH || this.rotation == ForgeDirection.SOUTH) {
            aabbs.add(new Vec3dCube(0.0, 0.0, 0.25, 1.0, 1.0, 0.75));
        } else {
            aabbs.add(new Vec3dCube(0.25, 0.0, 0.0, 0.75, 1.0, 1.0));
        }
        return aabbs;
    }

    @Override
    public void update() {
        super.update();
        TubeLogic logic = this.getLogic();
        for (TubeStack stack : logic.tubeStacks) {
            PneumaticTube tube = this.getPartCache(stack.heading);
            if (tube instanceof MagTube && this.isPowered()) {
                stack.setSpeed(1.0);
                continue;
            }
            stack.setSpeed(0.0625);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("rotation", (byte)this.rotation.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.rotation = ForgeDirection.getOrientation((int)tag.func_74771_c("rotation"));
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.rotation.ordinal());
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.rotation = ForgeDirection.getOrientation((int)buffer.readInt());
    }

    @Override
    public boolean isConnected(ForgeDirection dir, PneumaticTube otherTube) {
        if (dir == this.rotation || dir.getOpposite() == this.rotation) {
            return this.getWorld() == null || !MultipartCompatibility.checkOcclusion((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (Vec3dCube)this.sideBB.clone().rotate(dir, Vec3d.center));
        }
        return false;
    }

    private boolean isPowered() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon() {
        return IconSupplier.pneumaticTubeSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-0.125, (double)0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.rotation = ForgeDirection.UP;
        this.renderDynamic(new Vec3d(0.0, 0.0, 0.0), 0.0, 0);
        GL11.glPopMatrix();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vec3d loc, double delta, int pass) {
        super.renderDynamic(loc, delta, pass);
        if (pass == 0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator t = Tessellator.field_78398_a;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)loc.getX() + 0.5f), (float)((float)loc.getY() + 0.5f), (float)((float)loc.getZ() + 0.5f));
            if (this.rotation == ForgeDirection.NORTH || this.rotation == ForgeDirection.SOUTH) {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            } else if (this.rotation == ForgeDirection.EAST || this.rotation == ForgeDirection.WEST) {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
            GL11.glTranslatef((float)((float)(-loc.getX()) - 0.5f), (float)((float)(-loc.getY()) - 0.5f), (float)((float)(-loc.getZ()) - 0.5f));
            t.func_78382_b();
            t.func_78386_a(1.0f, 1.0f, 1.0f);
            t.func_78372_c((float)loc.getX(), (float)loc.getY(), (float)loc.getZ());
            IIcon icon = this.isPowered() ? IconSupplier.acceleratorFrontPowered : IconSupplier.acceleratorFront;
            double minX = icon.func_94214_a(0.0);
            double maxX = icon.func_94214_a(16.0);
            double minY = icon.func_94207_b(0.0);
            double maxY = icon.func_94207_b(16.0);
            t.func_78375_b(0.0f, -1.0f, 0.0f);
            t.func_78374_a(0.0, 0.25, 0.0, maxX, maxY);
            t.func_78374_a(1.0, 0.25, 0.0, minX, maxY);
            t.func_78374_a(1.0, 0.25, 1.0, minX, minY);
            t.func_78374_a(0.0, 0.25, 1.0, maxX, minY);
            t.func_78375_b(0.0f, 1.0f, 1.0f);
            t.func_78374_a(0.0, 0.75, 0.0, maxX, maxY);
            t.func_78374_a(0.0, 0.75, 1.0, minX, maxY);
            t.func_78374_a(1.0, 0.75, 1.0, minX, minY);
            t.func_78374_a(1.0, 0.75, 0.0, maxX, minY);
            icon = this.isPowered() ? IconSupplier.acceleratorSidePowered : IconSupplier.acceleratorSide;
            minX = icon.func_94214_a(4.0);
            maxX = icon.func_94214_a(12.0);
            minY = icon.func_94207_b(0.0);
            maxY = icon.func_94207_b(16.0);
            t.func_78375_b(0.0f, 0.0f, 1.0f);
            t.func_78374_a(0.0, 0.25, 1.0, maxX, minY);
            t.func_78374_a(1.0, 0.25, 1.0, maxX, maxY);
            t.func_78374_a(1.0, 0.75, 1.0, minX, maxY);
            t.func_78374_a(0.0, 0.75, 1.0, minX, minY);
            t.func_78375_b(0.0f, 0.0f, -1.0f);
            t.func_78374_a(0.0, 0.25, 0.0, minX, maxY);
            t.func_78374_a(0.0, 0.75, 0.0, maxX, maxY);
            t.func_78374_a(1.0, 0.75, 0.0, maxX, minY);
            t.func_78374_a(1.0, 0.25, 0.0, minX, minY);
            t.func_78375_b(-1.0f, 0.0f, 0.0f);
            t.func_78374_a(0.0, 0.25, 0.0, maxX, minY);
            t.func_78374_a(0.0, 0.25, 1.0, maxX, maxY);
            t.func_78374_a(0.0, 0.75, 1.0, minX, maxY);
            t.func_78374_a(0.0, 0.75, 0.0, minX, minY);
            t.func_78375_b(1.0f, 0.0f, 0.0f);
            t.func_78374_a(1.0, 0.25, 0.0, maxX, maxY);
            t.func_78374_a(1.0, 0.75, 0.0, minX, maxY);
            t.func_78374_a(1.0, 0.75, 1.0, minX, minY);
            t.func_78374_a(1.0, 0.25, 1.0, maxX, minY);
            icon = IconSupplier.acceleratorInside;
            minX = icon.func_94214_a(4.0);
            maxX = icon.func_94214_a(12.0);
            minY = icon.func_94207_b(4.0);
            maxY = icon.func_94207_b(12.0);
            t.func_78374_a(0.0, 0.25, 0.375, minX, minY);
            t.func_78374_a(1.0, 0.25, 0.375, maxX, maxY);
            t.func_78374_a(1.0, 0.75, 0.375, maxX, maxY);
            t.func_78374_a(0.0, 0.75, 0.375, minX, minY);
            t.func_78374_a(0.0, 0.25, 0.625, minX, maxY);
            t.func_78374_a(0.0, 0.75, 0.625, minX, minY);
            t.func_78374_a(1.0, 0.75, 0.625, maxX, minY);
            t.func_78374_a(1.0, 0.25, 0.625, maxX, maxY);
            t.func_78374_a(0.625, 0.25, 0.0, minX, minY);
            t.func_78374_a(0.625, 0.25, 1.0, maxX, maxY);
            t.func_78374_a(0.625, 0.75, 1.0, maxX, maxY);
            t.func_78374_a(0.625, 0.75, 0.0, minX, minY);
            t.func_78374_a(0.375, 0.25, 0.0, minX, minY);
            t.func_78374_a(0.375, 0.75, 0.0, minX, maxY);
            t.func_78374_a(0.375, 0.75, 1.0, maxX, maxY);
            t.func_78374_a(0.375, 0.25, 1.0, maxX, minY);
            t.func_78372_c((float)(-loc.getX()), (float)(-loc.getY()), (float)(-loc.getZ()));
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    public IPartPlacement getPlacement(IPart part, World world, Vec3i location, ForgeDirection face, MovingObjectPosition mop, EntityPlayer player) {
        return new PartPlacementAccelerator(player);
    }

    @Override
    protected boolean shouldRenderFully() {
        return true;
    }
}

