/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import com.bluepowermod.util.Color;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.misc.ShiftingBuffer;
import uk.co.qmunity.lib.util.Dir;

public class GateAnd
extends GateSimpleDigital {
    private ShiftingBuffer<Boolean> buf = new ShiftingBuffer(5, 2, (Object)false);
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentTorch t3;
    private GateComponentTorch t4;
    private GateComponentWire wire;

    @Override
    protected String getGateType() {
        return "and";
    }

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.right()).enable();
        ((GateConnectionDigital)this.back()).enable();
        ((GateConnectionDigital)this.left()).enable();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 2186125, 0.25, true).setState(true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 255, 0.25, true).setState(true);
        this.addComponent(this.t2);
        this.t3 = new GateComponentTorch(this, 4101340, 0.25, true).setState(true);
        this.addComponent(this.t3);
        this.t4 = new GateComponentTorch(this, 7274677, 0.3125, true).setState(false);
        this.addComponent(this.t4);
        this.wire = new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.wire);
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public void doLogic() {
        this.buf.set(0, (Object)(!((GateConnectionDigital)this.left()).isEnabled() || ((GateConnectionDigital)this.left()).getInput() ? 1 : 0));
        this.buf.set(1, (Object)(!((GateConnectionDigital)this.back()).isEnabled() || ((GateConnectionDigital)this.back()).getInput() ? 1 : 0));
        this.buf.set(2, (Object)(!((GateConnectionDigital)this.right()).isEnabled() || ((GateConnectionDigital)this.right()).getInput() ? 1 : 0));
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.buf.shift();
        boolean pow = (Boolean)this.buf.get(0) != false && (Boolean)this.buf.get(1) != false && (Boolean)this.buf.get(2) != false;
        this.t1.setState((Boolean)this.buf.get(0) == false);
        this.t2.setState((Boolean)this.buf.get(1) == false);
        this.t3.setState((Boolean)this.buf.get(2) == false);
        this.wire.setPower((byte)(!pow ? 255 : 0));
        this.buf.set(3, (Object)pow);
        this.t4.setState((Boolean)this.buf.get(3));
        this.buf.set(4, this.buf.get(3));
        ((GateConnectionDigital)this.front()).setOutput((Boolean)this.buf.get(4));
    }

    @Override
    public boolean changeMode() {
        if (this.getWorld().field_72995_K) {
            return true;
        }
        if (((GateConnectionDigital)this.left()).isEnabled() && ((GateConnectionDigital)this.back()).isEnabled() && ((GateConnectionDigital)this.right()).isEnabled()) {
            ((GateConnectionDigital)this.right()).disable();
        } else if (((GateConnectionDigital)this.left()).isEnabled() && ((GateConnectionDigital)this.back()).isEnabled()) {
            ((GateConnectionDigital)this.back()).disable();
            ((GateConnectionDigital)this.right()).enable();
        } else if (((GateConnectionDigital)this.left()).isEnabled() && ((GateConnectionDigital)this.right()).isEnabled()) {
            ((GateConnectionDigital)this.left()).disable();
            ((GateConnectionDigital)this.back()).enable();
        } else if (((GateConnectionDigital)this.back()).isEnabled() && ((GateConnectionDigital)this.right()).isEnabled()) {
            ((GateConnectionDigital)this.left()).enable();
            ((GateConnectionDigital)this.back()).disable();
            ((GateConnectionDigital)this.right()).disable();
        } else if (((GateConnectionDigital)this.left()).isEnabled()) {
            ((GateConnectionDigital)this.left()).disable();
            ((GateConnectionDigital)this.back()).enable();
        } else if (((GateConnectionDigital)this.back()).isEnabled()) {
            ((GateConnectionDigital)this.back()).disable();
            ((GateConnectionDigital)this.right()).enable();
        } else {
            ((GateConnectionDigital)this.left()).enable();
            ((GateConnectionDigital)this.back()).enable();
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> info) {
        info.add((Object)((Object)Color.YELLOW) + I18n.func_135052_a((String)"waila.bluepower:gate.connections", (Object[])new Object[0]) + ":");
        info.add("  " + Dir.LEFT.getLocalizedName() + ": " + (((GateConnectionDigital)this.left()).isEnabled() ? (Object)((Object)Color.GREEN) + I18n.func_135052_a((String)"bluepower:misc.enabled", (Object[])new Object[0]) : (Object)((Object)Color.RED) + I18n.func_135052_a((String)"bluepower:misc.disabled", (Object[])new Object[0])));
        info.add("  " + Dir.BACK.getLocalizedName() + ": " + (((GateConnectionDigital)this.back()).isEnabled() ? (Object)((Object)Color.GREEN) + I18n.func_135052_a((String)"bluepower:misc.enabled", (Object[])new Object[0]) : (Object)((Object)Color.RED) + I18n.func_135052_a((String)"bluepower:misc.disabled", (Object[])new Object[0])));
        info.add("  " + Dir.RIGHT.getLocalizedName() + ": " + (((GateConnectionDigital)this.right()).isEnabled() ? (Object)((Object)Color.GREEN) + I18n.func_135052_a((String)"bluepower:misc.enabled", (Object[])new Object[0]) : (Object)((Object)Color.RED) + I18n.func_135052_a((String)"bluepower:misc.disabled", (Object[])new Object[0])));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.buf.writeToNBT(tag, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.buf.readFromNBT(tag, "buffer");
    }
}

